/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.screenshotUtils;

import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientCommon;
import io.github.axolotlclient.api.API;
import io.github.axolotlclient.api.util.UUIDHelper;
import io.github.axolotlclient.modules.screenshotUtils.GalleryScreen;
import io.github.axolotlclient.modules.screenshotUtils.ImageInstance;
import io.github.axolotlclient.modules.screenshotUtils.ImageShare;
import io.github.axolotlclient.modules.screenshotUtils.LoadingImageScreen;
import io.github.axolotlclient.modules.screenshotUtils.ScreenshotCopying;
import io.github.axolotlclient.util.GsonHelper;
import io.github.axolotlclient.util.notifications.Notifications;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_6382;
import net.minecraft.class_7842;
import net.minecraft.class_7852;
import net.minecraft.class_8021;
import net.minecraft.class_8132;
import net.minecraft.class_8667;

public class ImageScreen
extends class_437 {
    private final class_437 parent;
    private final ImageInstance image;
    private final boolean freeOnClose;

    static class_437 create(class_437 parent, CompletableFuture<ImageInstance> future, boolean freeOnClose) {
        if (future.isDone()) {
            if (future.join() != null) {
                return new ImageScreen(parent, future.join(), freeOnClose);
            }
            return parent;
        }
        return new LoadingImageScreen(parent, (CompletableFuture<Void>)future.thenAccept(i -> {
            if (i != null) {
                class_310.method_1551().execute(() -> class_310.method_1551().method_1507((class_437)new ImageScreen(parent, (ImageInstance)i, freeOnClose)));
            } else {
                class_310.method_1551().execute(() -> class_310.method_1551().method_1507(parent));
            }
        }), freeOnClose);
    }

    private ImageScreen(class_437 parent, ImageInstance instance, boolean freeOnClose) {
        super((class_2561)class_2561.method_43470((String)instance.filename()));
        this.parent = parent;
        this.image = instance;
        this.freeOnClose = freeOnClose;
    }

    protected void method_25426() {
        class_8132 layout = new class_8132((class_437)this);
        class_8667 header = ((class_8667)layout.method_48992((class_8021)class_8667.method_52741())).method_52735(4);
        header.method_52740().method_46467();
        header.method_52736((class_8021)new class_7842(this.method_25440(), this.field_22793));
        ImageInstance imageInstance = this.image;
        if (imageInstance instanceof ImageInstance.Remote) {
            ImageInstance.Remote remote = (ImageInstance.Remote)imageInstance;
            layout.method_48995(38);
            class_7842 uploader = (class_7842)header.method_52736((class_8021)new class_7842((class_2561)class_2561.method_43469((String)"gallery.image.upload_details", (Object[])new Object[]{"", remote.sharedAt().atZone(ZoneId.systemDefault()).format(AxolotlClientCommon.getInstance().getConfig().getDateTimeFormatter())}), this.field_22793));
            UUIDHelper.tryGetUsernameAsync((String)remote.uploader()).thenAccept(name -> {
                uploader.method_25355((class_2561)class_2561.method_43469((String)"gallery.image.upload_details", (Object[])new Object[]{name, remote.sharedAt().atZone(ZoneId.systemDefault()).format(AxolotlClientCommon.getInstance().getConfig().getDateTimeFormatter())}));
                uploader.method_25358(this.field_22793.method_27525((class_5348)uploader.method_25369()));
            });
        }
        int buttonWidth = 75;
        double imgAspectRatio = (double)this.image.image().method_4307() / (double)this.image.image().method_4323();
        int imageWidth = Math.min((int)((double)layout.method_57727() * imgAspectRatio), layout.method_25368() - buttonWidth - 4 - 20);
        int imageHeight = (int)((double)imageWidth / imgAspectRatio);
        class_8667 contents = (class_8667)layout.method_48999((class_8021)class_8667.method_52742().method_52735(4));
        if (this.field_22789 / 2 > imageWidth / 2 + buttonWidth + 4) {
            contents.method_52736((class_8021)new class_7852(buttonWidth + 4, imageHeight));
        }
        class_8667 footer = (class_8667)layout.method_48996((class_8021)class_8667.method_52742().method_52735(4));
        contents.method_52736((class_8021)new ImageElement(imageWidth, imageHeight));
        class_8667 actions = ((class_8667)contents.method_52736((class_8021)class_8667.method_52741())).method_52735(4);
        ImageInstance imageInstance2 = this.image;
        if (imageInstance2 instanceof ImageInstance.Local) {
            ImageInstance.Local local = (ImageInstance.Local)imageInstance2;
            if (API.getInstance().isAuthenticated() && !(this.image instanceof ImageInstance.Remote)) {
                actions.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gallery.image.upload"), b -> {
                    b.field_22763 = false;
                    ImageShare.getInstance().upload(local.location()).thenAccept(s -> {
                        if (s.isEmpty()) {
                            Notifications.getInstance().addStatus("gallery.image.upload.failure", "gallery.image.upload.failure.description", new Object[0]);
                        } else {
                            this.field_22787.execute(() -> this.field_22787.method_1507((class_437)new ImageScreen(this.parent, local.toShared((String)s, API.getInstance().getSelf().getUuid(), Instant.now()), this.freeOnClose)));
                            this.field_22787.field_1774.method_1455(s);
                            Notifications.getInstance().addStatus("gallery.image.upload.success", "gallery.image.upload.success.description", s);
                        }
                    });
                }).method_46432(buttonWidth).method_46431());
            }
            actions.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gallery.image.copy"), b -> ScreenshotCopying.copy((Path)local.location())).method_46432(buttonWidth).method_46431());
            actions.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gallery.image.open.external"), b -> class_156.method_668().method_673(local.location().toUri())).method_46432(buttonWidth).method_46431());
        }
        if ((imageInstance2 = this.image) instanceof ImageInstance.Remote) {
            ImageInstance.Remote remote = (ImageInstance.Remote)imageInstance2;
            if (!(this.image instanceof ImageInstance.Local)) {
                actions.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gallery.image.save"), b -> {
                    b.field_22763 = false;
                    try {
                        Path out = this.saveSharedImage(remote);
                        this.field_22787.method_1507((class_437)new ImageScreen(this.parent, remote.toShared(out), this.freeOnClose));
                    }
                    catch (IOException e) {
                        Notifications.getInstance().addStatus("gallery.image.save.failure", "gallery.image.save.failure.description", e.getMessage());
                        AxolotlClient.LOGGER.warn("Failed to save shared image!", new Object[]{e});
                    }
                }).method_46432(buttonWidth).method_46431());
                actions.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gallery.image.copy"), b -> {
                    try {
                        ScreenshotCopying.copy((byte[])this.image.image().method_24036());
                    }
                    catch (IOException e) {
                        Notifications.getInstance().addStatus("gallery.image.copy.failure", "gallery.image.copy.failure.description", e.getMessage());
                        AxolotlClient.LOGGER.warn("Failed to copy shared image!", new Object[]{e});
                    }
                }).method_46432(buttonWidth).method_46431());
            }
            actions.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gallery.image.open.external.browser"), b -> class_156.method_668().method_670(remote.url())).method_46432(buttonWidth).method_46431());
            actions.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gallery.image.copy_url"), b -> this.field_22787.field_1774.method_1455(remote.url())).method_46432(buttonWidth).method_46431());
        }
        footer.method_52736((class_8021)class_4185.method_46430((class_2561)class_5244.field_24339, b -> this.method_25419()).method_46431());
        layout.method_48222();
        layout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
    }

    public void method_25419() {
        if (this.freeOnClose) {
            this.field_22787.method_1531().method_4615(this.image.id());
        }
        this.field_22787.method_1507(this.parent);
    }

    private Path saveSharedImage(ImageInstance.Remote remote) throws IOException {
        Path out = GalleryScreen.SCREENSHOTS_DIR.resolve("shared").resolve(remote.uploader()).resolve(remote.filename());
        Path infoJson = out.resolveSibling(remote.filename() + ".json");
        Files.createDirectories(out.getParent(), new FileAttribute[0]);
        remote.image().method_4314(out);
        Map<String, Instant> json = Map.of("uploader", remote.uploader(), "shared_at", remote.sharedAt());
        Files.writeString(infoJson, (CharSequence)GsonHelper.GSON.toJson(json), new OpenOption[0]);
        return out;
    }

    private class ImageElement
    extends class_339 {
        public ImageElement(int width, int height) {
            super(0, 0, width, height, (class_2561)class_2561.method_43473());
            this.field_22763 = false;
        }

        protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            guiGraphics.method_25290(ImageScreen.this.image.id(), this.method_46426(), this.method_46427(), 0.0f, 0.0f, this.method_25368(), this.method_25364(), this.method_25368(), this.method_25364());
        }

        protected void method_47399(class_6382 builder) {
        }
    }
}

