/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api;

import java.util.Collections;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_6379;
import net.minecraft.class_8132;
import com.google.common.collect.ImmutableList;
import io.github.axolotlclient.api.requests.AccountUsernameRequest;
import io.github.axolotlclient.api.types.User;

public class UsernameManagementScreen extends class_437 {

	private final class_8132 layout = new class_8132(this);
	private final class_437 parent;
	private UsernameListWidget widget;

	public UsernameManagementScreen(class_437 parent) {
		super(class_2561.method_43471("api.account.usernames"));
		this.parent = parent;
	}

	@Override
	protected void method_25426() {
		layout.method_48995(45);
		layout.method_48991(55);
		layout.method_57726(method_25440(), this.field_22793);


		layout.method_48996(class_4185.method_46430(class_5244.field_24339, b -> method_25419()).method_46431());
		if (API.getInstance().isAuthenticated()) {
			widget = new UsernameListWidget(API.getInstance().getSelf().getPreviousUsernames());
		} else {
			widget = new UsernameListWidget(Collections.emptyList());
		}
		layout.method_48999(widget);
		layout.method_48222();

		layout.method_48206(this::method_37063);
	}

	@Override
	protected void method_48640() {
		layout.method_48222();
		widget.method_57712(field_22789, layout);
	}

	@Override
	public void method_25419() {
		field_22787.method_1507(parent);
	}

	private class UsernameListWidget extends class_4265<UsernameListWidget.UsernameListEntry> {

		public UsernameListWidget(List<User.OldUsername> names) {
			super(UsernameManagementScreen.this.field_22787, UsernameManagementScreen.this.field_22789, UsernameManagementScreen.this.layout.method_57727(), UsernameManagementScreen.this.layout.method_48998(), 20);

			names.forEach(n -> method_25321(new UsernameListEntry(n)));
		}

		@Override
		public int method_25322() {
			return 310;
		}

		private class UsernameListEntry extends class_4265.class_4266<UsernameListEntry> {

			private final class_4185 visibility;
			private final class_4185 delete;
			private final String name;

			public UsernameListEntry(User.OldUsername name) {
				visibility = class_4185.method_46430(class_2561.method_43469("api.account.usernames.public", name.isPub()), w -> {
					name.setPub(!name.isPub());
					w.method_25355(class_2561.method_43469("api.account.usernames.public", name.isPub()));
					AccountUsernameRequest.post(name.getName(), name.isPub());
				}).method_46432(100).method_46431();
				delete = class_4185.method_46430(class_2561.method_43471("api.account.usernames.delete"), w ->
					field_22740.method_1507(new class_410(b -> {
						if (b) {
							AccountUsernameRequest.delete(name.getName()).thenRun(() ->
								UsernameListWidget.this.method_25330(this));
						}
						field_22740.method_1507(UsernameManagementScreen.this);
					}, class_2561.method_43471("api.account.confirm_deletion"),
						class_2561.method_43471("api.account.usernames.delete.desc")))).method_46432(100).method_46431();
				this.name = name.getName();
			}

			@Override
			public List<? extends class_6379> method_37025() {
				return ImmutableList.of(visibility, delete);
			}

			@Override
			public List<? extends class_364> method_25396() {
				return List.of(visibility, delete);
			}

			@Override
			public void method_25343(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
				int deleteX = UsernameListWidget.this.method_25329() - delete.method_25368() - 10;
				delete.method_48229(deleteX, y - 2);
				visibility.method_48229(deleteX - visibility.method_25368() - 5, y - 2);
				delete.method_25394(graphics, mouseX, mouseY, tickDelta);
				visibility.method_25394(graphics, mouseX, mouseY, tickDelta);
				graphics.method_25303(field_22793, name, x, y + entryHeight / 2 - 9 / 2, -1);
			}
		}
	}
}
