/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin;

import java.util.function.Supplier;
import net.minecraft.class_1068;
import net.minecraft.class_310;
import net.minecraft.class_640;
import net.minecraft.class_8685;
import com.mojang.authlib.GameProfile;
import io.github.axolotlclient.modules.hypixel.NickHider;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_640.class)
public abstract class PlayerListEntryMixin {

	@Inject(method = "getSkinSupplier", at = @At("RETURN"), cancellable = true)
	private static void axolotlclient$hideSkins(GameProfile gameProfile, CallbackInfoReturnable<Supplier<class_8685>> cir) {
		if (gameProfile.equals(class_310.method_1551().field_1724.method_7334())
			&& NickHider.getInstance().hideOwnSkin.get()) {
			cir.setReturnValue(() -> class_1068.method_4648(gameProfile.getId()));
		} else if (!gameProfile.equals(class_310.method_1551().field_1724.method_7334())
			&& NickHider.getInstance().hideOtherSkins.get()) {
			cir.setReturnValue(() -> class_1068.method_4648(gameProfile.getId()));
		}
	}
}
