/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.auth;

import java.util.UUID;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;

public class AddOfflineScreen extends class_437 {

	private final class_437 parent;
	private class_342 nameInput;

	public AddOfflineScreen(class_437 parent) {
		super(class_2561.method_43471("auth.add.offline"));
		this.parent = parent;
	}

	@Override
	public void method_25394(class_332 graphics, int i, int j, float f) {
		super.method_25394(graphics, i, j, f);
		graphics.method_27535(field_22793, class_2561.method_43471("auth.add.offline.name"), (int) (field_22789 / 2F - 100), (int) (field_22790 / 2f - 20), -1);
		graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 20, 16777215);
	}

	@Override
	public void method_25426() {
		method_37063(nameInput = new class_342(field_22793, field_22789 / 2 - 100, field_22790 / 2 - 10, 200, 20, class_2561.method_43473()));

		method_37063(new class_4185.class_7840(class_5244.field_24335, button -> field_22787.method_1507(parent)).method_46434(field_22789 / 2 - 155, field_22790 - 50, 150, 20).method_46431());
		method_37063(new class_4185.class_7840(class_5244.field_24334, button -> {
			Auth.getInstance().addAccount(new Account(nameInput.method_1882(), UUID.randomUUID().toString(), Account.OFFLINE_TOKEN));
			field_22787.method_1507(parent);
		}).method_46434(field_22789 / 2 + 5, field_22790 - 50, 150, 20).method_46431());
	}
}
