/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.hud;

import io.github.axolotlclient.AxolotlClientConfig.impl.util.ConfigStyles;
import io.github.axolotlclient.modules.hud.gui.component.HudEntry;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import io.github.axolotlclient.util.ClientColors;
import lombok.RequiredArgsConstructor;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import net.minecraft.class_8030;
import net.minecraft.client.gui.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RequiredArgsConstructor
public class HudEntryWidget implements class_4068, class_364, class_6379 {

	private final HudEntry entry;
	private boolean focused, moving;

	@Override
	public void method_25365(boolean focused) {
		this.focused = focused;
		if (!focused) {
			moving = false;
		}
	}

	@Override
	public boolean method_25370() {
		return entry.isEnabled() && focused;
	}

	@Override
	public class_6380 method_37018() {
		return method_25370() ? class_6380.field_33786 : (entry.isHovered() ? class_6380.field_33785 : class_6380.field_33784);
	}

	@Override
	public void method_37020(class_6382 narrationElementOutput) {
		narrationElementOutput.method_37034(class_6381.field_33788, class_2561.method_43469("hud.entry.name", entry.getName()));
		if (moving) {
			narrationElementOutput.method_37034(class_6381.field_33791, class_2561.method_43471("hud.entry.usage.move"));
		} else {
			narrationElementOutput.method_37034(class_6381.field_33791, class_2561.method_43471("hud.entry.usage"));
		}
	}

	@Override
	public @NotNull class_8030 method_48202() {
		if (!entry.isEnabled()) {
			return class_8030.method_48248();
		}
		return new class_8030(entry.getTrueX(), entry.getTrueY(), entry.getTrueWidth(), entry.getTrueHeight());
	}

	@Override
	public boolean method_25405(double mouseX, double mouseY) {
		return entry.isEnabled() && entry.isHovered();
	}

	@Override
	public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
		if (method_25370()) {
			var bounds = entry.getTrueBounds();
			DrawUtil.outlineRect(guiGraphics, bounds.x() - 1, bounds.y() - 1, bounds.width() + 2, bounds.height() + 2, moving ? ClientColors.SELECTOR_RED.toInt() : -1);
		}
	}

	@Nullable
	@Override
	public class_8016 method_48205(class_8023 event) {
		if (!entry.isEnabled()) {
			return null;
		} else {
			return !this.method_25370() ? class_8016.method_48193(this) : null;
		}
	}

	@Override
	public boolean method_25404(int keyCode, int scanCode, int modifiers) {
		var mc = class_310.method_1551();
		boolean consume = false;
		if (moving) {
			consume = true;
			int step = class_437.method_25441() ? 10 : 1;
			if (keyCode == class_3675.field_31958 || keyCode == class_3675.field_31947) {
				moving = false;
			} else if (keyCode == class_3675.field_31932) {
				entry.setY(entry.getRawTrueY() - step + entry.offsetTrueHeight());
			} else if (keyCode == class_3675.field_31982) {
				entry.setY(entry.getRawTrueY() + step + entry.offsetTrueHeight());
			} else if (keyCode == class_3675.field_31983) {
				entry.setX(entry.getRawTrueX() - step + entry.offsetTrueWidth());
			} else if (keyCode == class_3675.field_31984) {
				entry.setX(entry.getRawTrueX() + step + entry.offsetTrueWidth());
			} else {
				consume = false;
			}
		}
		if (consume) {
			return true;
		}
		consume = true;
		if (keyCode == class_3675.field_31947) {
			moving = true;
		} else if (keyCode == class_3675.field_31957 || keyCode == class_3675.field_31980) {
			mc.method_1507(ConfigStyles.createScreen(mc.field_1755, entry.getCategory()));
		} else {
			consume = false;
		}
		return consume;
	}
}
