/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.hud.gui.hud.vanilla;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1259;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_345;
import net.minecraft.class_3532;
import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.EnumOption;
import io.github.axolotlclient.bridge.render.AxoRenderContext;
import io.github.axolotlclient.mixin.BossBarHudAccessor;
import io.github.axolotlclient.modules.hud.gui.component.DynamicallyPositionable;
import io.github.axolotlclient.modules.hud.gui.entry.TextHudEntry;
import io.github.axolotlclient.modules.hud.gui.layout.AnchorPoint;
import io.github.axolotlclient.modules.hud.util.DefaultOptions;
import io.github.axolotlclient.modules.hud.util.DrawPosition;

/**
 * This implementation of Hud modules is based on KronHUD.
 * <a href="https://github.com/DarkKronicle/KronHUD">Github Link.</a>
 *
 * <p>License: GPL-3.0</p>
 */

public class BossBarHud extends TextHudEntry implements DynamicallyPositionable {

	public static final class_2960 ID = class_2960.method_60655("kronhud", "bossbarhud");
	private static final class_2960 BARS_TEXTURE = class_2960.method_60656("textures/gui/bars.png");
	private final class_1259 placeholder = new CustomBossBar(class_2561.method_43470("Boss bar"), class_1259.class_1260.field_5786,
		class_1259.class_1261.field_5795);
	private final class_1259 placeholder2 = class_156.method_656(() -> {
		class_1259 boss = new CustomBossBar(class_2561.method_43470("More boss bars..."), class_1259.class_1260.field_5783,
			class_1259.class_1261.field_5795);
		boss.method_5408(0.45F);
		return boss;
	});
	private final BooleanOption text = new BooleanOption("text", true);
	private final BooleanOption bar = new BooleanOption("bar", true);
	// TODO custom color
	private final EnumOption<AnchorPoint> anchor = DefaultOptions.getAnchorPoint();
	private Map<UUID, class_345> bossBars = new HashMap<>();
	private final class_310 client = (class_310) super.client;

	public BossBarHud() {
		super(184, 80, false);
	}

	@Override
	public void renderComponent(AxoRenderContext graphics, float delta) {
		setBossBars();
		if (bossBars == null || this.bossBars.isEmpty()) {
			return;
		}
		DrawPosition scaledPos = getPos();
		int by = 12;
		for (class_345 bossBar : bossBars.values()) {
			renderBossBar((class_332) graphics, scaledPos.x(), by + scaledPos.y(), bossBar);
			by = by + 19;
			if (by > getHeight()) {
				break;
			}
		}
	}

	public void setBossBars() {
		int prevLength = bossBars.size();
		bossBars = ((BossBarHudAccessor) client.field_1705.method_1740()).axolotlclient$getBossBars();
		if (bossBars != null && bossBars.size() != prevLength) {
			if (bossBars.isEmpty()) {
				// Just leave it alone, it's not rendering anyway
				return;
			}
			// Update height
			setHeight(12 + prevLength * 19);
		}
	}

	private void renderBossBar(class_332 graphics, int x, int y, class_1259 bossBar) {
		if (bar.get()) {
			graphics.method_25290(BARS_TEXTURE, x, y, 0, bossBar.method_5420().ordinal() * 5 * 2, 182, 5, 256, 256);
			if (bossBar.method_5415() != class_1259.class_1261.field_5795) {
				graphics.method_25290(BARS_TEXTURE, x, y, 0, 80 + (bossBar.method_5415().ordinal() - 1) * 5 * 2, 182, 5,
					256, 256);
			}

			int i = (int) (bossBar.method_5412() * 183.0F);
			if (i > 0) {
				graphics.method_25290(BARS_TEXTURE, x, y, 0, bossBar.method_5420().ordinal() * 5 * 2 + 5, i, 5, 256, 256);
				if (bossBar.method_5415() != class_1259.class_1261.field_5795) {
					graphics.method_25290(BARS_TEXTURE, x, y, 0, 80 + (bossBar.method_5415().ordinal() - 1) * 5 * 2 + 5,
						i, 5, 256, 256);
				}
			}
		}
		if (text.get()) {
			class_2561 text = bossBar.method_5414();
			float textX = x + ((float) getWidth() / 2) - ((float) client.field_1772.method_27525(text) / 2);
			float textY = y - 9;
			graphics.method_51439(client.field_1772, text, (int) textX, (int) textY, textColor.get().toInt(), shadow.get());
		}
	}

	@Override
	public void renderPlaceholderComponent(AxoRenderContext graphics, float delta) {
		DrawPosition pos = getPos();
		renderBossBar((class_332) graphics, pos.x(), pos.y() + 12, placeholder);
		renderBossBar((class_332) graphics, pos.x(), pos.y() + 31, placeholder2);
	}

	@Override
	public class_2960 getId() {
		return ID;
	}

	@Override
	public List<Option<?>> getConfigurationOptions() {
		List<Option<?>> options = super.getConfigurationOptions();
		options.add(hide);
		options.add(text);
		options.add(bar);
		options.add(anchor);
		return options;
	}

	@Override
	public AnchorPoint getAnchor() {
		return (anchor.get());
	}

	public static class CustomBossBar extends class_1259 {

		public CustomBossBar(class_2561 name, class_1260 color, class_1261 style) {
			super(class_3532.method_15394(), name, color, style);
		}
	}
}
