/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.util.notifications;

import java.util.List;

import com.google.common.collect.ImmutableList;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_368;
import net.minecraft.class_374;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;

@Environment(EnvType.CLIENT)
public class AxolotlClientToast extends DrawUtil implements class_368 {
	private static final class_2960 BACKGROUND_SPRITE = class_2960.method_60655("axolotlclient", "toast/axolotlclient");
	private static final int DISPLAY_TIME_MILLIS = 5000;
	private static final int MAX_LINE_SIZE = 200;
	private static final int LINE_SPACING = 12;
	private static final int MARGIN = 10;
	private static final int DEFAULT_WIDTH = 160;
	private final class_2561 title;
	private final List<class_5481> messageLines;
	private final int width;

	public AxolotlClientToast(class_2561 title, @Nullable class_2561 message) {
		this(
			title,
			nullToEmpty(message),
			Math.max(DEFAULT_WIDTH, 15 + (2 * MARGIN) + Math.max(class_310.method_1551().field_1772.method_27525(title), message == null ? 0 : class_310.method_1551().field_1772.method_27525(message)))
		);
	}

	public static AxolotlClientToast multiline(class_310 minecraft, class_2561 title, class_2561 message) {
		class_327 font = minecraft.field_1772;
		List<class_5481> list = font.method_1728(message, MAX_LINE_SIZE);
		int i = Math.min(MAX_LINE_SIZE, Math.max(font.method_27525(title), list.stream().mapToInt(font::method_30880).max().orElse(MAX_LINE_SIZE)));
		return new AxolotlClientToast(title, list, i + (2 * MARGIN) + 15);
	}

	private AxolotlClientToast(class_2561 title, List<class_5481> messageLines, int width) {
		this.title = title;
		this.messageLines = messageLines;
		this.width = width;
	}

	private static ImmutableList<class_5481> nullToEmpty(@Nullable class_2561 message) {
		return message == null ? ImmutableList.of() : ImmutableList.of(message.method_30937());
	}

	@Override
	public int method_29049() {
		return this.width;
	}

	@Override
	public int method_29050() {
		return (2 * MARGIN) + Math.max(this.messageLines.size(), 1) * LINE_SPACING;
	}

	@Override
	public class_369 method_1986(class_332 graphics, class_374 manager, long startTime) {
		graphics.method_52706(BACKGROUND_SPRITE, 0, 0, method_29049(), method_29050());
		graphics.method_25290(AxolotlClient.badgeIcon, 4, 4, 0, 0, 15, 15, 15, 15);
		int textOffset = 22;
		if (this.messageLines.isEmpty()) {
			graphics.method_51439(class_310.method_1551().field_1772, title, textOffset, LINE_SPACING, -256, false);
		} else {
			graphics.method_51439(class_310.method_1551().field_1772, title, textOffset, 7, -256, false);

			for (int i = 0; i < this.messageLines.size(); i++) {
				graphics.method_51430(class_310.method_1551().field_1772, this.messageLines.get(i), textOffset, 18 + i * LINE_SPACING, -1, false);
			}
		}

		double d = (double) DISPLAY_TIME_MILLIS * manager.method_48221();
		return (double) startTime < d ? class_369.field_2210 : class_369.field_2209;
	}
}
