/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.api;

import io.github.axolotlclient.api.AddFriendScreen;
import io.github.axolotlclient.api.UserListWidget;
import io.github.axolotlclient.api.chat.ChatScreen;
import io.github.axolotlclient.api.requests.ChannelRequest;
import io.github.axolotlclient.api.requests.FriendRequest;
import io.github.axolotlclient.api.types.Channel;
import io.github.axolotlclient.api.types.User;
import io.github.axolotlclient.api.util.AlphabeticalComparator;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;

public class FriendsScreen
extends class_437 {
    private final class_437 parent;
    private UserListWidget widget;
    private class_4185 chatButton;
    private class_4185 removeButton;
    private class_4185 onlineTab;
    private class_4185 allTab;
    private class_4185 pendingTab;
    private class_4185 blockedTab;
    private class_4185 denyButton;
    private class_4185 acceptButton;
    private class_4185 unblockButton;
    private class_4185 cancelButton;
    private Tab current = Tab.ONLINE;

    protected FriendsScreen(class_437 parent, Tab tab) {
        this(parent);
        this.current = tab;
    }

    public FriendsScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"api.screen.friends"));
        this.parent = parent;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        super.method_25394(graphics, mouseX, mouseY, delta);
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 20, 0xFFFFFF);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 294) {
            this.refresh();
            return true;
        }
        if (this.widget.method_25334() != null) {
            if (keyCode != 257 && keyCode != 335) {
                return this.widget.method_25404(keyCode, scanCode, modifiers);
            }
            this.openChat();
            return true;
        }
        return false;
    }

    protected void method_25426() {
        this.widget = new UserListWidget(this, this.field_22787, this.field_22789, this.field_22790, 32, this.field_22790 - 64, 35);
        this.method_37063((class_364)this.widget);
        this.widget.method_25396().clear();
        if (this.current == Tab.ALL || this.current == Tab.ONLINE) {
            FriendRequest.getInstance().getFriends().whenCompleteAsync((list, t) -> this.widget.setUsers(list.stream().sorted((u1, u2) -> new AlphabeticalComparator().compare(u1.getName(), u2.getName())).filter(user -> {
                if (this.current == Tab.ONLINE) {
                    return user.getStatus().isOnline();
                }
                return true;
            }).toList()));
        } else if (this.current == Tab.PENDING) {
            FriendRequest.getInstance().getFriendRequests().whenCompleteAsync((con, th) -> {
                ((List)con.getLeft()).stream().sorted((u1, u2) -> new AlphabeticalComparator().compare(u1.getName(), u2.getName())).forEach(user -> this.widget.addEntry(new UserListWidget.UserListEntry((User)user, class_2561.method_43471((String)"api.friends.pending.incoming"))));
                ((List)con.getRight()).stream().sorted((u1, u2) -> new AlphabeticalComparator().compare(u1.getName(), u2.getName())).forEach(user -> this.widget.addEntry(new UserListWidget.UserListEntry((User)user, class_2561.method_43471((String)"api.friends.pending.outgoing")).outgoing()));
            });
        } else if (this.current == Tab.BLOCKED) {
            FriendRequest.getInstance().getBlocked().whenCompleteAsync((list, th) -> this.widget.setUsers(list.stream().sorted((u1, u2) -> new AlphabeticalComparator().compare(u1.getName(), u2.getName())).toList()));
        }
        this.blockedTab = class_4185.method_46430((class_2561)class_2561.method_43471((String)"api.friends.tab.blocked"), button -> this.field_22787.method_1507((class_437)new FriendsScreen(this.parent, Tab.BLOCKED))).method_46434(this.field_22789 / 2 + 24, this.field_22790 - 52, 57, 20).method_46431();
        this.method_37063((class_364)this.blockedTab);
        this.pendingTab = class_4185.method_46430((class_2561)class_2561.method_43471((String)"api.friends.tab.pending"), button -> this.field_22787.method_1507((class_437)new FriendsScreen(this.parent, Tab.PENDING))).method_46434(this.field_22789 / 2 - 34, this.field_22790 - 52, 57, 20).method_46431();
        this.method_37063((class_364)this.pendingTab);
        this.allTab = class_4185.method_46430((class_2561)class_2561.method_43471((String)"api.friends.tab.all"), button -> this.field_22787.method_1507((class_437)new FriendsScreen(this.parent, Tab.ALL))).method_46434(this.field_22789 / 2 - 94, this.field_22790 - 52, 57, 20).method_46431();
        this.method_37063((class_364)this.allTab);
        this.onlineTab = class_4185.method_46430((class_2561)class_2561.method_43471((String)"api.friends.tab.online"), button -> this.field_22787.method_1507((class_437)new FriendsScreen(this.parent, Tab.ONLINE))).method_46434(this.field_22789 / 2 - 154, this.field_22790 - 52, 57, 20).method_46431();
        this.method_37063((class_364)this.onlineTab);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"api.friends.add"), button -> this.field_22787.method_1507((class_437)new AddFriendScreen(this))).method_46434(this.field_22789 / 2 + 88, this.field_22790 - 52, 66, 20).method_46431());
        this.removeButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"api.friends.remove"), button -> {
            UserListWidget.UserListEntry entry = (UserListWidget.UserListEntry)this.widget.method_25334();
            if (entry != null) {
                this.removeButton.field_22763 = false;
                FriendRequest.getInstance().removeFriend(entry.getUser()).thenRun(() -> this.field_22787.method_20493(this::refresh));
            }
        }).method_46434(this.field_22789 / 2 - 50, this.field_22790 - 28, 100, 20).method_46431());
        this.denyButton = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"api.friends.request.deny"), button -> this.denyRequest()).method_46434(this.field_22789 / 2 - 50, this.field_22790 - 28, 48, 20).method_46431();
        this.method_37063((class_364)this.denyButton);
        this.acceptButton = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"api.friends.request.accept"), button -> this.acceptRequest()).method_46434(this.field_22789 / 2 + 2, this.field_22790 - 28, 48, 20).method_46431();
        this.method_37063((class_364)this.acceptButton);
        this.unblockButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"api.users.unblock"), b -> {
            b.field_22763 = false;
            FriendRequest.getInstance().unblockUser(((UserListWidget.UserListEntry)this.widget.method_25334()).getUser()).thenRun(() -> this.field_22787.execute(this::refresh));
        }).method_46434(this.field_22789 / 2 - 50, this.field_22790 - 28, 100, 20).method_46431());
        this.cancelButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24335, b -> {
            b.field_22763 = false;
            FriendRequest.getInstance().cancelFriendRequest(((UserListWidget.UserListEntry)this.widget.method_25334()).getUser()).thenRun(() -> this.field_22787.execute(this::refresh));
        }).method_46434(this.field_22789 / 2 - 50, this.field_22790 - 28, 100, 20).method_46431());
        this.chatButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"api.friends.chat"), button -> this.openChat()).method_46434(this.field_22789 / 2 - 154, this.field_22790 - 28, 100, 20).method_46431();
        this.method_37063((class_364)this.chatButton);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24339, button -> this.field_22787.method_1507(this.parent)).method_46434(this.field_22789 / 2 + 4 + 50, this.field_22790 - 28, 100, 20).method_46431());
        this.updateButtonActivationStates();
    }

    private void refresh() {
        this.field_22787.method_1507((class_437)new FriendsScreen(this.parent));
    }

    private void denyRequest() {
        UserListWidget.UserListEntry entry = (UserListWidget.UserListEntry)this.widget.method_25334();
        if (entry != null) {
            this.denyButton.field_22763 = false;
            FriendRequest.getInstance().denyFriendRequest(entry.getUser()).thenRun(() -> this.field_22787.method_20493(this::refresh));
        }
    }

    private void acceptRequest() {
        UserListWidget.UserListEntry entry = (UserListWidget.UserListEntry)this.widget.method_25334();
        if (entry != null) {
            this.acceptButton.field_22763 = false;
            FriendRequest.getInstance().acceptFriendRequest(entry.getUser()).thenRun(() -> this.field_22787.method_20493(this::refresh));
        }
    }

    private void updateButtonActivationStates() {
        UserListWidget.UserListEntry entry = (UserListWidget.UserListEntry)this.widget.method_25334();
        this.chatButton.field_22763 = entry != null && (this.current == Tab.ALL || this.current == Tab.ONLINE);
        this.removeButton.field_22764 = true;
        this.removeButton.field_22763 = entry != null;
        this.unblockButton.field_22763 = this.removeButton.field_22763;
        this.denyButton.field_22764 = false;
        this.cancelButton.field_22764 = false;
        this.unblockButton.field_22764 = false;
        this.acceptButton.field_22764 = false;
        if (this.current == Tab.ONLINE) {
            this.onlineTab.field_22763 = false;
            this.blockedTab.field_22763 = true;
            this.pendingTab.field_22763 = true;
            this.allTab.field_22763 = true;
        } else if (this.current == Tab.ALL) {
            this.allTab.field_22763 = false;
            this.blockedTab.field_22763 = true;
            this.pendingTab.field_22763 = true;
            this.onlineTab.field_22763 = true;
        } else if (this.current == Tab.PENDING) {
            this.pendingTab.field_22763 = false;
            this.blockedTab.field_22763 = true;
            this.allTab.field_22763 = true;
            this.onlineTab.field_22763 = true;
            this.removeButton.field_22764 = false;
            if (entry != null && entry.isOutgoingRequest()) {
                this.cancelButton.field_22764 = true;
            } else {
                this.denyButton.field_22764 = true;
                this.acceptButton.field_22764 = true;
            }
            this.acceptButton.field_22763 = entry != null;
            this.denyButton.field_22763 = this.acceptButton.field_22763;
        } else if (this.current == Tab.BLOCKED) {
            this.blockedTab.field_22763 = false;
            this.pendingTab.field_22763 = true;
            this.allTab.field_22763 = true;
            this.onlineTab.field_22763 = true;
            this.removeButton.field_22764 = false;
            this.unblockButton.field_22764 = true;
        }
    }

    public void openChat() {
        if (!this.chatButton.field_22763) {
            return;
        }
        UserListWidget.UserListEntry entry = (UserListWidget.UserListEntry)this.widget.method_25334();
        if (entry != null) {
            this.chatButton.field_22763 = false;
            ChannelRequest.getOrCreateDM((User)entry.getUser()).thenAccept(c -> this.field_22787.execute(() -> this.field_22787.method_1507((class_437)new ChatScreen(this, (Channel)c))));
        }
    }

    public void select(UserListWidget.UserListEntry entry) {
        this.widget.method_25313((class_350.class_351)entry);
        this.updateButtonActivationStates();
    }

    public static enum Tab {
        ONLINE,
        ALL,
        PENDING,
        BLOCKED;

    }
}

