/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.api.chat;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.axolotlclient.api.API;
import io.github.axolotlclient.api.ContextMenu;
import io.github.axolotlclient.api.ContextMenuScreen;
import io.github.axolotlclient.api.chat.ChatScreen;
import io.github.axolotlclient.api.handlers.ChatHandler;
import io.github.axolotlclient.api.requests.ChannelRequest;
import io.github.axolotlclient.api.types.Channel;
import io.github.axolotlclient.api.types.ChatMessage;
import io.github.axolotlclient.api.types.User;
import io.github.axolotlclient.modules.auth.Auth;
import io.github.axolotlclient.util.ClientColors;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_410;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class ChatWidget
extends class_4280<ChatLine> {
    private final List<ChatMessage> messages = new ArrayList<ChatMessage>();
    private final Channel channel;
    private final class_310 client;
    private final ContextMenuScreen screen;
    private int x;
    private int y;
    private int width;
    private int height;

    public ChatWidget(Channel channel, int x, int y, int width, int height, ContextMenuScreen screen) {
        super(class_310.method_1551(), width, height, y, 13);
        this.channel = channel;
        this.client = class_310.method_1551();
        this.method_46421(x + 5);
        this.method_25315(false, 0);
        this.screen = screen;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        channel.getMessages().forEach(this::addMessage);
        ChatHandler.getInstance().setMessagesConsumer(chatMessages -> chatMessages.forEach(this::addMessage));
        ChatHandler.getInstance().setMessageConsumer(this::addMessage);
        ChatHandler.getInstance().setEnableNotifications(message -> !message.channelId().equals(channel.getId()));
        this.method_25307(this.method_25331());
    }

    protected int method_25329() {
        return this.x + this.width - 6;
    }

    public int method_25322() {
        return this.width - 60;
    }

    private void addMessage(ChatMessage message) {
        boolean scrollToBottom;
        List list = this.client.field_1772.method_1728((class_5348)class_2561.method_30163((String)message.content()), this.method_25322());
        boolean bl = scrollToBottom = this.method_25341() == (double)this.method_25331();
        if (!this.messages.isEmpty()) {
            ChatMessage prev = this.messages.getLast();
            if (!prev.sender().equals((Object)message.sender()) || !prev.senderDisplayName().equals(message.senderDisplayName())) {
                this.method_25321((class_350.class_351)new NameChatLine(this, message));
            } else if (message.timestamp().getEpochSecond() - prev.timestamp().getEpochSecond() > 150L) {
                this.method_25321((class_350.class_351)new NameChatLine(this, message));
            }
        } else {
            this.method_25321((class_350.class_351)new NameChatLine(this, message));
        }
        list.forEach(t -> this.method_25321((class_350.class_351)new ChatLine((class_5481)t, message)));
        this.messages.add(message);
        this.method_25396().sort(Comparator.comparingLong(c -> c.getOrigin().timestamp().getEpochSecond()));
        if (scrollToBottom) {
            this.method_25307(this.method_25331());
        }
        this.messages.sort(Comparator.comparingLong(value -> value.timestamp().getEpochSecond()));
    }

    private void loadMessages() {
        long before = !this.messages.isEmpty() ? this.messages.getFirst().timestamp().getEpochSecond() : Instant.now().getEpochSecond();
        ChatHandler.getInstance().getMessagesBefore(this.channel, before);
    }

    public boolean method_25401(double mouseX, double mouseY, double amountX, double amountY) {
        double scrollAmount = this.method_25341() - amountY * (double)this.field_22741 / 2.0;
        if (scrollAmount < 0.0) {
            this.loadMessages();
        }
        this.method_25307(scrollAmount);
        return true;
    }

    public void remove() {
        ChatHandler.getInstance().setMessagesConsumer(ChatHandler.DEFAULT_MESSAGES_CONSUMER);
        ChatHandler.getInstance().setMessageConsumer(ChatHandler.DEFAULT_MESSAGE_CONSUMER);
        ChatHandler.getInstance().setEnableNotifications(ChatHandler.DEFAULT);
    }

    protected void method_44398(class_332 graphics, int y, int entryWidth, int entryHeight, int borderColor, int fillColor) {
    }

    protected boolean method_53812(int index) {
        return true;
    }

    @Generated
    public void method_46421(int x) {
        this.x = x;
    }

    @Generated
    public void method_46419(int y) {
        this.y = y;
    }

    @Generated
    public void method_25358(int width) {
        this.width = width;
    }

    @Generated
    public void method_53533(int height) {
        this.height = height;
    }

    @Generated
    public int method_46426() {
        return this.x;
    }

    @Generated
    public int method_46427() {
        return this.y;
    }

    @Generated
    public int method_25368() {
        return this.width;
    }

    @Generated
    public int method_25364() {
        return this.height;
    }

    public class NameChatLine
    extends ChatLine {
        private final String formattedTime;

        public NameChatLine(ChatWidget this$0, ChatMessage message) {
            super(class_2561.method_43470((String)message.senderDisplayName()).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true))).method_30937(), message);
            DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("d/M/yyyy H:mm");
            this.formattedTime = DATE_FORMAT.format(message.timestamp().atZone(ZoneId.systemDefault()));
        }

        @Override
        protected void renderExtras(class_332 graphics, int x, int y, int mouseX, int mouseY) {
            RenderSystem.disableBlend();
            class_2960 texture = Auth.getInstance().getSkinTexture(this.getOrigin().sender().getUuid());
            graphics.method_25293(texture, x - 22, y, 18, 18, 8.0f, 8.0f, 8, 8, 64, 64);
            graphics.method_25293(texture, x - 22, y, 18, 18, 40.0f, 8.0f, 8, 8, 64, 64);
            RenderSystem.enableBlend();
            graphics.method_51433(this.client.field_1772, this.formattedTime, this.client.field_1772.method_30880(this.getContent()) + x + 5, y, ClientColors.GRAY.toInt(), false);
        }
    }

    public class ChatLine
    extends class_4280.class_4281<ChatLine> {
        protected final class_310 client = class_310.method_1551();
        private final class_5481 content;
        private final ChatMessage origin;

        public ChatLine(class_5481 content, ChatMessage origin) {
            this.content = content;
            this.origin = origin;
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (button == 0) {
                ChatWidget.this.method_25313((class_350.class_351)this);
                return true;
            }
            if (button == 1) {
                ContextMenu.Builder builder = ContextMenu.builder().title(class_2561.method_30163((String)this.origin.sender().getName())).spacer();
                if (!this.origin.sender().equals((Object)API.getInstance().getSelf())) {
                    builder.entry((class_2561)class_2561.method_43471((String)"api.friends.chat"), buttonWidget -> ChannelRequest.getOrCreateDM((User)this.origin.sender()).whenCompleteAsync((channel, throwable) -> this.client.execute(() -> this.client.method_1507((class_437)new ChatScreen(ChatWidget.this.screen.getParent(), (Channel)channel))))).spacer();
                }
                builder.entry((class_2561)class_2561.method_43471((String)"api.chat.report.message"), buttonWidget -> {
                    class_437 previous = this.client.field_1755;
                    this.client.method_1507((class_437)new class_410(b -> {
                        if (b) {
                            ChatHandler.getInstance().reportMessage(this.origin);
                        }
                        this.client.method_1507(previous);
                    }, (class_2561)class_2561.method_43471((String)"api.channels.confirm_report"), (class_2561)class_2561.method_43469((String)"api.channels.confirm_report.desc", (Object[])new Object[]{this.origin.content()})));
                }).spacer().entry((class_2561)class_2561.method_43471((String)"action.copy"), buttonWidget -> this.client.field_1774.method_1455(this.origin.content()));
                ChatWidget.this.screen.setContextMenu(builder.build());
                return true;
            }
            return false;
        }

        protected void renderExtras(class_332 graphics, int x, int y, int mouseX, int mouseY) {
        }

        public void method_25343(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            for (ChatLine l : ChatWidget.this.method_25396()) {
                if (!l.getOrigin().equals((Object)this.origin) || !Objects.equals(ChatWidget.this.method_37019(), (Object)l)) continue;
                hovered = true;
                break;
            }
            if (hovered && !ChatWidget.this.screen.hasContextMenu()) {
                graphics.method_25294(x - 2 - 22, y - 2, x + entryWidth + 20, y + entryHeight - 1, 0x33FFFFFF);
                if (index < ChatWidget.this.method_25396().size() - 1 && ((ChatLine)((Object)ChatWidget.this.method_25396().get(index + 1))).getOrigin().equals((Object)this.origin)) {
                    graphics.method_25294(x - 2 - 22, y + entryHeight - 1, x + entryWidth + 20, y + entryHeight + 2, 0x33FFFFFF);
                }
                if (index < ChatWidget.this.method_25396().size() - 1 && !((ChatLine)((Object)ChatWidget.this.method_25396().get(index + 1))).getOrigin().equals((Object)this.origin) || index == ChatWidget.this.method_25396().size() - 1) {
                    graphics.method_25294(x - 2 - 22, y + entryHeight - 1, x + entryWidth + 20, y + entryHeight, 0x33FFFFFF);
                }
            }
            this.renderExtras(graphics, x, y, mouseX, mouseY);
            graphics.method_51430(class_310.method_1551().field_1772, this.content, x, y, -1, false);
        }

        public class_2561 method_37006() {
            return class_2561.method_30163((String)this.origin.content());
        }

        @Generated
        public class_5481 getContent() {
            return this.content;
        }

        @Generated
        public ChatMessage getOrigin() {
            return this.origin;
        }
    }
}

