/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.hud.util;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Color;
import io.github.axolotlclient.modules.hud.util.Rectangle;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_332;
import net.minecraft.class_5944;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.joml.Matrix4f;

public final class RenderUtil {
    public static void drawOutline(class_332 graphics, int x, int y, int width, int height, int color) {
        RenderUtil.fillOutline(graphics, x, y, x + width, y + height, color);
    }

    public static void fillOutline(class_332 graphics, int x, int y, int x2, int y2, int color) {
        RenderUtil.fill(graphics, x, y, x2, y + 1, color);
        RenderUtil.fill(graphics, x, y + 1, x + 1, y2 - 1, color);
        RenderUtil.fill(graphics, x2 - 1, y + 1, x2, y2 - 1, color);
        RenderUtil.fill(graphics, x, y2 - 1, x2, y2, color);
    }

    public static void fill(class_332 graphics, int x1, int y1, int x2, int y2, int color) {
        RenderUtil.fill(graphics.method_51448().method_23760().method_23761(), x1, y1, x2, y2, color);
    }

    public static void fill(Matrix4f matrix, int x1, int y1, int x2, int y2, int color) {
        RenderUtil.fill(matrix, x1, y1, x2, y2, color, class_757::method_34540);
    }

    public static void fill(Matrix4f matrix, int x1, int y1, int x2, int y2, int color, Supplier<class_5944> shaderSupplier) {
        int i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(shaderSupplier);
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y2, 0.0f).method_22915(r, g, b, a);
        bufferBuilder.method_22918(matrix, (float)x2, (float)y2, 0.0f).method_22915(r, g, b, a);
        bufferBuilder.method_22918(matrix, (float)x2, (float)y1, 0.0f).method_22915(r, g, b, a);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y1, 0.0f).method_22915(r, g, b, a);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        RenderSystem.disableBlend();
    }

    public static void drawOutline(class_332 graphics, int x, int y, int width, int height, Color color) {
        RenderUtil.fillOutline(graphics, x, y, x + width, y + height, color);
    }

    public static void fillOutline(class_332 graphics, int x, int y, int x2, int y2, Color color) {
        RenderUtil.fill(graphics, x, y, x2, y + 1, color);
        RenderUtil.fill(graphics, x, y + 1, x + 1, y2 - 1, color);
        RenderUtil.fill(graphics, x2 - 1, y + 1, x2, y2 - 1, color);
        RenderUtil.fill(graphics, x, y2 - 1, x2, y2, color);
    }

    public static void fill(class_332 graphics, int x1, int y1, int x2, int y2, Color color) {
        RenderUtil.fill(graphics.method_51448().method_23760().method_23761(), x1, y1, x2, y2, color);
    }

    public static void fill(Matrix4f matrix, int x1, int y1, int x2, int y2, Color color) {
        int colorInt = RenderUtil.colorPreRender(color);
        float a = (float)(colorInt >> 24 & 0xFF) / 255.0f;
        float r = (float)(colorInt >> 16 & 0xFF) / 255.0f;
        float g = (float)(colorInt >> 8 & 0xFF) / 255.0f;
        float b = (float)(colorInt & 0xFF) / 255.0f;
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y2, 0.0f).method_22915(r, g, b, a);
        bufferBuilder.method_22918(matrix, (float)x2, (float)y2, 0.0f).method_22915(r, g, b, a);
        bufferBuilder.method_22918(matrix, (float)x2, (float)y1, 0.0f).method_22915(r, g, b, a);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y1, 0.0f).method_22915(r, g, b, a);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        RenderUtil.colorPostRender(color);
    }

    public static int colorPreRender(Color color) {
        RenderSystem.setShaderColor((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        return color.toInt();
    }

    public static void colorPostRender(Color color) {
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawVerticalLine(class_332 graphics, int x, int y, int height, int color) {
        RenderUtil.drawRectangle(graphics, x, y, 1, height, color);
    }

    public static void drawRectangle(class_332 graphics, int x, int y, int width, int height, int color) {
        RenderUtil.fill(graphics, x, y, x + width, y + height, color);
    }

    public static void drawHorizontalLine(class_332 graphics, int x, int y, int width, int color) {
        RenderUtil.drawRectangle(graphics, x, y, width, 1, color);
    }

    public static void drawRectangle(class_332 graphics, int x, int y, int width, int height, Color color) {
        RenderUtil.fill(graphics, x, y, x + width, y + height, color);
    }

    public static void fillBlend(class_332 graphics, Rectangle rect, Color color) {
        RenderUtil.fillBlend(graphics, rect.x, rect.y, rect.width, rect.height, color);
    }

    public static void fillBlend(class_332 graphics, int x, int y, int width, int height, Color color) {
        RenderUtil.fillBlend(graphics.method_51448().method_23760().method_23761(), x, y, x + width, y + height, color.toInt());
    }

    public static void fillBlend(Matrix4f matrix, int x1, int y1, int x2, int y2, int color) {
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderSystem.setShader(class_757::method_34540);
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y2, 0.0f).method_22915(red, green, blue, alpha);
        bufferBuilder.method_22918(matrix, (float)x2, (float)y2, 0.0f).method_22915(red, green, blue, alpha);
        bufferBuilder.method_22918(matrix, (float)x2, (float)y1, 0.0f).method_22915(red, green, blue, alpha);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y1, 0.0f).method_22915(red, green, blue, alpha);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
    }

    @Generated
    private RenderUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

