/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.screenshotUtils;

import io.github.axolotlclient.AxolotlClientConfig.api.util.Colors;
import io.github.axolotlclient.api.API;
import io.github.axolotlclient.api.requests.FriendRequest;
import io.github.axolotlclient.api.requests.UserRequest;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import io.github.axolotlclient.modules.screenshotUtils.DownloadImageScreen;
import io.github.axolotlclient.modules.screenshotUtils.ImageInstance;
import io.github.axolotlclient.modules.screenshotUtils.ImageScreen;
import io.github.axolotlclient.modules.screenshotUtils.ImageShare;
import io.github.axolotlclient.util.Watcher;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_4588;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_6379;
import net.minecraft.class_7842;
import net.minecraft.class_7847;
import net.minecraft.class_8021;
import net.minecraft.class_8132;
import net.minecraft.class_8667;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class GalleryScreen
extends class_437 {
    public static final Path SCREENSHOTS_DIR = FabricLoader.getInstance().getGameDir().resolve("screenshots");
    private Tab<?> current;
    private final class_437 parent;
    private final Watcher watcher;
    private static final int entrySpacing = 4;
    private static final int entryWidth = 100;
    private static final int entryHeight = 75;
    private static final int marginLeftRight = 10;

    public GalleryScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"gallery.title"));
        this.parent = parent;
        this.current = Tab.LOCAL;
        this.watcher = Watcher.createSelfTicking((Path)SCREENSHOTS_DIR, () -> {
            if (this.current == Tab.LOCAL) {
                this.method_41843();
            }
        });
    }

    protected void method_25426() {
        int buttonWidth;
        boolean online = API.getInstance().isAuthenticated();
        class_8132 layout = new class_8132((class_437)this);
        layout.method_48995(40);
        class_8667 header = (class_8667)layout.method_48992((class_8021)class_8667.method_52741().method_52735(4));
        header.method_52739().method_46467();
        header.method_52736((class_8021)new class_7842(this.field_22785, this.field_22793));
        if (online) {
            header.method_52736((class_8021)new class_7842(this.current.title(), this.field_22793));
        }
        int columnCount = (this.field_22789 - 20 + 4 - 13) / 104;
        ImageList area = new ImageList(this.field_22787, layout.method_25368(), layout.method_57727(), layout.method_48998(), 79, columnCount);
        layout.method_49000((class_8021)area, class_7847::method_46461);
        this.method_48265((class_364)area);
        CompletableFuture.runAsync(() -> {
            try {
                this.loadTab(this.current, columnCount, area);
            }
            catch (Exception e) {
                class_8667 error = class_8667.method_52741().method_52735(8);
                error.method_52739().method_46474();
                error.method_52736((class_8021)new class_7842((class_2561)class_2561.method_43471((String)"gallery.error.loading"), this.field_22793));
                this.method_48265((class_364)error.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gallery.reload"), b -> this.method_41843()).method_46431()));
                layout.method_48999((class_8021)error);
            }
        });
        class_8667 footer = ((class_8667)layout.method_48996((class_8021)class_8667.method_52742())).method_52735(4);
        footer.method_52739().method_46467();
        int n = buttonWidth = columnCount <= 5 && online ? 100 : 150;
        if (online) {
            class_4185.class_7840 switchTab = this.current == Tab.SHARED ? class_4185.method_46430((class_2561)class_2561.method_43471((String)"gallery.tab.local"), b -> this.setTab(Tab.LOCAL)) : class_4185.method_46430((class_2561)class_2561.method_43471((String)"gallery.tab.shared"), b -> this.setTab(Tab.SHARED));
            footer.method_52736((class_8021)switchTab.method_46432(buttonWidth).method_46431());
        }
        footer.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gallery.download_external"), b -> this.field_22787.method_1507((class_437)new DownloadImageScreen(this))).method_46432(buttonWidth).method_46431());
        footer.method_52736((class_8021)class_4185.method_46430((class_2561)class_5244.field_24339, b -> this.method_25419()).method_46432(buttonWidth).method_46431());
        layout.method_48222();
        layout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
    }

    public void method_25419() {
        Tab.LOCAL.loadingCache().forEach((path, instance) -> {
            if (instance != null) {
                this.field_22787.method_1531().method_4615(instance.id());
            }
        });
        Tab.LOCAL.loadingCache().clear();
        Tab.SHARED.loadingCache().forEach((s, instance) -> {
            if (instance != null) {
                this.field_22787.method_1531().method_4615(instance.id());
            }
        });
        Tab.SHARED.loadingCache().clear();
        Watcher.close((Watcher)this.watcher);
        this.field_22787.method_1507(this.parent);
    }

    private void setTab(Tab<?> tab) {
        this.current = tab;
        this.method_41843();
    }

    private <T> void loadTab(Tab<T> tab, int columnCount, ImageList area) throws Exception {
        List images = tab.list.call();
        int size = images.size();
        for (int i = 0; i < size; i += columnCount) {
            ImageListEntry row = new ImageListEntry(columnCount, area);
            area.addEntry(row);
            for (int x = 0; x < columnCount && i + x < size; ++x) {
                Object p = images.get(i + x);
                ImageEntry entry = new ImageEntry(100, 75, () -> tab.loader.load(p), row);
                row.add(entry);
            }
        }
    }

    private record Tab<T>(class_2561 title, Callable<List<T>> list, Map<T, ImageInstance> loadingCache, Loader<T> loader) {
        private static final Tab<Path> LOCAL = Tab.of((class_2561)class_2561.method_43471((String)"gallery.title.local"), () -> {
            try (Stream<Path> screenshots = Files.list(SCREENSHOTS_DIR);){
                List<Path> list = screenshots.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).sorted(Comparator.comparingLong(p -> {
                    try {
                        return Files.getLastModifiedTime(p, new LinkOption[0]).toMillis();
                    }
                    catch (IOException e) {
                        return 0L;
                    }
                }).reversed()).toList();
                return list;
            }
        }, ImageInstance.LocalImpl::new);
        private static final Tab<String> SHARED = Tab.of((class_2561)class_2561.method_43471((String)"gallery.title.shared"), () -> (List)((CompletableFuture)FriendRequest.getInstance().getFriendUuids().thenApply(res -> res.stream().map(UserRequest::getUploadedImages).map(CompletableFuture::join).filter(Optional::isPresent).map(Optional::get).reduce(new ArrayList(), (l1, l2) -> {
            l1.addAll(l2);
            return l1;
        }))).join(), url -> ImageShare.getInstance().downloadImage((String)url).join());

        private static <T> Tab<T> of(class_2561 title, Callable<List<T>> list, Loader<T> loader) {
            HashMap cache = new HashMap();
            return new Tab<Object>(title, list, cache, o -> {
                if (cache.containsKey(o)) {
                    return (ImageInstance)cache.get(o);
                }
                ImageInstance val = loader.load(o);
                cache.put(o, val);
                return val;
            });
        }

        static interface Loader<T> {
            public ImageInstance load(T var1) throws Exception;
        }
    }

    private static class ImageList
    extends class_4265<ImageListEntry> {
        private final int rowWidth;

        public ImageList(class_310 minecraft, int i, int j, int k, int l, int columns) {
            super(minecraft, i, j, k, l);
            this.rowWidth = columns * 104 - 4;
        }

        public int addEntry(ImageListEntry entry) {
            return super.method_25321((class_350.class_351)entry);
        }

        public int method_25322() {
            return this.rowWidth;
        }

        public int method_25342() {
            return this.method_46426() + this.field_22758 / 2 - this.method_25322() / 2;
        }

        public boolean removeEntry(ImageListEntry entry) {
            return super.method_25330((class_350.class_351)entry);
        }

        public void shiftEntries(ImageListEntry origin) {
            int lastIndex;
            int originIndex = this.method_25396().indexOf((Object)origin);
            if (originIndex == (lastIndex = this.method_25396().size() - 1)) {
                return;
            }
            ImageListEntry next = (ImageListEntry)this.method_25326(originIndex + 1);
            origin.add(next.pop());
        }
    }

    private static class ImageListEntry
    extends class_4265.class_4266<ImageListEntry> {
        private final List<ImageEntry> buttons;
        private final int size;
        private final ImageList list;

        public ImageListEntry(int size, ImageList list) {
            this.size = size;
            this.buttons = new ArrayList<ImageEntry>(size);
            this.list = list;
        }

        @NotNull
        public List<? extends class_6379> method_37025() {
            return this.buttons;
        }

        public void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            if (Math.max(left, this.list.method_46426()) <= Math.min(left + width, this.list.method_46426() + this.list.method_25368()) - 1 && Math.max(top - height, this.list.method_46427()) <= Math.min(top + height * 2, this.list.method_46427() + this.list.method_25364()) - 1) {
                this.buttons.forEach(e -> {
                    e.method_46419(top);
                    e.method_25394(guiGraphics, mouseX, mouseY, partialTick);
                });
            } else {
                this.buttons.forEach(e -> e.method_46419(top));
            }
        }

        public void add(ImageEntry e) {
            this.buttons.add(e);
            this.repositionButtons();
        }

        public void remove(ImageEntry e) {
            this.buttons.remove((Object)e);
            if (this.buttons.isEmpty()) {
                this.list.removeEntry(this);
            } else if (this.buttons.size() < this.size) {
                this.list.shiftEntries(this);
            }
            this.repositionButtons();
        }

        private void repositionButtons() {
            int x = this.list.method_25342();
            for (ImageEntry e : this.buttons) {
                e.method_46421(x);
                x += e.method_25368() + 4;
            }
        }

        public ImageEntry pop() {
            ImageEntry entry = this.buttons.removeFirst();
            if (this.buttons.isEmpty()) {
                this.list.removeEntry(this);
                this.list.method_60322();
            } else if (this.buttons.size() < this.size) {
                this.list.shiftEntries(this);
            }
            this.repositionButtons();
            return entry;
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            return this.buttons;
        }
    }

    private class ImageEntry
    extends class_4185 {
        private static final int bgColor = Colors.DARK_GRAY.toInt();
        private static final int accent = Colors.GRAY.withBrightness(0.5f).withAlpha(128).toInt();
        private final class_327 font;
        private final Callable<ImageInstance> instanceSupplier;
        private final ImageListEntry row;
        private long loadStart;
        private CompletableFuture<ImageInstance> future;

        protected ImageEntry(int width, int height, Callable<ImageInstance> instanceSupplier, ImageListEntry row) {
            super(0, 0, width, height, (class_2561)class_2561.method_43473(), b -> {}, field_40754);
            this.instanceSupplier = instanceSupplier;
            this.row = row;
            this.font = class_310.method_1551().field_1772;
        }

        private CompletableFuture<ImageInstance> load() {
            if (this.future == null) {
                this.loadStart = class_156.method_658();
                this.future = CompletableFuture.supplyAsync(() -> {
                    try {
                        ImageInstance instance = this.instanceSupplier.call();
                        this.method_25355((class_2561)class_2561.method_43470((String)instance.filename()));
                        return instance;
                    }
                    catch (Exception e) {
                        GalleryScreen.this.field_22787.execute(() -> this.row.remove(this));
                        return null;
                    }
                });
            }
            return this.future;
        }

        public void method_25306() {
            GalleryScreen.this.field_22787.method_1507(ImageScreen.create(GalleryScreen.this, this.load(), false));
        }

        protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            if (this.load().isDone() && this.load().join() != null) {
                class_2960 class_29602 = this.load().join().id();
                int n = this.method_46426();
                int n2 = this.method_46427();
                int n3 = this.method_25368();
                int n4 = this.method_25364();
                Objects.requireNonNull(this.font);
                int n5 = n4 - 9 - 2;
                int n6 = this.method_25368();
                int n7 = this.method_25364();
                Objects.requireNonNull(this.font);
                guiGraphics.method_25290(class_29602, n, n2, 0.0f, 0.0f, n3, n5, n6, n7 - 9 - 2);
                this.method_48589(guiGraphics, this.font, -1);
            } else {
                float delta = (float)this.easeInOutCubic((float)(class_156.method_658() - this.loadStart) % 1000.0f / 1000.0f);
                int n = this.method_46426() + 2;
                int n8 = this.method_46427() + 2;
                int n9 = this.method_55442() - 2;
                int n10 = this.method_55443();
                Objects.requireNonNull(this.font);
                guiGraphics.method_25294(n, n8, n9, n10 - 9 - 2, bgColor);
                int n11 = this.method_46426() + 2;
                int n12 = this.method_46427() + 2;
                int n13 = this.method_55443();
                Objects.requireNonNull(this.font);
                this.drawHorizontalGradient(guiGraphics, n11, n12, n13 - 9 - 2, this.lerp(delta, this.method_46426() + 2, this.method_55442() - 2));
                int n14 = this.method_46426() + 2;
                int n15 = this.method_55443();
                Objects.requireNonNull(this.font);
                guiGraphics.method_25294(n14, n15 - 9 - 1, this.method_55442() - 2, this.method_55443() - 2, bgColor);
                int n16 = this.method_46426() + 2;
                int n17 = this.method_55443();
                Objects.requireNonNull(this.font);
                this.drawHorizontalGradient(guiGraphics, n16, n17 - 9 - 1, this.method_55443() - 2, this.lerp(delta, this.method_46426() + 2, this.method_55442() - 2));
            }
            DrawUtil.outlineRect(guiGraphics, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), this.method_25367() ? -1 : bgColor);
        }

        private void drawHorizontalGradient(class_332 guiGraphics, int x1, int y1, int y2, int x2) {
            class_4588 consumer = GalleryScreen.this.field_22787.method_22940().method_23000().getBuffer(class_1921.method_51784());
            Matrix4f matrix4f = guiGraphics.method_51448().method_23760().method_23761();
            consumer.method_22918(matrix4f, (float)x1, (float)y1, 0.0f).method_39415(bgColor);
            consumer.method_22918(matrix4f, (float)x1, (float)y2, 0.0f).method_39415(bgColor);
            consumer.method_22918(matrix4f, (float)x2, (float)y2, 0.0f).method_39415(accent);
            consumer.method_22918(matrix4f, (float)x2, (float)y1, 0.0f).method_39415(accent);
        }

        private double easeInOutCubic(double x) {
            return x < 0.5 ? 4.0 * x * x * x : 1.0 - Math.pow(-2.0 * x + 2.0, 3.0) / 2.0;
        }

        private int lerp(float delta, int start, int end) {
            return class_3532.method_15340((int)class_3532.method_48781((float)delta, (int)start, (int)end), (int)start, (int)end);
        }

        @NotNull
        protected class_5250 method_25360() {
            return ImageEntry.method_32602((class_2561)class_2561.method_43471((String)"gallery.image.view"));
        }

        protected void method_49604(class_332 guiGraphics, class_327 font, int width, int color) {
            int i = this.method_46426() + width;
            int j = this.method_46426() + this.method_25368() - width;
            class_2561 class_25612 = this.method_25369();
            int n = this.method_46427() + this.method_25364();
            Objects.requireNonNull(font);
            ImageEntry.method_52718((class_332)guiGraphics, (class_327)font, (class_2561)class_25612, (int)i, (int)(n - 9 - 1), (int)j, (int)(this.method_46427() + this.method_25364()), (int)color);
        }
    }
}

