/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.screenshotUtils;

import com.google.common.hash.Hashing;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Locale;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public interface ImageInstance {
    public class_2960 id();

    public class_1011 image();

    public String filename();

    private static void register(class_2960 id, class_1011 img) {
        class_310.method_1551().method_1531().method_4616(id, (class_1044)new class_1043(img));
    }

    public record RemoteImpl(class_2960 id, class_1011 image, String filename, String uploader, Instant sharedAt, String url) implements Remote
    {
        public RemoteImpl(class_1011 image, String filename, String uploader, Instant sharedAt, String url) {
            this(class_2960.method_60655((String)"axolotlclient", (String)("gallery_remote_" + String.valueOf(Hashing.sha256().hashUnencodedChars((CharSequence)url.toLowerCase(Locale.ROOT).replaceAll("[./]", "_"))))), image, filename, uploader, sharedAt, url);
            ImageInstance.register(this.id(), this.image());
        }
    }

    public record SharedImpl(class_2960 id, class_1011 image, String filename, Path location, String url, String uploader, Instant sharedAt) implements Local,
    Remote
    {
    }

    public record LocalImpl(class_2960 id, class_1011 image, String filename, Path location) implements Local
    {
        public LocalImpl(class_1011 image, String filename, Path location) {
            this(class_2960.method_60655((String)"axolotlclient", (String)("gallery_local_" + String.valueOf(Hashing.sha256().hashUnencodedChars((CharSequence)location.toString().toLowerCase(Locale.ROOT).replaceAll("[./]", "_"))))), image, filename, location);
            ImageInstance.register(this.id(), this.image());
        }

        public LocalImpl(Path p) throws IOException {
            this(class_1011.method_4309((InputStream)Files.newInputStream(p, new OpenOption[0])), p.getFileName().toString(), p);
        }
    }

    public static interface Remote
    extends ImageInstance {
        public String url();

        public String uploader();

        public Instant sharedAt();

        default public ImageInstance toShared(Path saved) {
            return new SharedImpl(this.id(), this.image(), this.filename(), saved, this.url(), this.uploader(), this.sharedAt());
        }
    }

    public static interface Local
    extends ImageInstance {
        public Path location();

        default public ImageInstance toShared(String url, String uploader, Instant sharedAt) {
            return new SharedImpl(this.id(), this.image(), this.filename(), this.location(), url, uploader, sharedAt);
        }
    }
}

