/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.screenshotUtils;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import io.github.axolotlclient.modules.screenshotUtils.GalleryScreen;
import io.github.axolotlclient.modules.screenshotUtils.ImageInstance;
import io.github.axolotlclient.modules.screenshotUtils.ImageNetworking;
import io.github.axolotlclient.util.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import net.minecraft.class_1011;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;

public class ImageShare
extends ImageNetworking {
    private static final ImageShare Instance = new ImageShare();

    private ImageShare() {
    }

    public void uploadImage(Path file) {
        Util.addMessageToChatHud((class_2561)class_2561.method_43471((String)"imageUploadStarted"));
        this.upload(file).whenCompleteAsync((downloadUrl, throwable) -> {
            if (downloadUrl.isEmpty()) {
                Util.addMessageToChatHud((class_2561)class_2561.method_43471((String)"imageUploadFailure"));
            } else {
                Util.addMessageToChatHud((class_2561)class_2561.method_43471((String)"imageUploadSuccess").method_27693(" ").method_10852((class_2561)class_2561.method_43470((String)downloadUrl).method_10862(class_2583.field_24360.method_27705(new class_124[]{class_124.field_1073, class_124.field_1064}).method_10958(new class_2558(class_2558.class_2559.field_21462, downloadUrl)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"clickToCopy"))))));
            }
        });
    }

    public CompletableFuture<ImageInstance> downloadImage(String url) {
        return this.download(url).thenApply(data -> {
            if (data == ImageNetworking.ImageData.EMPTY) return null;
            try (ByteArrayInputStream in = new ByteArrayInputStream(data.data());){
                ImageInstance.RemoteImpl remote = new ImageInstance.RemoteImpl(class_1011.method_4309((InputStream)in), data.name(), data.uploader(), data.sharedAt(), (String)ImageShare.ensureUrl((String)url).orElseThrow());
                try {
                    Path local = GalleryScreen.SCREENSHOTS_DIR.resolve(remote.filename());
                    HashFunction hash = Hashing.goodFastHash((int)32);
                    if (Files.exists(local, new LinkOption[0]) && hash.hashBytes(data.data()).equals((Object)hash.hashBytes(Files.readAllBytes(local)))) {
                        ImageInstance imageInstance = remote.toShared(local);
                        return imageInstance;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ImageInstance.RemoteImpl remoteImpl = remote;
                return remoteImpl;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        });
    }

    @Generated
    public static ImageShare getInstance() {
        return Instance;
    }
}

