/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.util;

import com.mojang.serialization.Codec;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.bridge.util.AxoIdentifier;
import io.github.axolotlclient.modules.freelook.Freelook;
import io.github.axolotlclient.modules.hud.HudManager;
import io.github.axolotlclient.modules.hud.gui.hud.simple.ToggleSprintHud;
import io.github.axolotlclient.util.options.ForceableBooleanOption;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.class_156;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class FeatureDisabler {
    private static final HashMap<ForceableBooleanOption, String[]> disabledServers = new HashMap();
    private static final HashMap<ForceableBooleanOption, Supplier<Boolean>> conditions = new HashMap();
    private static final Supplier<Boolean> NONE = () -> true;
    private static final class_8710.class_9154<FeaturePayload> channelId = new class_8710.class_9154(class_2960.method_60655((String)"axolotlclient", (String)"block_mods"));
    private static final HashMap<String, ForceableBooleanOption> features = (HashMap)class_156.method_656(() -> {
        HashMap<String, ForceableBooleanOption> features = new HashMap<String, ForceableBooleanOption>();
        features.put("freelook", Freelook.getInstance().enabled);
        features.put("timechanger", AxolotlClient.config().timeChangerEnabled);
        features.put("lowfire", AxolotlClient.config().lowFire);
        features.put("fullbright", AxolotlClient.config().fullBright);
        return features;
    });
    private static String currentAddress = "";

    public static void init() {
        FeatureDisabler.setServers(AxolotlClient.config().fullBright, NONE, "gommehd");
        FeatureDisabler.setServers(AxolotlClient.config().lowFire, NONE, "gommehd");
        FeatureDisabler.setServers(Freelook.getInstance().enabled, () -> Freelook.getInstance().needsDisabling(), "hypixel", "mineplex", "gommehd", "nucleoid", "mccisland");
        FeatureDisabler.setServers(((ToggleSprintHud)HudManager.getInstance().get((AxoIdentifier)ToggleSprintHud.ID)).toggleSneak, NONE, "hypixel");
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            if (handler.method_45734() != null) {
                FeatureDisabler.onServerJoin(Objects.requireNonNull(handler.method_45734()).field_3761);
            }
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> FeatureDisabler.clear());
        PayloadTypeRegistry.playS2C().register(channelId, FeaturePayload.CODEC);
        ClientPlayConnectionEvents.INIT.register((handler0, client0) -> ClientPlayNetworking.registerGlobalReceiver(channelId, (payload, ctx) -> {
            for (String feature : payload.features) {
                try {
                    ForceableBooleanOption e = features.get(feature);
                    e.setForceOff(true, "ban_reason");
                }
                catch (Exception e) {
                    AxolotlClient.LOGGER.error("Failed to disable " + feature + "!", new Object[0]);
                }
            }
        }));
    }

    private static void setServers(ForceableBooleanOption option, Supplier<Boolean> condition, String ... servers) {
        disabledServers.put(option, servers);
        conditions.put(option, condition);
    }

    public static void onServerJoin(String address) {
        currentAddress = address;
        FeatureDisabler.update();
    }

    public static void clear() {
        disabledServers.keySet().forEach(option -> option.setForceOff(false, ""));
        features.values().forEach(option -> option.setForceOff(false, ""));
    }

    public static void update() {
        disabledServers.forEach((option, strings) -> FeatureDisabler.disableOption(option, strings, currentAddress));
    }

    private static void disableOption(ForceableBooleanOption option, String[] servers, String currentServer) {
        boolean ban = false;
        for (String s : servers) {
            if (!currentServer.toLowerCase(Locale.ROOT).contains(s.toLowerCase(Locale.ROOT))) continue;
            ban = conditions.get(option).get();
            break;
        }
        if (option.isForceOff() != ban) {
            option.setForceOff(ban, "ban_reason");
        }
    }

    private record FeaturePayload(List<String> features) implements class_8710
    {
        public static final class_9139<ByteBuf, FeaturePayload> CODEC = class_9135.method_56368((Codec)Codec.STRING.listOf().xmap(FeaturePayload::new, FeaturePayload::features));

        private FeaturePayload(class_2540 buf) {
            this(buf.method_34066(class_2540::method_19772));
        }

        private void write(class_2540 buf) {
            buf.method_34062(this.features, class_2540::method_10814);
        }

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return channelId;
        }
    }
}

