/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_11907;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4069;
import net.minecraft.class_4185;
import net.minecraft.class_4264;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import org.jetbrains.annotations.Nullable;

public class ContextMenu implements class_4069, class_4068, class_6379 {

	private final List<class_4264> children;
	private boolean dragging;
	private class_364 focused;

	private int x;
	private int y;
	private final int width, height;
	private boolean rendering;

	protected ContextMenu(List<class_4264> items) {
		children = items;
		int width = 0;
		int height = 0;
		for (class_4264 d : children) {
			d.method_46419(height);
			height += d.method_25364();
			width = Math.max(width, d.method_25368());
		}
		this.width = width;
		this.height = height;
	}

	public static Builder builder() {
		return new Builder();
	}

	@Override
	public List<? extends class_364> method_25396() {
		return children;
	}

	public List<class_4264> entries() {
		return children;
	}

	@Override
	public boolean method_25397() {
		return dragging;
	}

	@Override
	public void method_25398(boolean dragging) {
		this.dragging = dragging;
	}

	@Nullable
	@Override
	public class_364 method_25399() {
		return focused;
	}

	@Override
	public void method_25395(@Nullable class_364 child) {
		if (focused != null) {
			focused.method_25365(false);
		}
		this.focused = child;
		if (focused != null) {
			focused.method_25365(true);
		}
	}

	@Override
	public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
		if (!rendering) {
			y = mouseY;
			x = mouseX;
			rendering = true;
		}
		final int yStart = Math.min(y + 2, graphics.method_51443() - height - 2);
		final int xStart = Math.min(x + 2, graphics.method_51421() - width - 2);
		int y = yStart + 1;
		for (class_4264 d : children) {
			d.method_46421(xStart + 1);
			d.method_46419(y);
			y += d.method_25364();
		}
		graphics.method_51448().pushMatrix();
		//graphics.pose().translate(0, 0, 200);
		graphics.method_25294(xStart, yStart, xStart + width + 1, y, 0xDD1E1F22);
		DrawUtil.outlineRect(graphics, xStart, yStart, width + 1, y - yStart + 1, -1);
		for (class_4264 c : children) {
			c.method_25358(width);
			c.method_25394(graphics, mouseX, mouseY, delta);
		}
		graphics.method_51448().popMatrix();
	}

	@Override
	public boolean method_25405(double mouseX, double mouseY) {
		return method_19355(mouseX, mouseY).isPresent();
	}

	@Override
	public class_6380 method_37018() {
		return method_25370() ? class_6380.field_33786 : class_6380.field_33785;
	}

	@Override
	public void method_37020(class_6382 builder) {
		builder.method_37034(class_6381.field_33788, class_2561.method_43471("api.context_menu"));
		entries().forEach(b -> builder.method_37034(class_6381.field_33791, b.method_25369()));
	}

	@Override
	public boolean method_25402(class_11909 event, boolean doubleClick) {
		Optional<class_364> optional = this.method_19355(event.comp_4798(), event.comp_4799());
		if (optional.isPresent()) {
			class_364 guiEventListener = optional.get();
			if (guiEventListener.method_25402(event, doubleClick)) {
				this.method_25395(guiEventListener);
				if (event.method_74245() == 0) {
					this.method_25398(true);
				}
				return true;
			}
		}
		return false;
	}

	public static class Builder {

		private final class_310 client = class_310.method_1551();

		private final List<class_4264> elements = new ArrayList<>();

		public Builder() {

		}

		public Builder entry(class_2561 name, class_4185.class_4241 action) {
			elements.add(new ContextMenuEntryWithAction(name, action));
			return this;
		}

		public Builder entry(class_4264 widget) {
			elements.add(widget);
			return this;
		}

		public Builder spacer() {
			elements.add(new ContextMenuEntry(class_2561.method_43470("-----")) {
				@Override
				protected void method_47399(class_6382 builder) {

				}
			});
			return this;
		}

		public Builder title(class_2561 title) {
			elements.add(new ContextMenuEntry(title));
			return this;
		}

		public ContextMenu build() {
			return new ContextMenu(elements);
		}

	}

	public static class ContextMenuEntry extends class_4264 {

		private final class_310 client = class_310.method_1551();

		public ContextMenuEntry(class_2561 content) {
			super(0, 0, class_310.method_1551().field_1772.method_27525(content), 11, content);
		}

		@Override
		public void method_25306(class_11907 input) {

		}

		@Override
		public void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {
			graphics.method_27534(client.field_1772, method_25369(), method_46426() + method_25368() / 2, method_46427(), 0xFFDDDDDD);
		}

		@Override
		public boolean method_25402(class_11909 event, boolean doubleClick) {
			return false;
		}

		@Override
		protected void method_47399(class_6382 builder) {
			builder.method_37034(class_6381.field_33788, method_25369());
		}
	}

	public static class ContextMenuEntryWithAction extends class_4185 {

		private final class_310 client = class_310.method_1551();

		public ContextMenuEntryWithAction(class_2561 message, class_4241 onPress) {
			super(0, 0, class_310.method_1551().field_1772.method_27525(message) + 4, 11, message, onPress, field_40754);
		}

		@Override
		public void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {

			if (method_25367()) {
				graphics.method_25294(method_46426(), method_46427(), method_46426() + method_25368(), method_46427() + method_25364(), 0x55ffffff);
			}

			int i = this.field_22763 ? -1 : 0xFFA0A0A0;
			this.method_48589(graphics, client.field_1772, i | class_3532.method_15386(this.field_22765 * 255.0F) << 24);
		}
	}
}
