/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api;

import java.util.Arrays;
import java.util.Optional;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_500;
import net.minecraft.class_642;
import io.github.axolotlclient.api.e4mc.E4mcStatusProvider;
import io.github.axolotlclient.api.requests.StatusUpdate;
import io.github.axolotlclient.api.util.StatusUpdateProvider;
import io.github.axolotlclient.api.worldhost.WorldHostStatusProvider;
import io.github.axolotlclient.modules.hypixel.HypixelMods;
import io.github.axolotlclient.modules.mcci.MccIslandMods;

public class StatusUpdateProviderImpl implements StatusUpdateProvider {

	@Override
	public void initialize() {
	}

	@Override
	public Request getStatus() {
		class_310 mc = class_310.method_1551();
		class_642 entry = mc.method_1558();
		if (entry != null) {

			if (!entry.method_2994()) {
				Optional<StatusUpdate.SupportedServer> optional = Arrays.stream(StatusUpdate.SupportedServer.values())
					.filter(s -> s.getAddress().matcher(entry.field_3761).matches()).findFirst();
				if (optional.isPresent()) {
					StatusUpdate.SupportedServer server = optional.get();
					if (server.equals(StatusUpdate.SupportedServer.HYPIXEL)) {
						return HypixelMods.getInstance().getStatus();
					} else if (server.equals(StatusUpdate.SupportedServer.MCC_ISLAND)) {
						return MccIslandMods.getInstance().getMccIStatus();
					}
				}
				return StatusUpdate.inGameServer(entry.field_3752, entry.field_3761);
			}
			return StatusUpdate.inGameUnknown(entry.field_3752);
		} else if (mc.method_1576() != null) {
			var worldHostStatus = WorldHostStatusProvider.getWHStatusDescription();
			if (worldHostStatus != null) {
				return StatusUpdate.worldHostStatusUpdate(worldHostStatus);
			}
			var e4mcStatus = E4mcStatusProvider.getStatusDescription();
			if (e4mcStatus != null) {
				return StatusUpdate.e4mcStatusUpdate(e4mcStatus);
			}
			return StatusUpdate.inGameUnknown(mc.method_1576().method_27728().method_150());
		}
		class_437 current = mc.field_1755;
		if (current instanceof class_442) {
			return StatusUpdate.online(StatusUpdate.MenuId.MAIN_MENU);
		} else if (current instanceof class_500) {
			return StatusUpdate.online(StatusUpdate.MenuId.SERVER_LIST);
		} else if (current != null) {
			return StatusUpdate.online(StatusUpdate.MenuId.SETTINGS);
		}
		return null;
	}
}
