/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api.multiplayer;

import io.github.axolotlclient.api.FriendsScreen;
import io.github.axolotlclient.api.handlers.StatusUpdateHandler;
import io.github.axolotlclient.api.requests.FriendRequest;
import lombok.Getter;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_412;
import net.minecraft.class_4185;
import net.minecraft.class_420;
import net.minecraft.class_437;
import net.minecraft.class_500;
import net.minecraft.class_5244;
import net.minecraft.class_639;
import net.minecraft.class_641;
import net.minecraft.class_642;
import net.minecraft.class_644;
import net.minecraft.class_7843;
import net.minecraft.class_7849;
import net.minecraft.class_7852;
import net.minecraft.class_8667;

public class FriendsMultiplayerScreen extends class_437 {
	@Getter
	private final class_644 pinger = new class_644();
	private final class_437 lastScreen;
	protected FriendsMultiplayerSelectionList serverSelectionList;
	private class_4185 selectButton;
	private final class_4185 friendsCountButton = class_4185.method_46430(class_2561.method_43469("api.servers.friends", "..."), button -> {
	}).method_46431();
	private class_642 editingServer;
	private boolean initialized;
	private static final class_2561 NO_ONLINE_FRIENDS = class_2561.method_43471("api.servers.friends.no_online_friends");

	public FriendsMultiplayerScreen(class_437 lastScreen) {
		super(class_2561.method_43471("api.servers.friends.title"));
		this.lastScreen = lastScreen;
	}

	@Override
	protected void method_25426() {
		if (this.initialized) {
			this.serverSelectionList.method_55444(this.field_22789, this.field_22790 - 64 - 60, 0, 60);
		} else {
			this.serverSelectionList = new FriendsMultiplayerSelectionList(this, this.field_22787, this.field_22789, this.field_22790 - 64 - 60, 60, 36);
		}
		StatusUpdateHandler.addUpdateListener("friends_multiplayer_screen", serverSelectionList::updateEntry);

		this.method_37063(this.serverSelectionList);
		method_37063(class_4185.method_46430(class_2561.method_43471("api.servers"), button ->
			field_22787.method_1507(new class_500(lastScreen))).method_46433(this.field_22789 / 2 - 102, 32).method_46432(100).method_46431());
		method_37063(friendsCountButton).method_55444(100, 20, field_22789 / 2 + 2, 32);
		friendsCountButton.field_22763 = false;

		if (!initialized) {
			initialized = true;
			FriendRequest.getInstance().getFriends().thenAccept(friends -> {
				friendsCountButton.method_25355(class_2561.method_43469("api.servers.friends", friends.stream().filter(u -> u.getStatus().isOnline()).count()));
				this.serverSelectionList.updateList(friends);
			});
		}

		this.selectButton = this.method_37063(
			class_4185.method_46430(class_2561.method_43471("selectServer.select"), buttonx -> this.joinSelectedServer()).method_46432(100).method_46431()
		);
		class_4185 directConnect = this.method_37063(class_4185.method_46430(class_2561.method_43471("selectServer.direct"), buttonx -> {
			this.editingServer = new class_642(class_1074.method_4662("selectServer.defaultName"), "", class_642.class_8678.field_45611);
			this.field_22787.method_1507(new class_420(this, this::directJoinCallback, this.editingServer));
		}).method_46432(100).method_46431());
		class_4185 friends = this.method_37063(class_4185.method_46430(class_2561.method_43471("api.friends"), buttonx ->
			this.field_22787.method_1507(new FriendsScreen(this))).method_46432(100).method_46431());
		class_4185 editButton = this.method_37063(class_4185.method_46430(class_2561.method_43471("selectServer.edit"), buttonx -> {
		}).method_46432(74).method_46431());
		editButton.field_22763 = false;
		class_4185 deleteButton = this.method_37063(class_4185.method_46430(class_2561.method_43471("selectServer.delete"), buttonx -> {
		}).method_46432(74).method_46431());
		deleteButton.field_22763 = false;
		class_4185 refreshList = this.method_37063(
			class_4185.method_46430(class_2561.method_43471("selectServer.refresh"), buttonx -> this.refreshServerList()).method_46432(74).method_46431()
		);
		class_4185 back = this.method_37063(class_4185.method_46430(class_5244.field_24339, buttonx -> this.method_25419()).method_46432(74).method_46431());
		class_8667 linearLayout = class_8667.method_52741();
		class_7849 equalSpacingLayout = linearLayout.method_52736(new class_7849(308, 20, class_7849.class_7851.field_40789));
		equalSpacingLayout.method_46495(this.selectButton);
		equalSpacingLayout.method_46495(directConnect);
		equalSpacingLayout.method_46495(friends);
		linearLayout.method_52736(class_7852.method_46513(4));
		class_7849 equalSpacingLayout2 = linearLayout.method_52736(new class_7849(308, 20, class_7849.class_7851.field_40789));
		equalSpacingLayout2.method_46495(editButton);
		equalSpacingLayout2.method_46495(deleteButton);
		equalSpacingLayout2.method_46495(refreshList);
		equalSpacingLayout2.method_46495(back);
		linearLayout.method_48222();
		class_7843.method_46442(linearLayout, 0, this.field_22790 - 64, this.field_22789, 64);
		this.onSelectedChange();
	}

	@Override
	public void method_25419() {
		this.field_22787.method_1507(this.lastScreen);
	}

	@Override
	public void method_25393() {
		super.method_25393();
		this.pinger.method_3000();
	}

	@Override
	public void method_25432() {
		StatusUpdateHandler.removeUpdateListener("friends_multiplayer_screen");
		this.pinger.method_3004();
	}

	@Override
	public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
		super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
		guiGraphics.method_27534(field_22793, method_25440(), field_22789 / 2, 15, -1);

		if (serverSelectionList.method_25396().isEmpty()) {
			guiGraphics.method_27534(field_22793, NO_ONLINE_FRIENDS, field_22789 / 2, field_22790 / 2 - field_22793.field_2000 / 2, -1);
		}
	}

	private void refreshServerList() {
		this.field_22787.method_1507(new FriendsMultiplayerScreen(this.lastScreen));
	}

	private void directJoinCallback(boolean confirmed) {
		if (confirmed) {
			class_641 servers = new class_641(field_22787);
			servers.method_2981();
			class_642 serverData = servers.method_44295(this.editingServer.field_3761);
			if (serverData == null) {
				servers.method_2988(this.editingServer, true);
				servers.method_2987();
				this.join(this.editingServer);
			} else {
				this.join(serverData);
			}
		} else {
			this.field_22787.method_1507(this);
		}
	}

	public void joinSelectedServer() {
		FriendsMultiplayerSelectionList.Entry entry = this.serverSelectionList.method_25334();
		this.join(entry.getServerData());
	}

	private void join(class_642 server) {
		if (server == null) {
			return;
		}
		class_412.method_36877(this, this.field_22787, class_639.method_2950(server.field_3761), server, false, null);
	}

	public void setSelected(FriendsMultiplayerSelectionList.Entry selected) {
		this.serverSelectionList.setSelected(selected);
		this.onSelectedChange();
	}

	protected void onSelectedChange() {
		this.selectButton.field_22763 = false;
		FriendsMultiplayerSelectionList.Entry entry = this.serverSelectionList.method_25334();
		if (entry != null && !(entry instanceof FriendsMultiplayerSelectionList.LoadingHeader)) {
			this.selectButton.field_22763 = entry.canJoin();
		}
	}
}
