/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.bridge.mixin.key;

import io.github.axolotlclient.bridge.key.AxoClientKeybinds;
import io.github.axolotlclient.bridge.key.AxoKeybinding;
import net.minecraft.class_304;
import net.minecraft.class_315;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(class_315.class)
public abstract class GameOptionsMixin implements AxoClientKeybinds {
	@Shadow
	@Final
	public class_304 keySprint;

	@Shadow
	@Final
	public class_304 keyShift;

	@Shadow
	@Final
	public class_304 keyAttack;

	@Shadow
	@Final
	public class_304 keyUse;

	@Override
	public AxoKeybinding br$getSprintKeybind() {
		return keySprint;
	}

	@Override
	public AxoKeybinding br$getSneakKeybind() {
		return keyShift; // great naming, mojang!
	}

	@Override
	public AxoKeybinding br$getAttackKey() {
		return keyAttack;
	}

	@Override
	public AxoKeybinding br$getUseKey() {
		return keyUse;
	}
}
