/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.bridge.mixin.render;

import io.github.axolotlclient.bridge.render.AxoFont;
import io.github.axolotlclient.bridge.util.AxoText;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_5348;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(class_327.class)
public abstract class FontMixin implements AxoFont {
	@Shadow
	public abstract int width(String text);

	@Shadow
	@Final
	public int lineHeight;

	@Shadow
	public abstract int width(class_5348 text);

	@Override
	public int br$getWidth(AxoText text) {
		return width((class_2561) text);
	}

	@Override
	public int br$getWidth(String text) {
		return this.width(text);
	}

	@Override
	public int br$getFontHeight() {
		return lineHeight;
	}
}
