/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.bridge.mixin.resource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.class_3298;
import io.github.axolotlclient.bridge.resource.AxoResource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(class_3298.class)
public abstract class ResourceMixin implements AxoResource {

	@Shadow
	public abstract BufferedReader openAsReader() throws IOException;

	@Shadow
	public abstract InputStream open() throws IOException;

	@Override
	public InputStream br$asStream() throws IOException {
		return open();
	}

	@Override
	public BufferedReader br$asReader() throws IOException {
		return openAsReader();
	}
}
