/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.bridge.mixin.util;

import io.github.axolotlclient.bridge.util.AxoText;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_5251;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(class_2583.class)
public abstract class StyleMixin implements AxoText.Style {
	@Shadow
	public abstract class_2583 withColor(class_5251 par1);

	@Shadow
	public abstract class_2583 withHoverEvent(class_2568 par1);

	@Shadow
	public abstract class_2583 withColor(@Nullable class_124 formatting);

	@Override
	public AxoText.Style br$color(AxoText.Color color) {
		return withColor(switch (color) {
			case BLACK -> class_124.field_1074;
			case DARK_BLUE -> class_124.field_1058;
			case DARK_GREEN -> class_124.field_1077;
			case DARK_AQUA -> class_124.field_1062;
			case DARK_RED -> class_124.field_1079;
			case DARK_PURPLE -> class_124.field_1064;
			case GOLD -> class_124.field_1065;
			case GRAY -> class_124.field_1080;
			case DARK_GRAY -> class_124.field_1063;
			case BLUE -> class_124.field_1078;
			case GREEN -> class_124.field_1060;
			case AQUA -> class_124.field_1075;
			case RED -> class_124.field_1061;
			case LIGHT_PURPLE -> class_124.field_1076;
			case YELLOW -> class_124.field_1054;
			case WHITE -> class_124.field_1068;
		});
	}

	@Override
	public AxoText.Style br$color(int color) {
		return withColor(class_5251.method_27717(color));
	}

	@Override
	public AxoText.Style br$tooltip(AxoText text) {
		return withHoverEvent(new class_2568.class_10613((class_2561) text));
	}
}
