/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.config.screen;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_6379;
import net.minecraft.class_7077;
import net.minecraft.class_7842;
import net.minecraft.class_8132;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.credits.Credits;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import io.github.axolotlclient.util.ClientColors;

public class CreditsScreen extends class_437 {

	public static final HashMap<String, String[]> externalModuleCredits = new HashMap<>();
	private final class_437 parent;
	private final class_1113 bgm = class_1109.method_4757(class_3417.field_15039.comp_349(), 1, 1);
	private final class_8132 haF = new class_8132(this);
	private boolean initialized;

	public CreditsScreen(class_437 parent) {
		super(class_2561.method_43471("credits"));
		this.parent = parent;
	}

	@Override
	public void method_25420(class_332 graphics, int mouseX, int mouseY, float delta) {
		if (AxolotlClient.config().someNiceBackground.get()) { // Credit to pridelib for the colors
			graphics.method_25294(0, 0, field_22789, field_22790 / 6, 0xFFff0018);
			graphics.method_25294(0, field_22790 / 6, field_22789, field_22790 * 2 / 6, 0xFFffa52c);
			graphics.method_25294(0, field_22790 * 2 / 6, field_22789, field_22790 / 2, 0xFFffff41);
			graphics.method_25294(0, field_22790 * 2 / 3, field_22789, field_22790 * 5 / 6, 0xFF0000f9);
			graphics.method_25294(0, field_22790 / 2, field_22789, field_22790 * 2 / 3, 0xFF008018);
			graphics.method_25294(0, field_22790 * 5 / 6, field_22789, field_22790, 0xFF86007d);
		} else {
			super.method_25420(graphics, mouseX, mouseY, delta);
		}
	}

	@Override
	public void method_25426() {
		if (initialized) {
			haF.method_48222();
			haF.method_48206(this::method_37063);
			return;
		}
		initialized = true;
		haF.method_57726(method_25440(), method_64506());
		haF.method_48999(new CreditsList(field_22787, haF.method_25368(), haF.method_57727(), haF.method_48998(), 25));

		var back = haF.method_48996(class_4185.method_46430(class_5244.field_24339, buttonWidget -> method_25419()).method_46431());

		haF.method_48222();
		haF.method_48206(this::method_37063);

		this.method_37063(class_4185.method_46430(class_2561.method_43471("creditsBGM").method_27693(": ")
				.method_10852(class_2561.method_43471(AxolotlClient.config().creditsBGM.get() ? "options.on" : "options.off")),
			buttonWidget -> {
				AxolotlClient.config().creditsBGM.toggle();
				AxolotlClient.getInstance().getConfigManager().save();
				stopBGM();
				buttonWidget.method_25355(class_2561.method_43471("creditsBGM").method_27693(": ").method_10852(
					class_2561.method_43471(AxolotlClient.config().creditsBGM.get() ? "options.on" : "options.off")));
			}).method_46434(6, back.method_46427(), 100, 20).method_46431());
	}

	@Override
	public void method_25419() {
		field_22787.method_1507(parent);
		stopBGM();
	}

	@Override
	protected void method_48640() {
		haF.method_48222();
	}

	@Override
	public void method_25393() {
		tickBGM();
	}

	public void tickBGM() {
		if (AxolotlClient.config().creditsBGM.get() && !field_22787.method_1483().method_4877(bgm)) {
			field_22787.method_1483().method_4873(bgm);
		}
	}

	private void stopBGM() {
		field_22787.method_1483().method_4870(bgm);
	}

	private class CreditsList extends class_4265<Entry> {

		public CreditsList(class_310 minecraftClient, int width, int height, int top,
						   int entryHeight) {
			super(minecraftClient, width, height, top, entryHeight);

			method_25321(new SpacerTitle("- - - - - - " + class_1074.method_4662("contributors") + " - - - - - -"));
			Credits.getContributors().forEach(credit -> method_25321(new Credit(credit.getName(), credit.getThings())));

			method_25321(new SpacerTitle("- - - - - - " + class_1074.method_4662("other_people") + " - - - - - -"));
			Credits.getOtherPeople().forEach(credit -> method_25321(new Credit(credit.getName(), credit.getThings())));

			if (!externalModuleCredits.isEmpty()) {
				method_25321(new SpacerTitle("- - - - - - " + class_1074.method_4662("external_modules") + " - - - - - -"));
				externalModuleCredits.forEach((s, s2) -> method_25321(new Credit(s, s2)));
			}
		}
	}

	private static abstract class Entry extends class_4265.class_4266<Entry> {

	}

	private class Credit extends Entry {

		private final String name;
		private final String[] things;
		private final class_4185 c;

		public Credit(String name, String... things) {
			this.name = name;
			this.things = things;
			c = new class_4185(0, 0, 200, 20, class_2561.method_43470(name), buttonWidget -> field_22787.method_1507(new CreditOverlay(this)), Supplier::get) {

				@Override
				protected void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {
					if (method_25367()) {
						DrawUtil.outlineRect(graphics, method_46426(), method_46427(), method_25368(), method_25364(), ClientColors.ERROR.toInt());
					}
					int i = this.field_22763 ? (method_25367() ? ClientColors.SELECTOR_RED.toInt() : -1) : 10526880;
					this.method_48589(graphics, field_22793, i | class_3532.method_15386(this.field_22765 * 255.0F) << 24);
				}
			};
		}

		@Override
		public void method_25343(class_332 graphics, int mouseX,
								  int mouseY, boolean hovered, float tickDelta) {
			c.method_48229(method_73380(), method_73382());
			c.method_25394(graphics, mouseX, mouseY, tickDelta);
		}

		@Override
		public List<? extends class_364> method_25396() {
			return List.of(c);
		}

		@Override
		public List<? extends class_6379> method_37025() {
			return List.of(c);
		}
	}

	private class CreditOverlay extends class_437 {
		private final Credit credit;

		public CreditOverlay(Credit credit) {
			super(class_2561.method_43470(credit.name));
			this.credit = credit;
		}

		@Override
		public void method_25419() {
			field_22787.method_1507(CreditsScreen.this);
		}

		@Override
		public void method_25426() {
			int startY = 100;
			for (String t : credit.things) {
				int textWidth = field_22793.br$getWidth(t);
				if (t.startsWith("http")) {
					method_37063(new class_7077(field_22789 / 2 - textWidth / 2, startY, textWidth, 12,
						class_2561.method_43470(t).method_54663(ClientColors.SELECTOR_GREEN.toInt()), btn ->
						method_71846(field_22787, new class_2558.class_10608(URI.create(t))), field_22793));
				} else {
					method_37060(new class_7842(field_22789 / 2 - textWidth / 2, startY, textWidth, 12,
						class_2561.method_43470(t).method_54663(ClientColors.SELECTOR_GREEN.toInt()), field_22793));
				}
				startY += 12;
			}
			method_37063(class_4185.method_46430(class_5244.field_24339, buttonWidget -> method_25419())
				.method_46433(field_22789 / 2 - 75, field_22790 - 33 / 2 - 10).method_46431());
		}

		@Override
		public void method_25420(class_332 graphics, int mouseX, int mouseY, float delta) {
			super.method_25420(graphics, mouseX, mouseY, delta);
			DrawUtil.fillRect(graphics, 100, 50, field_22789 - 200, field_22790 - 100,
				ClientColors.DARK_GRAY.withAlpha(127).toInt());
			DrawUtil.outlineRect(graphics, 100, 50, field_22789 - 200, field_22790 - 100,
				ClientColors.BLACK.toInt());
		}

		@Override
		public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
			super.method_25394(graphics, mouseX, mouseY, delta);
			DrawUtil.drawCenteredString(graphics, field_22793, credit.name,
				field_22789 / 2, 57, -16784327, true);
		}

		@Override
		public void method_25393() {
			CreditsScreen.this.tickBGM();
		}
	}

	private class SpacerTitle extends Entry {

		private final String name;

		public SpacerTitle(String name) {
			this.name = name;
		}

		@Override
		public void method_25343(class_332 graphics, int mouseX,
								  int mouseY, boolean hovered, float tickDelta) {
			DrawUtil.drawCenteredString(graphics, field_22793, name, method_73388(), method_73382(), -128374,
				true);
		}

		@Override
		public List<? extends class_364> method_25396() {
			return List.of();
		}

		@Override
		public List<? extends class_6379> method_37025() {
			return List.of();
		}
	}
}
