/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.config.screen;

import java.util.ArrayList;
import java.util.List;

import io.github.axolotlclient.config.profiles.Profiles;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_6379;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import net.minecraft.class_8132;
import net.minecraft.class_8667;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProfilesScreen extends class_437 {

	private final class_8132 haL = new class_8132(this);
	private ProfilesList profilesList;
	private final class_437 parent;
	private boolean initialized;

	public ProfilesScreen(class_437 parent) {
		super(class_2561.method_43471("profiles.configure.list"));
		this.parent = parent;
	}

	@Override
	protected void method_25426() {

		if (!initialized) {
			initialized = true;
			haL.method_57726(method_25440(), field_22793);
			profilesList = new ProfilesList(field_22787, 0, 0, 0, 25);
			haL.method_48999(profilesList);
			var footer = haL.method_48996(class_8667.method_52742()).method_52735(4);
			footer.method_52736(class_4185.method_46430(class_5244.field_24339, btn -> method_25419()).method_46431());
			haL.method_48206(this::method_37063);
		}

		method_48640();
	}

	@Override
	protected void method_48640() {
		haL.method_48222();
		profilesList.method_57712(this.field_22789, this.haL);
	}

	@Override
	public void method_25419() {
		Profiles.getInstance().saveProfiles();
		//noinspection DataFlowIssue
		field_22787.method_1507(parent);
	}

	public class ProfilesList extends class_4265<ProfilesList.Entry> {
		private static final Entry SPACER = new SpacerEntry();
		private final Entry ADD = new NewEntry();

		public ProfilesList(class_310 minecraft, int width, int height, int y, int itemHeight) {
			super(minecraft, width, height, y, itemHeight);
			reload();
		}

		public void reload() {
			method_25339();
			Profiles.getInstance().iterateAvailable(p -> method_25321(new ProfileEntry(p)));
			method_25321(SPACER);
			method_25321(ADD);
		}

		@Override
		public int method_25322() {
			return 340;
		}

		@Override
		public boolean method_25402(class_11909 event, boolean doubleClick) {
			method_25396().stream().filter(e -> e instanceof ProfileEntry)
				.map(e -> (ProfileEntry) e).map(e -> e.profileName).forEach(e -> e.method_25365(false));
			return super.method_25402(event, doubleClick);
		}

		@Environment(EnvType.CLIENT)
		public abstract static class Entry extends class_4265.class_4266<Entry> {

		}

		public static class SpacerEntry extends Entry {

			@Override
			public @NotNull List<? extends class_6379> method_37025() {
				return List.of();
			}

			@Override
			public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovering, float partialTick) {

			}

			@Override
			public @NotNull List<? extends class_364> method_25396() {
				return List.of();
			}

			@Nullable
			@Override
			public class_8016 method_48205(class_8023 event) {
				return null;
			}
		}

		@Environment(EnvType.CLIENT)
		public class ProfileEntry extends Entry {
			private static final class_2561 EXPORT_BUTTON_TITLE = class_2561.method_43471("profiles.profile.export");
			private static final class_2561 CURRENT_TEXT = class_2561.method_43471("profiles.profile.current");
			private static final class_2561 LOAD_BUTTON_TITLE = class_2561.method_43471("profiles.profile.load");
			private static final class_2561 DUPLICATE_BUTTON_TITLE = class_2561.method_43471("profiles.profile.duplicate");
			private static final class_2561 REMOVE_BUTTON_TITLE = class_2561.method_43471("profiles.profile.remove");
			private final class_342 profileName;
			private final class_4185 exportButton, loadButton, duplicateButton, removeButton;
			private final Profiles.Profile profile;

			ProfileEntry(Profiles.Profile profile) {
				this.profile = profile;
				profileName = new class_342(method_64506(), 0, 0, 150, 20, class_2561.method_43473());
				profileName.method_1852(profile.name());
				profileName.method_1863(profile::setName);
				exportButton = class_4185.method_46430(EXPORT_BUTTON_TITLE, btn -> Profiles.getInstance().exportProfile(profile))
					.method_46434(0, 0, 50, 20).method_46431();
				loadButton = class_4185.method_46430(LOAD_BUTTON_TITLE, btn ->
					Profiles.getInstance().switchTo(profile)).method_46434(0, 0, 50, 20).method_46431();
				duplicateButton = class_4185.method_46430(DUPLICATE_BUTTON_TITLE, b -> {
					var dup = Profiles.getInstance().duplicate(profile);
					double d = (double) ProfilesList.this.method_44390() - ProfilesList.this.method_44387();
					@SuppressWarnings("unchecked") var entries = new ArrayList<>((List<Entry>) method_25396());
					entries.add(entries.indexOf(ProfileEntry.this) + 1, new ProfileEntry(dup));
					method_25314(entries);
					ProfilesList.this.method_44382(ProfilesList.this.method_44390() - d);
				}).method_46434(0, 0, 50, 20).method_46431();

				this.removeButton = class_4185.method_46430(REMOVE_BUTTON_TITLE, b -> {
						method_25330(this);
						Profiles.getInstance().remove(profile);
						method_65506();
					}).method_46434(0, 0, 50, 20)
					.method_46431();
			}

			@Override
			public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovering, float partialTick) {
				int i = method_65507() - removeButton.method_25368() - 4;
				int j = method_73382() - 2;
				this.removeButton.method_48229(i, j);
				this.removeButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);

				i -= duplicateButton.method_25368();
				duplicateButton.method_48229(i, j);
				duplicateButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);

				boolean current = Profiles.getInstance().getCurrent() == profile;
				loadButton.method_25355(current ? CURRENT_TEXT : LOAD_BUTTON_TITLE);
				loadButton.field_22763 = removeButton.field_22763 = !current;
				i -= loadButton.method_25368();
				this.loadButton.method_48229(i, j);
				this.loadButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
				i -= exportButton.method_25368();
				exportButton.method_48229(i, j);
				exportButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
				profileName.method_25358(i - method_73380() - 4);
				profileName.method_48229(method_73380(), j);
				profileName.method_25394(guiGraphics, mouseX, mouseY, partialTick);
			}

			@Override
			public @NotNull List<? extends class_364> method_25396() {
				return List.of(profileName, exportButton, this.loadButton, duplicateButton, removeButton);
			}

			@Override
			public @NotNull List<? extends class_6379> method_37025() {
				return List.of(profileName, exportButton, this.loadButton, duplicateButton, removeButton);
			}
		}

		public class NewEntry extends Entry {

			private final class_4185 addButton, importButton;

			public NewEntry() {
				this.addButton = class_4185.method_46430(class_2561.method_43471("profiles.profile.add"), button -> {
						var entries = new ArrayList<>(ProfilesList.this.method_25396());
						entries.add(Math.max(entries.indexOf(this) - 1, 0), new ProfileEntry(Profiles.getInstance().newProfile(class_1074.method_4662("profiles.profile.default_new_name"))));
						method_25314(entries);
						Profiles.getInstance().saveProfiles();
						method_44382(method_44390());
					}).method_46434(0, 0, 150, 20)
					.method_46431();
				this.importButton = class_4185.method_46430(class_2561.method_43471("profiles.profile.import"), btn ->
					Profiles.getInstance().importProfiles().thenRun(ProfilesList.this::reload)).method_46431();
			}

			@Override
			public @NotNull List<? extends class_6379> method_37025() {
				return List.of(addButton);
			}

			@Override
			public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovering, float partialTick) {
				int i = method_65507() - method_73387() / 2 - 10 - addButton.method_25368() + 2;
				int j = method_73382() - 2;
				this.addButton.method_48229(i, j);
				this.addButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
				this.importButton.method_48229(addButton.method_55442() + 2, j);
				this.importButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
			}

			@Override
			public @NotNull List<? extends class_364> method_25396() {
				return List.of(addButton, importButton);
			}
		}
	}
}
