/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin;

import java.net.Proxy;
import java.util.concurrent.Executor;
import net.minecraft.class_1066;
import net.minecraft.class_320;
import net.minecraft.class_9028;
import net.minecraft.class_9038;
import net.minecraft.class_9044;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.gen.Invoker;

@Mixin(class_1066.class)
public interface DownloadedPackSourceAccessor {

	@Invoker("createDownloader")
	class_9038 axolotlclient$createDownloader(class_9028 downloadQueue, Executor executor, class_320 user, Proxy proxy);

	@Accessor("downloadQueue")
	class_9028 axolotlcleint$getDownloadQueue();

	@Accessor("manager")
	class_9044 axolotlclient$getManager();
}
