/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin;

import io.github.axolotlclient.bridge.events.Events;
import io.github.axolotlclient.bridge.events.types.PlayerDirectionChangeEvent;
import io.github.axolotlclient.modules.freelook.Freelook;
import io.github.axolotlclient.modules.hypixel.Skyblock;
import net.minecraft.class_1297;
import net.minecraft.class_3532;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1297.class)
public abstract class EntityMixin {

	@Shadow
	public abstract float getYRot();

	@Shadow
	public abstract float getXRot();

	@Inject(method = "turn", at = @At("HEAD"), cancellable = true)
	public void axolotlclient$interceptMovement(double cursorDeltaX, double cursorDeltaY, CallbackInfo callback) {
		if (Freelook.getInstance().consumeRotation(cursorDeltaX, cursorDeltaY) ||
			Skyblock.getInstance().rotationLocked.get()) {
			callback.cancel();
		}
	}

	@Inject(method = "turn", at = @At("HEAD"))
	private void axolotlclient$updateLookDirection(double mouseDeltaX, double mouseDeltaY, CallbackInfo ci) {
		if (mouseDeltaX == 0 && mouseDeltaY == 0) {
			return;
		}

		float prevPitch = getXRot();
		float prevYaw = getYRot();
		float pitch = prevPitch + (float) (mouseDeltaY * .15);
		float yaw = prevYaw + (float) (mouseDeltaX * .15);
		pitch = class_3532.method_15363(pitch, -90.0F, 90.0F);
		Events.PLAYER_DIRECTION_CHANGE.invoker().accept(new PlayerDirectionChangeEvent(prevPitch, prevYaw, pitch, yaw));
	}
}
