/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_433;
import net.minecraft.class_437;
import net.minecraft.class_7845;
import com.llamalad7.mixinextras.sugar.Local;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientConfigCommon;
import io.github.axolotlclient.api.API;
import io.github.axolotlclient.api.APIOptions;
import io.github.axolotlclient.api.ChatsSidebar;
import io.github.axolotlclient.api.FriendsScreen;
import io.github.axolotlclient.modules.hud.HudEditScreen;
import io.github.axolotlclient.modules.hypixel.HypixelAbstractionLayer;
import io.github.axolotlclient.modules.hypixel.HypixelMods;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_433.class)
public abstract class GameMenuScreenMixin extends class_437 {

	protected GameMenuScreenMixin(class_2561 title) {
		super(title);
	}

	@Inject(method = "createPauseMenu", at = @At("TAIL"))
	private void axolotlclient$addButtons(CallbackInfo ci, @Local class_7845 widget) {
		if (API.getInstance().isAuthenticated()) {
			int buttonY = field_22790 - 30;
			if (APIOptions.getInstance().addShortcutButtons.get()) {
				method_37063(class_4185.method_46430(class_2561.method_43471("api.friends"),
						button -> field_22787.method_1507(new FriendsScreen(this)))
					.method_46434(10, buttonY, 75, 20).method_46431());
				buttonY -= 25;
			}
			method_37063(class_4185.method_46430(class_2561.method_43471("api.chats"),
					button -> field_22787.method_1507(new ChatsSidebar(this)))
				.method_46434(10, buttonY, 75, 20).method_46431());
		}
		if (AxolotlClientConfigCommon.instance().gameMenuScreenOptionButtonMode.get().showButton()) {
			method_37063(new class_4185(widget.method_46426() + widget.method_25368(),
				widget.method_46427() + 50, 20, 20,
				class_2561.method_43473(),
				button -> field_22787.method_1507(new HudEditScreen(this)), Supplier::get) {
				@Override
				public void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {
					super.method_48579(graphics, mouseX, mouseY, delta);
					graphics.method_25290(class_10799.field_56883, AxolotlClient.badgeIcon, this.method_46426() + 2, this.method_46427() + 2, 0, 0, this.field_22758 - 4, this.field_22759 - 4, this.field_22758 - 4, this.field_22759 - 4);
				}
			});
		}
	}

	@ModifyArg(method = "createPauseMenu", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/components/Button;builder(Lnet/minecraft/network/chat/Component;Lnet/minecraft/client/gui/components/Button$OnPress;)Lnet/minecraft/client/gui/components/Button$Builder;", ordinal = 1), index = 1)
	private class_4185.class_4241 axolotlclient$clearFeatureRestrictions(class_4185.class_4241 onPress) {
		return (buttonWidget) -> {
			if (Objects.equals(HypixelMods.getInstance().cacheMode.get(),
				HypixelMods.HypixelApiCacheMode.ON_CLIENT_DISCONNECT)) {
				HypixelAbstractionLayer.getInstance().clearPlayerData();
			}
			onPress.onPress(buttonWidget);
		};
	}
}
