/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin;

import java.util.concurrent.CompletableFuture;
import net.minecraft.class_310;
import net.minecraft.class_320;
import net.minecraft.class_5520;
import net.minecraft.class_7574;
import net.minecraft.class_7853;
import com.mojang.authlib.minecraft.UserApiService;
import com.mojang.authlib.yggdrasil.ProfileResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.gen.Accessor;

@Mixin(class_310.class)
public interface MinecraftClientAccessor {

	@Accessor("fps")
	static int axolotlclient$getCurrentFps() {
		return 0;
	}

	@Accessor("user")
	@Mutable
	void axolotlclient$setSession(class_320 session);

	@Accessor("playerSocialManager")
	@Mutable
	void axolotlclient$setSocialInteractionsManager(class_5520 manager);

	@Accessor("profileKeyPairManager")
	@Mutable
	void axolotlclient$setPlayerKeyPairManager(class_7853 manager);

	@Accessor("reportingContext")
	@Mutable
	void axolotlclient$setChatReportingContext(class_7574 context);

	@Accessor("userApiService")
	@Mutable
	void axolotlclient$setUserApiService(UserApiService service);

	@Accessor("profileFuture")
	@Mutable
	void axolotlclient$setProfileFuture(CompletableFuture<ProfileResult> future);
}
