/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientCommon;
import io.github.axolotlclient.modules.hypixel.LevelHead;
import io.github.axolotlclient.util.Util;
import io.github.axolotlclient.util.duck.NameTagSubmitExtension;
import net.minecraft.class_10799;
import net.minecraft.class_11661;
import net.minecraft.class_11689;
import net.minecraft.class_11788;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import net.minecraft.class_9848;
import net.minecraft.client.renderer.*;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_11689.class)
public abstract class NameTagFeatureRendererMixin {
	@Unique
	private static final class_1921 TEXTURED_TYPE = class_1921.method_24048("textured_quads", 1536, RenderPipeline.builder(class_10799.field_56864)
			.withLocation(class_2960.method_60655(AxolotlClientCommon.MODID, "pipeline/badge"))
			.withDepthTestFunction(DepthTestFunction.LEQUAL_DEPTH_TEST).build(),
		class_1921.class_4688.method_23598().method_34577(new class_4668.class_4683(AxolotlClient.badgeIcon, false))
			.method_23617(false));

	@Inject(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/Font;drawInBatch(Lnet/minecraft/network/chat/Component;FFIZLorg/joml/Matrix4f;Lnet/minecraft/client/renderer/MultiBufferSource;Lnet/minecraft/client/gui/Font$DisplayMode;II)V", ordinal = 1, shift = At.Shift.AFTER))
	private void renderBadges(class_11788 submitNodeCollection, class_4597.class_4598 bufferSource, class_327 font, CallbackInfo ci, @Local class_11661.class_11672 submit) {
		if (((NameTagSubmitExtension) (Object) submit).axolotlclient$hasBadge()) {
			var nameStartX = submit.comp_4515();
			if (AxolotlClient.config().customBadge.get()) {

				class_2561 badgeText = Util.formatFromCodes(AxolotlClient.config().badgeText.get());
				var x = nameStartX - (font.method_27525(badgeText) + 4);
				class_310.method_1551().field_1772.method_27522(badgeText, x, 0, -1, AxolotlClient.config().useShadows.get(), submit.comp_4514(), bufferSource, class_327.class_6415.field_33993, 0, 15728880);
			} else {
				var x = nameStartX - 10;
				var builder = class_310.method_1551().method_22940().method_23000().method_73477(TEXTURED_TYPE);
				Matrix4f matrix4f = submit.comp_4514();
				builder.method_22918(matrix4f, x, 0, 0).method_22913(0, 0).method_39415(-1);
				builder.method_22918(matrix4f, x, 8, 0).method_22913(0, 1).method_39415(-1);
				builder.method_22918(matrix4f, x + 8, 8, 0).method_22913(1, 1).method_39415(-1);
				builder.method_22918(matrix4f, x + 8, 0, 0).method_22913(1, 0).method_39415(-1);
				class_310.method_1551().method_22940().method_23000().method_22993();
			}
		}
	}

	@ModifyArg(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/Font;drawInBatch(Lnet/minecraft/network/chat/Component;FFIZLorg/joml/Matrix4f;Lnet/minecraft/client/renderer/MultiBufferSource;Lnet/minecraft/client/gui/Font$DisplayMode;II)V", ordinal = 1), index = 4)
	public boolean axolotlclient$enableShadows(boolean shadow) {
		return AxolotlClient.config().useShadows.get();
	}

	@ModifyArg(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/Font;drawInBatch(Lnet/minecraft/network/chat/Component;FFIZLorg/joml/Matrix4f;Lnet/minecraft/client/renderer/MultiBufferSource;Lnet/minecraft/client/gui/Font$DisplayMode;II)V"), index = 8)
	public int axolotlclient$bgColor(int color, @Local class_11661.class_11672 submit) {
		if (AxolotlClient.config().nametagBackground.get()) {
			return color;
		} else {
			return 0;
		}
	}

	@WrapOperation(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/Font;drawInBatch(Lnet/minecraft/network/chat/Component;FFIZLorg/joml/Matrix4f;Lnet/minecraft/client/renderer/MultiBufferSource;Lnet/minecraft/client/gui/Font$DisplayMode;II)V"))
	private void applyLevelHeadOptions(class_327 instance, class_2561 text, float x, float y, int color, boolean drawShadow, Matrix4f pose, class_4597 bufferSource, class_327.class_6415 mode, int backgroundColor, int packedLightCoords, Operation<Void> original, @Local class_11661.class_11672 submit) {
		if (((NameTagSubmitExtension) (Object) submit).axolotlclient$isForLevelHead()) {
			color = class_9848.method_61330(class_9848.method_61320(color), LevelHead.getInstance().textColor.get().toInt());
			if (backgroundColor != 0 && !LevelHead.getInstance().background.get()) {
				backgroundColor = 0;
			}
		}
		original.call(instance, text, x, y, color, drawShadow, pose, bufferSource, mode, backgroundColor, packedLightCoords);
	}
}
