/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin;

import io.github.axolotlclient.bridge.entity.AxoPlayer;
import io.github.axolotlclient.bridge.events.Events;
import io.github.axolotlclient.modules.particles.Particles;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2398;
import net.minecraft.class_310;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1657.class)
public abstract class PlayerEntityMixin extends class_1309 {

	protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
		super(entityType, world);
	}

	@Inject(method = "attack", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/player/Player;getAttributeValue(Lnet/minecraft/core/Holder;)D"))
	private void axolotlclient$getReach(class_1297 entity, CallbackInfo ci) {
		Events.PLAYER_ATTACK.invoker().accept((AxoPlayer) this, entity);
	}

	@Inject(method = "attack", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/player/Player;setLastHurtMob(Lnet/minecraft/world/entity/Entity;)V"))
	private void axolotlclient$alwaysCrit(class_1297 entity, CallbackInfo ci) {
		if (Particles.getInstance().getAlwaysOn(class_2398.field_11205)) {
			class_310.method_1551().field_1724.method_7277(entity);
		}
		if (Particles.getInstance().getAlwaysOn(class_2398.field_11208)) {
			class_310.method_1551().field_1724.method_7304(entity);
		}
	}

	// TODO this doesn't work currently
	/*@Inject(method = "hurtServer", at = @At("HEAD"))
	private void axolotlclient$damage(ServerLevel world, DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
		if (source.getEntity() != null && getUUID() == Minecraft.getInstance().player.getUUID()) {
			ReachHud reachDisplayHud = (ReachHud) HudManager.getInstance().get(ReachHud.ID);
			if (reachDisplayHud != null && reachDisplayHud.isEnabled()) {
				reachDisplayHud.updateDistance(source.getEntity(), this);
			}
		}

		if (source.getEntity() instanceof Player) {
			ComboHud comboHud = (ComboHud) HudManager.getInstance().get(ComboHud.ID);
			comboHud.onEntityDamage(this);
		}
	}*/
}
