/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import net.minecraft.class_2960;
import net.minecraft.class_3288;
import net.minecraft.class_3298;
import net.minecraft.class_3304;
import net.minecraft.class_3902;
import net.minecraft.class_4011;
import net.minecraft.class_6860;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.modules.hud.HudManager;
import io.github.axolotlclient.modules.hud.gui.hud.PackDisplayHud;
import io.github.axolotlclient.modules.hypixel.HypixelAbstractionLayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_3304.class)
public abstract class ReloadableResourceManagerMixin {

	@Inject(method = "createReload", at = @At("TAIL"))
	private void axolotlclient$reload(Executor prepareExecutor, Executor applyExecutor, CompletableFuture<class_3902> initialStage, List<class_3288> resourcePacks, CallbackInfoReturnable<class_4011> cir) {
		HypixelAbstractionLayer.getInstance().clearPlayerData();

		PackDisplayHud hud = (PackDisplayHud) HudManager.getInstance().get(PackDisplayHud.ID);
		if (hud != null) {
			hud.update();
		}
	}

	@Inject(method = "getResource", at = @At("HEAD"), cancellable = true)
	private void axolotlclient$getResource(class_2960 id, CallbackInfoReturnable<Optional<class_3298>> cir) {
		if (AxolotlClient.runtimeResources.get(id) != null) {
			cir.setReturnValue(Optional.of(AxolotlClient.runtimeResources.get(id)));
		}
	}

	@WrapOperation(method = "listResources", at = @At(value = "INVOKE",
		target = "Lnet/minecraft/server/packs/resources/CloseableResourceManager;listResources(Ljava/lang/String;Ljava/util/function/Predicate;)Ljava/util/Map;"))
	private Map<class_2960, class_3298> injectResources(class_6860 instance, String s, Predicate<class_2960> predicate, Operation<Map<class_2960, class_3298>> original) {
		var resources = original.call(instance, s, predicate);
		AxolotlClient.runtimeResources.forEach((resourceLocation, resource) -> {
			if (resourceLocation.method_12832().startsWith(s) && predicate.test(resourceLocation)) {
				resources.computeIfAbsent(resourceLocation, l -> resource);
			}
		});
		return resources;
	}
}
