/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientConfigCommon;
import io.github.axolotlclient.api.API;
import io.github.axolotlclient.api.APIOptions;
import io.github.axolotlclient.api.FriendsScreen;
import io.github.axolotlclient.api.NewsScreen;
import io.github.axolotlclient.api.chat.ChatListScreen;
import io.github.axolotlclient.api.requests.GlobalDataRequest;
import io.github.axolotlclient.modules.auth.Auth;
import io.github.axolotlclient.modules.auth.AuthWidget;
import io.github.axolotlclient.modules.hud.HudEditScreen;
import io.github.axolotlclient.modules.zoom.Zoom;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_3675;
import net.minecraft.class_407;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4399;
import net.minecraft.class_442;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_442.class)
public abstract class TitleScreenMixin extends class_437 {

	@Shadow
	@Nullable
	private class_4399 realmsNotificationsScreen;

	protected TitleScreenMixin() {
		super(class_2561.method_43473());
	}

	@Inject(method = "createNormalMenuOptions", at = @At("TAIL"))
	private void axolotlclient$inMenu(int y, int spacingY, CallbackInfoReturnable<Integer> cir) {
		if (field_22787.field_1690.field_1879.method_1435(Zoom.key)) {
			field_22787.field_1690.field_1879.method_1422(class_3675.field_16237);
			AxolotlClient.LOGGER.info("Unbound \"Save Toolbar Activator\" to resolve conflict with the zoom key!");
		}
		List<class_339> buttons = Collections.synchronizedList(new ArrayList<>());
		int leftButtonY = 10;
		if (Auth.getInstance().showButton.get()) {
			var button = method_37063(new AuthWidget(10, leftButtonY));
			buttons.add(button);
			leftButtonY += button.method_25364() + 5;
		}
		if (APIOptions.getInstance().addShortcutButtons.get()) {
			int shortcutButtonY = leftButtonY;
			Runnable addApiButtons = () -> field_22787.method_20493(() -> {
				buttons.add(method_37063(class_4185.method_46430(class_2561.method_43471("api.friends"),
					w -> field_22787.method_1507(new FriendsScreen(this))).method_46434(10, shortcutButtonY, 50, 20).method_46431()));
				buttons.add(method_37063(class_4185.method_46430(class_2561.method_43471("api.chats"),
					w -> field_22787.method_1507(new ChatListScreen(this))).method_46434(10, shortcutButtonY + 25, 50, 20).method_46431()));
			});
			if (API.getInstance().isSocketConnected()) {
				addApiButtons.run();
			} else {
				API.addStartupListener(addApiButtons, API.ListenerType.ONCE);
			}
		}
		GlobalDataRequest.get().thenAccept(data -> {
			int buttonY = 10;
			if (APIOptions.getInstance().updateNotifications.get() &&
				data.success() &&
				data.latestVersion().isNewerThan(AxolotlClient.VERSION)) {
				buttons.add(method_37063(class_4185.method_46430(class_2561.method_43471("api.new_version_available"),
						class_407.method_49625(this, "https://modrinth.com/mod/axolotlclient/versions"))
					.method_46434(field_22789 - 90, y, 80, 20).method_46431()));
				buttonY += 22;
			}
			if (APIOptions.getInstance().displayNotes.get() &&
				data.success() && !data.notes().isEmpty()) {
				buttons.add(method_37063(class_4185.method_46430(class_2561.method_43471("api.notes"), buttonWidget ->
						field_22787.method_1507(new NewsScreen(this)))
					.method_46434(field_22789 - 90, buttonY, 80, 20).method_46431()));
			}
		});

		// Thanks modmenu.. >:3
		if (FabricLoader.getInstance().isModLoaded("modmenu")) {
			try {
				Class<?> booleanConfigOpt = MethodHandles.lookup().findClass("com.terraformersmc.modmenu.config.option.BooleanConfigOption");
				Class<?> enumConfigOpt = MethodHandles.lookup().findClass("com.terraformersmc.modmenu.config.option.EnumConfigOption");
				Class<?> titleMenuButtonStyle = MethodHandles.lookup().findClass("com.terraformersmc.modmenu.config.ModMenuConfig$TitleMenuButtonStyle");
				Class<?> modmenuConfig = MethodHandles.lookup().findClass("com.terraformersmc.modmenu.config.ModMenuConfig");
				MethodHandle modifyTitleScreenHandle = MethodHandles.lookup().findStaticGetter(modmenuConfig, "MODIFY_TITLE_SCREEN", booleanConfigOpt);
				MethodHandle getValueB = MethodHandles.lookup().findVirtual(booleanConfigOpt, "getValue", MethodType.methodType(boolean.class));
				MethodHandle getValueE = MethodHandles.lookup().findVirtual(enumConfigOpt, "getValue", MethodType.methodType(Enum.class));
				var modifyTitleScreen = modifyTitleScreenHandle.invoke();
				boolean isModifyTitleScreen = (boolean) getValueB.invoke(modifyTitleScreen);
				MethodHandle modsButtonStyleHandle = MethodHandles.lookup().findStaticGetter(modmenuConfig, "MODS_BUTTON_STYLE", enumConfigOpt);
				var modsButtonStyle = getValueE.invoke(modsButtonStyleHandle.invoke());
				var classic = titleMenuButtonStyle.getEnumConstants()[0];
				if (isModifyTitleScreen && modsButtonStyle == classic) {
					buttons.forEach(r -> r.method_46419(r.method_46427() - 24 / 2));
				}
			} catch (Throwable ignored) {
			}
		}
	}

	@Inject(method = "realmsNotificationsEnabled", at = @At("HEAD"), cancellable = true)
	private void axolotlclient$disableRealmsNotifications(CallbackInfoReturnable<Boolean> cir) {
		this.realmsNotificationsScreen = null;
		cir.setReturnValue(false);
	}

	@WrapOperation(method = "createNormalMenuOptions",
		at = @At(value = "INVOKE",
			target = "Lnet/minecraft/client/gui/components/Button;builder(Lnet/minecraft/network/chat/Component;Lnet/minecraft/client/gui/components/Button$OnPress;)Lnet/minecraft/client/gui/components/Button$Builder;", ordinal = 2))
	private class_4185.class_7840 axolotlclient$noRealmsbutOptionsButton(class_2561 message, class_4185.class_4241 onPress, Operation<class_4185.class_7840> original) {
		if (AxolotlClientConfigCommon.instance().titleScreenOptionButtonMode.get().showButton()) {
			message = class_2561.method_43471("config");
			onPress = buttonWidget -> field_22787.method_1507(new HudEditScreen(this));
		}
		return original.call(message, onPress);
	}

	@ModifyArg(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Ljava/lang/String;III)V"), index = 1)
	private String axolotlclient$setVersionText(String s) {
		return "Minecraft " + class_155.method_16673().comp_4025() + "/AxolotlClient "
			+ AxolotlClient.VERSION;
	}

	@Inject(method = "realmsNotificationsEnabled", at = @At("HEAD"), cancellable = true)
	private void axolotlclient$noRealmsIcons(CallbackInfoReturnable<Boolean> cir) {
		cir.setReturnValue(false);
	}
}
