/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.auth.skin;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_11239;
import net.minecraft.class_1921;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5602;
import net.minecraft.class_591;
import net.minecraft.class_7833;
import net.minecraft.class_9950;
import com.mojang.blaze3d.systems.RenderSystem;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4fStack;

public class SkinRenderer extends class_11239<SkinRenderState> {
	private static final Map<String, SkinRenderer> renderers = new ConcurrentHashMap<>();

	public static void closeRenderers() {
		renderers.values().forEach(class_11239::close);
		renderers.clear();
	}

	public static SkinRenderer getOrCreate(class_4597.class_4598 bufferSource, class_310 minecraft, String id) {
		return renderers.computeIfAbsent(id, _id -> new SkinRenderer(bufferSource, minecraft, id));
	}

	private class_591 classicModel, slimModel;
	private class_9950 capeModel;
	private final class_310 minecraft;
	private final String id;

	private SkinRenderer(class_4597.class_4598 bufferSource, class_310 minecraft, String id) {
		super(bufferSource);
		this.minecraft = minecraft;
		this.id = id;
	}

	@Override
	public @NotNull Class<SkinRenderState> method_70903() {
		return SkinRenderState.class;
	}

	@Override
	protected void renderToTexture(SkinRenderState renderState, class_4587 poseStack) {
		if (classicModel == null && renderState.classicVariant()) {
			classicModel = new class_591(minecraft.method_31974().method_32072(class_5602.field_27577), false);
		}
		if (slimModel == null && !renderState.classicVariant()) {
			slimModel = new class_591(minecraft.method_31974().method_32072(class_5602.field_27581), true);
		}
		class_310.method_1551().field_1773.method_71114().method_71034(class_308.class_11274.field_60029);
		int i = class_310.method_1551().method_22683().method_4495();
		Matrix4fStack matrix4fStack = RenderSystem.getModelViewStack();
		matrix4fStack.pushMatrix();
		float f = renderState.comp_4133() * i;
		matrix4fStack.rotateAround(class_7833.field_40714.rotationDegrees(renderState.rotationX()), 0.0F, f * -renderState.pivotY(), 0.0F);
		poseStack.method_22907(class_7833.field_40716.rotationDegrees(-renderState.rotationY()));
		poseStack.method_46416(0.0F, -1.6010001F, 0.0F);
		var model = renderState.classicVariant() ? classicModel : slimModel;
		class_1921 renderType = model.method_23500(renderState.skinTexture());
		model.method_60879(poseStack, this.field_59933.method_73477(renderType), 15728880, class_4608.field_21444);
		if (renderState.cape() != null) {
			if (capeModel == null) {
				capeModel = new class_9950(minecraft.method_31974().method_32072(class_5602.field_52980));
			}
			var type = capeModel.method_23500(renderState.cape());
			poseStack.method_22907(class_7833.field_40714.rotationDegrees(6.0F));
			capeModel.method_60879(poseStack, field_59933.method_73477(type), 15728880, class_4608.field_21444);
		}
		this.field_59933.method_22993();
		matrix4fStack.popMatrix();
	}

	@Override
	protected @NotNull String method_70906() {
		return "axolotlclient/skin_render/" + id;
	}
}
