/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.hud.gui.hud.vanilla;

import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.EnumOption;
import io.github.axolotlclient.bridge.render.AxoRenderContext;
import io.github.axolotlclient.modules.hud.gui.component.DynamicallyPositionable;
import io.github.axolotlclient.modules.hud.gui.entry.TextHudEntry;
import io.github.axolotlclient.modules.hud.gui.layout.AnchorPoint;
import io.github.axolotlclient.modules.hud.util.DrawPosition;
import io.github.axolotlclient.modules.hud.util.DrawUtil;

public class DebugCountersHud extends TextHudEntry implements DynamicallyPositionable {
	public static final class_2960 ID = class_2960.method_60655("axolotlclient", "debugcountershud");
	private final EnumOption<AnchorPoint> anchor = new EnumOption<>("anchorpoint", AnchorPoint.class,
		AnchorPoint.TOP_LEFT);
	private final BooleanOption showCCount = new BooleanOption("debugcounters.ccount", true);
	private final BooleanOption showECount = new BooleanOption("debugcounters.ecount", false);
	private final BooleanOption showPCount = new BooleanOption("debugcounters.pcount", false);
	private final class_310 client = (class_310) super.client;

	public DebugCountersHud() {
		super(115, 32, true);
	}

	@Override
	public void renderComponent(AxoRenderContext context, float delta) {
		final var graphics = (class_332) context;

		if (client.field_1687 == null) {
			renderPlaceholderComponent(graphics, delta);
		}
		DrawPosition pos = getPos();
		int lineY = pos.y() + 2;
		int lineX = pos.x() + 1;

		int xEnd = lineX + 50;
		if (showCCount.get()) {
			xEnd = Math.max(xEnd, DrawUtil.drawString(graphics, client.field_1769.method_3289(), lineX, lineY, textColor.get().toInt(), shadow.get()));
			lineY += 10;
		}
		if (showECount.get()) {
			xEnd = Math.max(xEnd, DrawUtil.drawString(graphics, client.field_1769.method_3272(), lineX, lineY, textColor.get().toInt(), shadow.get()));
			lineY += 10;
		}
		if (showPCount.get()) {
			xEnd = Math.max(xEnd, DrawUtil.drawString(graphics, "P: " + client.field_1713.method_3052(), lineX, lineY, textColor.get().toInt(), shadow.get()));
			lineY += 10;
		}

		boolean boundsChanged = false;
		if (lineY != getHeight() + pos.y()) {
			boundsChanged = true;
			setHeight(lineY - pos.y());
		}
		if (xEnd != pos.x() + getWidth()) {
			boundsChanged = true;
			setWidth(xEnd - pos.x());
		}
		if (boundsChanged) {
			onBoundsUpdate();
		}
	}

	@Override
	public void renderPlaceholderComponent(AxoRenderContext context, float delta) {
		final var graphics = (class_332) context;

		DrawPosition pos = getPos();
		int lineY = pos.y() + 2;
		int lineX = pos.x() + 1;

		int xEnd = lineX + 50;
		if (showCCount.get()) {
			xEnd = Math.max(xEnd, DrawUtil.drawString(graphics, "C: 186/15000 (s) D: 10, pC: 000, pU: 00, aB: 20", lineX, lineY, textColor.get().toInt(), shadow.get()));
			lineY += 10;
		}
		if (showECount.get()) {
			xEnd = Math.max(xEnd, DrawUtil.drawString(graphics, "E: 695/3001, SD: 12", lineX, lineY, textColor.get().toInt(), shadow.get()));
			lineY += 10;
		}
		if (showPCount.get()) {
			xEnd = Math.max(xEnd, DrawUtil.drawString(graphics, "P: 200", lineX, lineY, textColor.get().toInt(), shadow.get()));
			lineY += 10;
		}

		boolean boundsChanged = false;
		if (lineY != getHeight() + pos.y()) {
			boundsChanged = true;
			setHeight(lineY - pos.y());
		}
		if (xEnd != pos.x() + getWidth()) {
			boundsChanged = true;
			setWidth(xEnd - pos.x());
		}
		if (boundsChanged) {
			onBoundsUpdate();
		}
	}

	@Override
	public class_2960 getId() {
		return ID;
	}

	@Override
	public AnchorPoint getAnchor() {
		return anchor.get();
	}

	@Override
	public List<Option<?>> getConfigurationOptions() {
		List<Option<?>> options = super.getConfigurationOptions();
		options.add(hide);
		options.add(anchor);
		options.add(showCCount);
		options.add(showECount);
		options.add(showPCount);
		return options;
	}
}
