/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.hud.gui.keystrokes;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

import com.google.common.collect.ImmutableList;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Colors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;

@Environment(EnvType.CLIENT)
public class KeyBindSelectionList extends class_4265<KeyBindSelectionList.Entry> {
	private static final int ITEM_HEIGHT = 20;
	final KeyBindSelectionScreen keyBindsScreen;
	private final Consumer<class_304> selectionConsumer;

	public KeyBindSelectionList(KeyBindSelectionScreen keyBindsScreen, class_310 minecraft, Consumer<class_304> selectionConsumer) {
		super(minecraft, keyBindsScreen.field_22789, keyBindsScreen.layout.method_57727(), keyBindsScreen.layout.method_48998(), ITEM_HEIGHT);
		this.keyBindsScreen = keyBindsScreen;
		this.selectionConsumer = selectionConsumer;
		class_304[] keyMappings = ArrayUtils.clone(minecraft.field_1690.field_1839);
		Arrays.sort(keyMappings);
		class_304.class_11900 string = null;

		for (class_304 keyMapping : keyMappings) {
			var string2 = keyMapping.method_1423();
			if (!string2.equals(string)) {
				string = string2;
				this.method_25321(new KeyBindSelectionList.CategoryEntry(string2.method_74697()));
			}

			class_2561 component = class_2561.method_43471(keyMapping.method_1431());
			this.method_25321(new KeyBindSelectionList.KeyEntry(keyMapping, component));
		}
	}

	@Override
	public int method_25322() {
		return 340;
	}

	@Environment(EnvType.CLIENT)
	public class CategoryEntry extends KeyBindSelectionList.Entry {
		final class_2561 name;
		private final int width;

		public CategoryEntry(final class_2561 name) {
			this.name = name;
			this.width = KeyBindSelectionList.this.field_22740.field_1772.method_27525(this.name);
		}

		@Override
		public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovering, float partialTick) {
			guiGraphics.method_27535(KeyBindSelectionList.this.field_22740.field_1772, this.name, KeyBindSelectionList.this.field_22758 / 2 - this.width / 2, method_73382() + method_73384() - 9 - 1, -1);
		}

		@Nullable
		@Override
		public class_8016 method_48205(class_8023 event) {
			return null;
		}

		@Override
		public List<? extends class_364> method_25396() {
			return Collections.emptyList();
		}

		@Override
		public List<? extends class_6379> method_37025() {
			return ImmutableList.of(new class_6379() {
				@Override
				public class_6379.class_6380 method_37018() {
					return class_6379.class_6380.field_33785;
				}

				@Override
				public void method_37020(class_6382 narrationElementOutput) {
					narrationElementOutput.method_37034(class_6381.field_33788, CategoryEntry.this.name);
				}
			});
		}
	}

	@Environment(EnvType.CLIENT)
	public abstract static class Entry extends class_4265.class_4266<KeyBindSelectionList.Entry> {

	}

	@Environment(EnvType.CLIENT)
	public class KeyEntry extends KeyBindSelectionList.Entry {
		private final class_2561 name, boundKey;
		private final class_4185 changeButton;

		KeyEntry(final class_304 key, final class_2561 name) {
			this.name = name;
			this.boundKey = key.method_16007();
			this.changeButton = class_4185.method_46430(class_2561.method_43471("keystrokes.key.select"), button -> {
					selectionConsumer.accept(key);
					keyBindsScreen.method_25419();
				})
				.method_46434(0, 0, 75, 20)
				.method_46431();
			changeButton.field_22763 = !(keyBindsScreen.stroke.getKey() != null && key == keyBindsScreen.stroke.getKey());
		}

		@Override
		public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovering, float partialTick) {
			int i = KeyBindSelectionList.this.method_65507() - 10;
			int j = method_73382() - 2;
			int k = i - 5 - this.changeButton.method_25368();
			this.changeButton.method_48229(k, j);
			this.changeButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
			guiGraphics.method_27535(field_22740.field_1772, this.name, method_73380(), method_73382() + method_73384() / 2 - 9 / 2, -1);
			guiGraphics.method_27535(field_22740.field_1772, boundKey, method_73380() + method_73387() / 2 - field_22740.field_1772.method_27525(boundKey) / 2, method_73382() + method_73384() / 2 - 9 / 2, Colors.GRAY.toInt());
		}

		@Override
		public List<? extends class_364> method_25396() {
			return ImmutableList.of(this.changeButton);
		}

		@Override
		public List<? extends class_6379> method_37025() {
			return ImmutableList.of(this.changeButton);
		}
	}
}
