/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.hud.gui.keystrokes;

import java.util.List;

import com.google.common.collect.ImmutableList;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Colors;
import io.github.axolotlclient.modules.hud.gui.hud.KeystrokeHud;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_6379;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import org.jetbrains.annotations.Nullable;

@Environment(EnvType.CLIENT)
public class KeyBindsList extends class_4265<KeyBindsList.Entry> {
	final KeystrokesScreen keyBindsScreen;
	private int maxNameWidth;

	public KeyBindsList(KeystrokesScreen keyBindsScreen) {
		super(class_310.method_1551(), keyBindsScreen.field_22789, keyBindsScreen.layout.method_57727(), keyBindsScreen.layout.method_48998(), 24);
		this.keyBindsScreen = keyBindsScreen;

		reload();
	}

	public void reload() {
		method_25339();
		for (KeystrokeHud.Keystroke keyMapping : keyBindsScreen.hud.keystrokes) {

			class_2561 component = class_2561.method_43471(keyMapping.getKey().getName());
			int i = field_22740.field_1772.method_27525(component);
			if (i > this.maxNameWidth) {
				this.maxNameWidth = i;
			}

			this.method_25321(new KeyEntry(keyMapping, component));
		}

		method_25321(new SpacerEntry());
		method_25321(new NewEntry());
	}

	@Override
	public int method_25322() {
		return 340;
	}

	@Environment(EnvType.CLIENT)
	public abstract static class Entry extends class_4265.class_4266<Entry> {

	}

	public static class SpacerEntry extends Entry {

		@Override
		public List<? extends class_6379> method_37025() {
			return List.of();
		}

		@Override
		public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovering, float partialTick) {

		}

		@Override
		public List<? extends class_364> method_25396() {
			return List.of();
		}

		@Nullable
		@Override
		public class_8016 method_48205(class_8023 event) {
			return null;
		}
	}

	private static final class_2561 CONFIGURE_BUTTON_TITLE = class_2561.method_43471("keystrokes.stroke.configure");

	@Environment(EnvType.CLIENT)
	public class KeyEntry extends Entry {
		private static final class_2561 REMOVE_BUTTON_TITLE = class_2561.method_43471("keystrokes.stroke.remove");
		private final KeystrokeHud.Keystroke key;
		private final class_2561 name;
		private final class_4185 configureButton, removeButton;

		KeyEntry(final KeystrokeHud.Keystroke key, final class_2561 name) {
			this.key = key;
			this.name = key.getKey().getTranslatedKeyMessage();
			this.configureButton = class_4185.method_46430(CONFIGURE_BUTTON_TITLE, button -> field_22740.method_1507(new ConfigureKeyBindScreen(keyBindsScreen, keyBindsScreen.hud, key, false)))
				.method_46434(0, 0, 75, 20)
				.method_46431();
			this.removeButton = class_4185.method_46430(REMOVE_BUTTON_TITLE, b -> {
					method_25330(this);
					keyBindsScreen.removeKey(key);
					method_65506();
				}).method_46434(0, 0, 50, 20)
				.method_46431();
		}

		@Override
		public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovering, float partialTick) {
			int i = KeyBindsList.this.method_65507() - removeButton.method_25368() - 10;
			int j = method_73382() - 2;
			this.removeButton.method_48229(i, j);
			this.removeButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
			int k = i - this.configureButton.method_25368();
			this.configureButton.method_48229(k, j);
			this.configureButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
			guiGraphics.method_51448().pushMatrix();
			var rect = key.getRenderPosition();
			float scale = Math.min((float) method_73384() / rect.height(), (float) 100 / rect.width());
			guiGraphics.method_51448().translate(method_73380(), method_73382());
			guiGraphics.method_51448().scale(scale, scale);
			guiGraphics.method_51448().translate(-rect.x(), -rect.y());
			key.render(guiGraphics);
			guiGraphics.method_51448().popMatrix();
			guiGraphics.method_27535(field_22740.field_1772, name, method_73380() + method_73387() / 2 - field_22740.field_1772.method_27525(name) / 2, method_73382() + method_73384() / 2 - 9 / 2, Colors.GRAY.toInt());
		}

		@Override
		public List<? extends class_364> method_25396() {
			return ImmutableList.of(this.configureButton, removeButton);
		}

		@Override
		public List<? extends class_6379> method_37025() {
			return ImmutableList.of(this.configureButton, removeButton);
		}
	}

	public class NewEntry extends Entry {

		private final class_4185 addButton, addSpecialButton;
		private final KeystrokeHud.Keystroke key = keyBindsScreen.hud.newStroke();

		public NewEntry() {
			this.addButton = class_4185.method_46430(class_2561.method_43471("keystrokes.stroke.add"), button -> field_22740.method_1507(new ConfigureKeyBindScreen(keyBindsScreen, keyBindsScreen.hud, key, true)))
				.method_46434(0, 0, 150, 20)
				.method_46431();
			this.addSpecialButton = class_4185.method_46430(class_2561.method_43471("keystrokes.stroke.add.special"),
					button -> field_22740.method_1507(new AddSpecialKeystrokeScreen(keyBindsScreen, keyBindsScreen.hud)))
				.method_46432(150).method_46431();
		}

		@Override
		public List<? extends class_6379> method_37025() {
			return List.of(addSpecialButton, addButton);
		}

		@Override
		public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovering, float partialTick) {
			int i = KeyBindsList.this.method_65507() - method_73387() / 2 - 10 + 4;
			int j = method_73382() - 2;
			this.addButton.method_48229(i, j);
			this.addButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
			int k = i - addButton.method_25368() - 8;
			this.addSpecialButton.method_48229(k, j);
			this.addSpecialButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
		}

		@Override
		public List<? extends class_364> method_25396() {
			return List.of(addSpecialButton, addButton);
		}
	}
}
