/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.hud.gui.keystrokes;

import java.util.Arrays;
import java.util.List;

import com.google.common.collect.ImmutableList;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Colors;
import io.github.axolotlclient.modules.hud.gui.hud.KeystrokeHud;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_6379;
import org.apache.commons.lang3.ArrayUtils;

@Environment(EnvType.CLIENT)
public class SpecialKeystrokeSelectionList extends class_4265<SpecialKeystrokeSelectionList.Entry> {
	private static final int ITEM_HEIGHT = 20;
	final AddSpecialKeystrokeScreen keyBindsScreen;

	public SpecialKeystrokeSelectionList(AddSpecialKeystrokeScreen keyBindsScreen, class_310 minecraft) {
		super(minecraft, keyBindsScreen.field_22789, keyBindsScreen.layout.method_57727(), keyBindsScreen.layout.method_48998(), ITEM_HEIGHT);
		this.keyBindsScreen = keyBindsScreen;
		KeystrokeHud.SpecialKeystroke[] strokes = ArrayUtils.clone(KeystrokeHud.SpecialKeystroke.values());
		Arrays.sort(strokes);

		for (KeystrokeHud.SpecialKeystroke keyMapping : strokes) {
			this.method_25321(new KeyEntry(keyMapping));
		}
	}

	@Override
	public int method_25322() {
		return 340;
	}

	@Environment(EnvType.CLIENT)
	public abstract static class Entry extends class_4265.class_4266<Entry> {

	}

	@Environment(EnvType.CLIENT)
	public class KeyEntry extends Entry {
		private final class_2561 boundKey;
		private final class_4185 addButton;
		private final KeystrokeHud.Keystroke keystroke;

		KeyEntry(final KeystrokeHud.SpecialKeystroke key) {
			this.keystroke = keyBindsScreen.hud.newSpecialStroke(key);
			this.boundKey = key.getKey().getTranslatedKeyMessage();
			this.addButton = class_4185.method_46430(class_2561.method_43471("keystrokes.stroke.add"), button -> keyBindsScreen.hud.keystrokes.add(keyBindsScreen.hud.newSpecialStroke(key)))
				.method_46434(0, 0, 75, 20)
				.method_46431();
		}

		@Override
		public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovering, float partialTick) {
			int i = SpecialKeystrokeSelectionList.this.method_65507() - 10;
			int j = method_73382() - 2;
			int k = i - 5 - this.addButton.method_25368();
			this.addButton.method_48229(k, j);
			this.addButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
			guiGraphics.method_51448().pushMatrix();
			var rect = keystroke.getRenderPosition();
			float scale = Math.min((float) field_22759 / rect.height(), (float) 100 / rect.width());
			guiGraphics.method_51448().translate(method_73380(), method_73382());
			guiGraphics.method_51448().scale(scale, scale);
			guiGraphics.method_51448().translate(-rect.x(), -rect.y());
			keystroke.render(guiGraphics);
			guiGraphics.method_51448().popMatrix();
			guiGraphics.method_27535(field_22740.field_1772, boundKey, method_73380() + 110 + (k - method_73380() - 110) / 3, method_73382() + field_22759 / 2 - 9 / 2, Colors.GRAY.toInt());
		}

		@Override
		public List<? extends class_364> method_25396() {
			return ImmutableList.of(this.addButton);
		}

		@Override
		public List<? extends class_6379> method_37025() {
			return ImmutableList.of(this.addButton);
		}
	}
}
