/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.hud.util;

import net.minecraft.class_11239;
import net.minecraft.class_11684;
import net.minecraft.class_12075;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_898;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class PlayerHudEntityRenderer extends class_11239<PlayerHudEntityRenderState> {
	private final class_898 entityRenderDispatcher;

	public PlayerHudEntityRenderer(class_4597.class_4598 bufferSource, class_898 entityRenderDispatcher) {
		super(bufferSource);
		this.entityRenderDispatcher = entityRenderDispatcher;
	}

	@Override
	public Class<PlayerHudEntityRenderState> method_70903() {
		return PlayerHudEntityRenderState.class;
	}

	@Override
	protected String method_70906() {
		return "axolotlclient:playerhud";
	}

	protected void renderToTexture(PlayerHudEntityRenderState guiEntityRenderState, class_4587 poseStack) {
		class_310.method_1551().field_1773.method_71114().method_71034(class_308.class_11274.field_60028);
		Vector3f vector3f = guiEntityRenderState.translation();
		poseStack.method_46416(vector3f.x, vector3f.y, vector3f.z);
		poseStack.method_22907(guiEntityRenderState.rotation());
		Quaternionf quaternionf = guiEntityRenderState.overrideCameraAngle();
		class_11684 featureRenderDispatcher = class_310.method_1551().field_1773.method_72911();
		class_12075 cameraRenderState = new class_12075();
		if (quaternionf != null) {
			cameraRenderState.field_63081 = quaternionf.conjugate(new Quaternionf()).rotateY((float) Math.PI);
		}

		this.entityRenderDispatcher.method_72976(guiEntityRenderState.renderState(), cameraRenderState, 0.0, 0.0, 0.0, poseStack, featureRenderDispatcher.method_73003());
		featureRenderDispatcher.method_73002();
	}

	@Override
	protected float method_70907(int i, int j) {
		return i / 2.0F;
	}
}
