/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.hypixel.autoboop;

import java.util.List;

import com.google.common.collect.ImmutableList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_6379;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import org.jetbrains.annotations.Nullable;

@Environment(EnvType.CLIENT)
public class FiltersList extends class_4265<FiltersList.Entry> {
	private final SpacerEntry spacer = new SpacerEntry();
	private final NewEntry newEntry = new NewEntry();
	final FilterListConfigurationScreen screen;

	public FiltersList(FilterListConfigurationScreen screen) {
		super(class_310.method_1551(), screen.field_22789, screen.layout.method_57727(), screen.layout.method_48998(), 24);
		this.screen = screen;

		reload();
	}

	public void reload() {
		method_25339();
		for (String entry : screen.filters) {
			this.method_25321(new FilterEntry(entry));
		}

		method_25321(spacer);
		method_25321(newEntry);
	}

	@Override
	public int method_25322() {
		return 340;
	}

	public void apply() {
		screen.filters.clear();
		screen.filters.addAll(method_25396().stream().filter(e -> e instanceof FilterEntry)
			.map(e -> (FilterEntry) e)
			.map(e -> e.editBox.method_1882())
			.filter(s -> !s.isBlank()).toList());
	}

	@Override
	public boolean method_25402(class_11909 event, boolean doubleClick) {
		method_25396().stream().filter(e -> e instanceof FilterEntry)
			.map(e -> (FilterEntry) e).map(e -> e.editBox).forEach(e -> e.method_25365(false));
		return super.method_25402(event, doubleClick);
	}

	@Environment(EnvType.CLIENT)
	public abstract static class Entry extends class_4265.class_4266<Entry> {

	}

	public static class SpacerEntry extends Entry {

		@Override
		public List<? extends class_6379> method_37025() {
			return List.of();
		}

		@Override
		public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovering, float partialTick) {

		}

		@Override
		public List<? extends class_364> method_25396() {
			return List.of();
		}

		@Nullable
		@Override
		public class_8016 method_48205(class_8023 event) {
			return null;
		}
	}

	@Environment(EnvType.CLIENT)
	public class FilterEntry extends Entry {
		private static final class_2561 REMOVE_BUTTON_TITLE = class_2561.method_43471("autoboop.filters.remove");
		private final class_342 editBox;
		private final class_4185 removeButton;

		FilterEntry(String filter) {
			this.editBox = new class_342(screen.method_64506(), 0, 0, 200, 20, class_2561.method_43471("autoboop.filters.edit"));
			editBox.method_1852(filter);
			editBox.method_1880(16);
			this.removeButton = class_4185.method_46430(REMOVE_BUTTON_TITLE, b -> {
					method_25330(this);
					apply();
					method_65506();
				}).method_46434(0, 0, 50, 20)
				.method_46431();
		}

		@Override
		public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovering, float partialTick) {
			int i = method_65507() - removeButton.method_25368() - 10;
			int j = method_73382() - 2;
			this.removeButton.method_48229(i, j);
			this.removeButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);

			this.editBox.method_48229(method_73380(), j);
			this.editBox.method_25358(i - method_73380() - 4);
			this.editBox.method_25394(guiGraphics, mouseX, mouseY, partialTick);
		}

		@Override
		public List<? extends class_364> method_25396() {
			return ImmutableList.of(this.editBox, removeButton);
		}

		@Override
		public List<? extends class_6379> method_37025() {
			return ImmutableList.of(this.editBox, removeButton);
		}
	}

	public class NewEntry extends Entry {

		private final class_4185 addButton;

		public NewEntry() {
			this.addButton = class_4185.method_46430(class_2561.method_43471("autoboop.filters.add"), button -> {
					method_25330(spacer);
					method_25330(newEntry);
					method_25321(new FilterEntry(""));
					method_25321(spacer);
					method_25321(newEntry);
					apply();
					method_44382(method_44390());
				}).method_46434(0, 0, 150, 20)
				.method_46431();
		}

		@Override
		public List<? extends class_6379> method_37025() {
			return List.of(addButton);
		}

		@Override
		public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovering, float partialTick) {
			int i = method_65507() - method_73387() / 2 - 10 - addButton.method_25368() / 2;
			int j = method_73382() - 2;
			this.addButton.method_48229(i, j);
			this.addButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
		}

		@Override
		public List<? extends class_364> method_25396() {
			return List.of(addButton);
		}
	}
}
