/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.rpc;

import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.util.Util;
import net.minecraft.class_310;

public class DiscordRPC extends RPCCommon {
	private static DiscordRPC Instance;
	private String currentWorld = "";

	private DiscordRPC() {
		super(AxolotlClient.LOGGER);
	}

	public static DiscordRPC getInstance() {
		if (Instance == null) Instance = new DiscordRPC();
		return Instance;
	}

	public void setWorld(String world) {
		currentWorld = world;
	}

	@Override
	protected void createRichPresence() {

		String state = switch (showServerNameMode.get()) {
			case "showIp" -> class_310.method_1551().field_1687 == null ? "In the menu"
				: (class_310.method_1551().method_1558() == null
				? "Singleplayer"
				: class_310.method_1551().method_1558().field_3761);
			case "showName" -> class_310.method_1551().field_1687 == null ? "In the menu" : (
				class_310.method_1551().method_1558() == null ? "Singleplayer"
					: class_310.method_1551().method_1558().field_3752);
			default -> "";
		};

		String details;
		if (showActivity.get() && class_310.method_1551().method_1558() != null) {
			details = (Util.getGame());
		} else if (showActivity.get() && !currentWorld.isEmpty()) {
			details = (currentWorld);
			currentWorld = "";
		} else {
			details = "";
		}

		setRichPresence(createRichPresence(AxolotlClient.VERSION, state, details));
	}

	public void init() {
		super.init();

		AxolotlClient.config().addCategory(category);
	}
}
