/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.screenshotUtils;

import java.util.function.Consumer;

import lombok.Getter;
import lombok.Setter;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7842;
import net.minecraft.class_7843;
import net.minecraft.class_8021;
import net.minecraft.class_8133;
import net.minecraft.class_8662;
import net.minecraft.class_8667;

public class DownloadImageScreen extends class_437 {
	private static final class_2960 SPRITE = class_2960.method_60655("axolotlclient", "go");

	private final class_437 parent;

	public DownloadImageScreen(class_437 parent) {
		super(class_2561.method_43471("viewScreenshot"));
		this.parent = parent;
	}

	@Override
	protected void method_25426() {
		var hFL = new ImprovedHeaderAndFooterLayout(this);

		hFL.addTitleHeader(method_25440(), field_22793);
		var urlBox = new class_342(field_22793, field_22789 / 2 - 100, field_22790 / 2 - 10, 200, 20, class_2561.method_43471("pasteURL"));
		urlBox.method_1887(class_1074.method_4662("pasteURL"));
		urlBox.method_1863(s -> {
			if (s.isEmpty()) {
				urlBox.method_1887(class_1074.method_4662("pasteURL"));
			} else {
				urlBox.method_1887("");
			}
		});
		urlBox.method_1880(63);
		var linear = hFL.addToContents(class_8667.method_52742().method_52735(4));
		linear.method_52740().method_46474();
		linear.method_52736(urlBox);
		linear.method_52736(class_8662.method_52723(class_2561.method_43471("download"), b -> {
				String url = urlBox.method_1882().trim();
				if (url.isEmpty()) {
					return;
				}
				//noinspection DataFlowIssue
				field_22787.method_1507(ImageScreen.create(this, ImageShare.getInstance().downloadImage(url), true));
			}, true)
			.method_52727(SPRITE, 20, 20)
			.method_52725(20).method_52724()).method_48229(field_22789 / 2 + 100 + 4, field_22790 / 2 - 10);

		hFL.addToFooter(class_4185.method_46430(class_5244.field_24339, b -> method_25419()).method_46431());

		hFL.method_48222();
		hFL.method_48206(this::method_37063);
		method_48265(urlBox);
	}

	@Override
	public void method_25419() {
		//noinspection DataFlowIssue
		field_22787.method_1507(parent);
	}


	public static class ImprovedHeaderAndFooterLayout implements class_8133 {
		public static final int DEFAULT_HEADER_AND_FOOTER_HEIGHT = 33;
		private static final int CONTENT_MARGIN_TOP = 30;
		private final class_7843 headerFrame = new class_7843();
		private final class_7843 footerFrame = new class_7843();
		private final class_7843 contentsFrame = new class_7843();
		private final class_437 screen;
		@Getter
		@Setter
		private int headerHeight;
		@Setter
		@Getter
		private int footerHeight;

		public ImprovedHeaderAndFooterLayout(class_437 screen) {
			this(screen, DEFAULT_HEADER_AND_FOOTER_HEIGHT);
		}

		public ImprovedHeaderAndFooterLayout(class_437 screen, int height) {
			this(screen, height, height);
		}

		public ImprovedHeaderAndFooterLayout(class_437 screen, int headerHeight, int footerHeight) {
			this.screen = screen;
			this.headerHeight = headerHeight;
			this.footerHeight = footerHeight;
			this.headerFrame.method_46450().method_46463(0.5F, 0.5F);
			this.footerFrame.method_46450().method_46463(0.5F, 0.5F);
		}

		@Override
		public void method_46421(int x) {
		}

		@Override
		public void method_46419(int y) {
		}

		@Override
		public int method_46426() {
			return 0;
		}

		@Override
		public int method_46427() {
			return 0;
		}

		@Override
		public int method_25368() {
			return this.screen.field_22789;
		}

		@Override
		public int method_25364() {
			return this.screen.field_22790;
		}

		public int getContentHeight() {
			return this.screen.field_22790 - this.getHeaderHeight() - this.getFooterHeight();
		}

		@Override
		public void method_48227(Consumer<class_8021> visitor) {
			this.headerFrame.method_48227(visitor);
			this.contentsFrame.method_48227(visitor);
			this.footerFrame.method_48227(visitor);
		}

		@Override
		public void method_48222() {
			int i = this.getHeaderHeight();
			int j = this.getFooterHeight();
			this.headerFrame.method_46449(this.screen.field_22789);
			this.headerFrame.method_46447(i);
			this.headerFrame.method_48229(0, 0);
			this.headerFrame.method_48222();
			this.footerFrame.method_46449(this.screen.field_22789);
			this.footerFrame.method_46447(j);
			this.footerFrame.method_48222();
			this.footerFrame.method_46419(this.screen.field_22790 - j);
			contentsFrame.method_46447(getContentHeight()); // This line makes it possible to center things vertically in this layout. Thanks mojang.
			this.contentsFrame.method_46449(this.screen.field_22789);
			this.contentsFrame.method_48222();
			int k = i + CONTENT_MARGIN_TOP;
			int l = this.screen.field_22790 - j - this.contentsFrame.method_25364();
			this.contentsFrame.method_48229(0, Math.min(k, l));
		}

		public void addTitleHeader(class_2561 message, class_327 font) {
			this.headerFrame.method_46441(new class_7842(message, font));
		}

		public <T extends class_8021> T addToFooter(T child) {
			return this.footerFrame.method_46441(child);
		}

		public <T extends class_8021> T addToContents(T child) {
			return this.contentsFrame.method_46441(child);
		}
	}
}
