/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.screenshotUtils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Locale;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import com.google.common.hash.Hashing;

public interface ImageInstance {

	class_2960 id();

	class_1011 image();

	String filename();

	interface Local extends ImageInstance {
		Path location();

		default ImageInstance toShared(String url, String uploader, Instant sharedAt) {
			return new SharedImpl(id(), image(), filename(), location(), url, uploader, sharedAt);
		}
	}

	interface Remote extends ImageInstance {
		String url();

		String uploader();

		Instant sharedAt();

		default ImageInstance toShared(Path saved) {
			return new SharedImpl(id(), image(), filename(), saved, url(), uploader(), sharedAt());
		}
	}

	private static void register(class_2960 id, class_1011 img) {
		class_310.method_1551().execute(() -> class_310.method_1551().method_1531().method_4616(id, new class_1043(id::toString, img)));
	}

	record LocalImpl(class_2960 id, class_1011 image, String filename, Path location) implements Local {
		public LocalImpl(class_1011 image, String filename, Path location) {
			this(class_2960.method_60655("axolotlclient", "gallery_local_" + Hashing.sha256().hashUnencodedChars(location.toString().toLowerCase(Locale.ROOT).replaceAll("[./]", "_"))),
				image, filename, location);
			register(id(), image());
		}

		public LocalImpl(Path p) throws IOException {
			this(class_1011.method_4309(Files.newInputStream(p)), p.getFileName().toString(), p);
		}
	}

	record SharedImpl(class_2960 id, class_1011 image, String filename, Path location, String url,
					  String uploader, Instant sharedAt) implements Local, Remote {

	}

	record RemoteImpl(class_2960 id, class_1011 image, String filename, String uploader, Instant sharedAt,
					  String url) implements Remote {
		public RemoteImpl(class_1011 image, String filename, String uploader, Instant sharedAt, String url) {
			this(class_2960.method_60655("axolotlclient", "gallery_remote_" + Hashing.sha256().hashUnencodedChars(url.toLowerCase(Locale.ROOT).replaceAll("[./]", "_"))),
				image, filename, uploader, sharedAt, url
			);
			register(id(), image());
		}
	}
}
