/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.util;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import io.github.axolotlclient.mixin.GameRendererAccessor;
import io.github.axolotlclient.mixin.GuiGraphicsAccessor;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4588;
import net.minecraft.class_8030;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;

public record HorizontalGradientRectangleRenderState(RenderPipeline pipeline,
													 class_11231 textureSetup,
													 Matrix3x2f pose,
													 int x0,
													 int y0,
													 int x1,
													 int y1,
													 int col1,
													 int col2,
													 @Nullable class_8030 scissorArea,
													 @Nullable class_8030 bounds) implements class_11244 {

	public static HorizontalGradientRectangleRenderState create(class_332 graphics, int x0, int y0, int x1, int y1, int col1, int col2) {
		var matrix = new Matrix3x2f(graphics.method_51448());
		var area = ((GuiGraphicsAccessor) graphics).getScissorStack().method_70863();
		return new HorizontalGradientRectangleRenderState(class_10799.field_56879, class_11231.method_70899(), matrix, x0, y0, x1, y1, col1, col2, area, getBounds(x0, y0, x1, y1, matrix, area));
	}

	public void submit() {
		((GameRendererAccessor) class_310.method_1551().field_1773).getGuiRenderState().method_70919(this);
	}

	@Override
	public void method_70917(class_4588 vertexConsumer) {
		vertexConsumer.method_70815(this.pose(), this.x0(), this.y0()).method_39415(this.col1());
		vertexConsumer.method_70815(this.pose(), this.x0(), this.y1()).method_39415(this.col1());
		vertexConsumer.method_70815(this.pose(), this.x1(), this.y1()).method_39415(this.col2());
		vertexConsumer.method_70815(this.pose(), this.x1(), this.y0()).method_39415(this.col2());
	}

	@Nullable
	private static class_8030 getBounds(int i, int j, int k, int l, Matrix3x2f matrix3x2f, @Nullable class_8030 screenRectangle) {
		class_8030 screenRectangle2 = new class_8030(i, j, k - i, l - j).method_71523(matrix3x2f);
		return screenRectangle != null ? screenRectangle.method_49701(screenRectangle2) : screenRectangle2;
	}
}
