/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.util.options.vanilla;

import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.OptionCategoryImpl;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.widgets.BooleanWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.widgets.CategoryWidget;
import io.github.axolotlclient.util.options.ForceableBooleanOption;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class QuickToggleCategoryWidget extends CategoryWidget {
	private BooleanWidget enabledButton;

	public QuickToggleCategoryWidget(int x, int y, int width, int height, OptionCategoryImpl category) {
		super(x, y, width, height, category);
		category.getOptions().stream()
			.filter(o -> o instanceof BooleanOption)
			.map(o -> (BooleanOption) o)
			.filter(o -> "enabled".equals(o.getName())).findFirst()
			.ifPresent(booleanOption -> {
				enabledButton = new BooleanWidget(x + (width - 33), y + 3, 30, height - 5, booleanOption);
				enabledButton.field_22763 = !(booleanOption instanceof ForceableBooleanOption o && o.isForceOff());
			});
	}

	@Override
	public boolean method_25405(double mouseX, double mouseY) {

		if (enabledButton != null && enabledButton.method_25405(mouseX, mouseY)) {
			this.field_22762 = false;
			return true;
		}
		return super.method_25405(mouseX, mouseY);
	}

	@Override
	public void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {
		super.method_48579(graphics, mouseX, mouseY, delta);

		if (enabledButton != null) {
			enabledButton.method_46419(method_46427() + 2);
			enabledButton.update();
			enabledButton.method_25394(graphics, mouseX, mouseY, delta);
		}
	}

	@Override
	protected void method_49604(class_332 graphics, class_327 textRenderer, int i, int j) {
		int k = this.method_46426() + i;
		int l = this.method_46426() + this.method_25368() - i;
		if (enabledButton != null) {
			l -= enabledButton.method_25368() + 4;
		}
		method_52718(graphics, textRenderer, this.method_25369(), k, this.method_46427(), l, this.method_46427() + this.method_25364(), j);
	}

	@Override
	public boolean method_25402(class_11909 event, boolean doubleClick) {

		if (enabledButton != null &&
			enabledButton.method_25367()) {
			method_25354(class_310.method_1551().method_1483());
			enabledButton.method_25306(event);
			return true;
		}
		return this.field_22762 && super.method_25402(event, doubleClick);
	}

	@Override
	public boolean method_25404(class_11908 event) {
		if (!this.field_22763 || !this.field_22764) {
			return false;
		} else if (!event.method_74229()) {
			return false;
		} else {
			this.method_25354(class_310.method_1551().method_1483());
			method_25306(event);
			return true;
		}
	}
}
