/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.api;

import io.github.axolotlclient.api.FriendsScreen;
import io.github.axolotlclient.api.types.PkSystem;
import io.github.axolotlclient.api.types.User;
import io.github.axolotlclient.modules.auth.Auth;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.class_11909;
import net.minecraft.class_11910;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_4280;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7532;

public class UserListWidget
extends class_4280<UserListEntry> {
    private final FriendsScreen screen;

    public UserListWidget(FriendsScreen screen, class_310 client, int width, int height, int top, int bottom, int entryHeight) {
        super(client, width, bottom - top, top, entryHeight);
        this.screen = screen;
    }

    public void setUsers(List<User> users) {
        users.forEach(user -> this.addEntry(new UserListEntry((User)user)));
    }

    public int method_25322() {
        return super.method_25322() + 85;
    }

    public int addEntry(UserListEntry entry) {
        return super.method_25321((class_350.class_351)entry.init(this.screen));
    }

    protected int method_65507() {
        return super.method_65507() + 30;
    }

    public boolean method_25370() {
        return this.screen.method_25399() == this;
    }

    protected boolean method_25351(class_11910 mouseButtonInfo) {
        return true;
    }

    public void method_25339() {
        super.method_25339();
    }

    public static class UserListEntry
    extends class_4280.class_4281<UserListEntry> {
        private final User user;
        private final class_310 client = class_310.method_1551();
        private class_5250 note;
        private FriendsScreen screen;
        private boolean outgoingRequest;

        public UserListEntry(User user, class_5250 note) {
            this(user);
            this.note = note.method_27692(class_124.field_1056);
        }

        public UserListEntry(User user) {
            this.user = user;
        }

        public UserListEntry init(FriendsScreen screen) {
            this.screen = screen;
            return this;
        }

        public UserListEntry outgoing() {
            this.outgoingRequest = true;
            return this;
        }

        public class_2561 method_37006() {
            return class_2561.method_43470((String)this.user.getName());
        }

        public void method_25343(class_332 graphics, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            int x = this.method_73380();
            int y = this.method_73382();
            int entryWidth = this.method_73387();
            int entryHeight = this.method_73384();
            if (this.user.isSystem()) {
                class_5250 fronters = class_2561.method_43470((String)this.user.getSystem().getFronters().stream().map(PkSystem.Member::getDisplayName).collect(Collectors.joining("/")));
                class_5250 tag = class_2561.method_43470((String)("(" + this.user.getSystem().getName() + "/" + this.user.getName() + ")")).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(true)).method_10977(class_124.field_1080));
                graphics.method_27535(this.client.field_1772, (class_2561)fronters.method_10852((class_2561)tag), x + 3, y + 1, -1);
            } else {
                graphics.method_25303(this.client.field_1772, this.user.getName(), x + 3 + 33, y + 1, -1);
            }
            if (this.user.getStatus().isOnline() && this.user.getStatus().getActivity() != null) {
                graphics.method_25303(this.client.field_1772, this.user.getStatus().getTitle(), x + 3 + 33, y + 12, -8355712);
                graphics.method_25303(this.client.field_1772, this.user.getStatus().getDescription(), x + 3 + 40, y + 23, -8355712);
            } else if (this.user.getStatus().getLastOnline() != null) {
                graphics.method_25303(this.client.field_1772, this.user.getStatus().getLastOnline(), x + 3 + 33, y + 12, -8355712);
            }
            if (this.note != null) {
                graphics.method_27535(this.client.field_1772, (class_2561)this.note, x + entryWidth - this.client.field_1772.method_27525((class_5348)this.note) - 4, y + entryHeight - 10, -8355712);
            }
            class_2960 texture = Auth.getInstance().getSkinTexture(this.user.getUuid());
            class_7532.method_44445((class_332)graphics, (class_2960)texture, (int)(x - 1), (int)(y - 1), (int)33, (boolean)true, (boolean)false, (int)-1);
        }

        public boolean method_25402(class_11909 event, boolean doubleClick) {
            this.screen.select(this);
            if (doubleClick && this.client.field_1687 == null) {
                this.screen.openChat();
            }
            return false;
        }

        @Generated
        public User getUser() {
            return this.user;
        }

        @Generated
        public boolean isOutgoingRequest() {
            return this.outgoingRequest;
        }
    }
}

