/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.api.chat;

import io.github.axolotlclient.api.API;
import io.github.axolotlclient.api.ContextMenu;
import io.github.axolotlclient.api.chat.ChatScreen;
import io.github.axolotlclient.api.requests.ChannelRequest;
import io.github.axolotlclient.api.requests.FriendRequest;
import io.github.axolotlclient.api.types.Channel;
import io.github.axolotlclient.api.types.Relation;
import io.github.axolotlclient.api.types.User;
import io.github.axolotlclient.api.util.AlphabeticalComparator;
import io.github.axolotlclient.modules.auth.Auth;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import net.minecraft.class_11909;
import net.minecraft.class_11910;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7532;

public class ChatUserListWidget
extends class_4280<UserListEntry> {
    private final ChatScreen screen;

    public ChatUserListWidget(ChatScreen screen, class_310 client, int width, int height, int top, int bottom, int entryHeight) {
        super(client, width, bottom - top, top, entryHeight);
        this.screen = screen;
    }

    public void setUsers(List<User> users, Channel channel) {
        users.stream().sorted((u1, u2) -> new AlphabeticalComparator().compare(u1.getName(), u2.getName())).forEach(user -> this.addEntry(new UserListEntry((User)user, channel)));
    }

    public int method_25322() {
        return this.field_22758 - 5;
    }

    public int addEntry(UserListEntry entry) {
        return super.method_25321((class_350.class_351)entry.init(this.screen));
    }

    protected int method_65507() {
        return this.method_25342() + this.field_22758 - 8;
    }

    public boolean method_25370() {
        return this.screen.method_25399() == this;
    }

    protected boolean method_25351(class_11910 index) {
        return true;
    }

    public class UserListEntry
    extends class_4280.class_4281<UserListEntry> {
        private final User user;
        private final class_310 client = class_310.method_1551();
        private final Channel channel;
        private ChatScreen screen;

        public UserListEntry(User user, Channel channel) {
            this.user = user;
            this.channel = channel;
        }

        public UserListEntry init(ChatScreen screen) {
            this.screen = screen;
            return this;
        }

        protected static void drawScrollableText(class_332 graphics, class_327 textRenderer, class_2561 text, int left, int top, int right, int bottom, int color) {
            int i = textRenderer.method_27525((class_5348)text);
            int j = (top + bottom - 9) / 2 + 1;
            int k = right - left;
            if (i > k) {
                int l = i - k;
                double d = (double)class_156.method_658() / 1000.0;
                double e = Math.max((double)l * 0.5, 3.0);
                double f = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d / e)) / 2.0 + 0.5;
                double g = class_3532.method_16436((double)f, (double)0.0, (double)l);
                graphics.method_44379(left, top, right, bottom);
                graphics.method_27535(textRenderer, text, left - (int)g, j, color);
                graphics.method_44380();
            } else {
                graphics.method_27535(textRenderer, text, left, j, color);
            }
        }

        public class_2561 method_37006() {
            return class_2561.method_43470((String)this.user.getName());
        }

        public void method_25343(class_332 graphics, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            int x = this.method_73380();
            int y = this.method_73382();
            int entryWidth = this.method_73387();
            int entryHeight = this.method_73384();
            if (hovered && !this.screen.hasContextMenu()) {
                graphics.method_25294(x - 2, y - 1, x + entryWidth - 3, y + entryHeight + 1, 0x55FFFFFF);
            }
            class_327 class_3272 = this.client.field_1772;
            class_5250 class_52502 = class_2561.method_43470((String)this.user.getName());
            Objects.requireNonNull(this.client.field_1772);
            UserListEntry.drawScrollableText(graphics, class_3272, (class_2561)class_52502, x + 3 + entryHeight, y + 1, x + entryWidth - 6, y + 1 + 9 + 2, -1);
            class_327 class_3273 = this.client.field_1772;
            class_5250 class_52503 = class_2561.method_43470((String)this.user.getStatus().getTitle());
            Objects.requireNonNull(this.client.field_1772);
            UserListEntry.drawScrollableText(graphics, class_3273, (class_2561)class_52503, x + 3 + entryHeight, y + 12, x + entryWidth - 6, y + 12 + 9 + 2, 0x808080);
            class_2960 texture = Auth.getInstance().getSkinTexture(this.user.getUuid());
            class_7532.method_44445((class_332)graphics, (class_2960)texture, (int)x, (int)y, (int)entryHeight, (boolean)true, (boolean)false, (int)-1);
        }

        public boolean method_25402(class_11909 event, boolean doubleClick) {
            ChatUserListWidget.this.method_25313((class_350.class_351)this);
            if (event.method_74245() == 1 && !this.user.equals((Object)API.getInstance().getSelf())) {
                ContextMenu.Builder menu = ContextMenu.builder().title((class_2561)class_2561.method_43470((String)this.user.getName())).spacer();
                if (!this.channel.isDM()) {
                    menu.entry((class_2561)class_2561.method_43471((String)"api.friends.chat"), buttonWidget -> ChannelRequest.getOrCreateDM((User)this.user).whenCompleteAsync((channel, throwable) -> this.client.execute(() -> this.client.method_1507((class_437)new ChatScreen(this.screen.getParent(), (Channel)channel))))).spacer();
                }
                if (this.user.getRelation() != Relation.BLOCKED) {
                    if (this.user.getRelation() != Relation.FRIEND) {
                        menu.entry((class_2561)class_2561.method_43471((String)"api.friends.add"), b -> FriendRequest.getInstance().addFriend(this.user.getUuid())).spacer();
                    }
                    menu.entry((class_2561)class_2561.method_43471((String)"api.users.block"), buttonWidget -> FriendRequest.getInstance().blockUser(this.user));
                } else {
                    menu.entry((class_2561)class_2561.method_43471((String)"api.users.unblock"), buttonWidget -> FriendRequest.getInstance().unblockUser(this.user));
                }
                if (this.channel.getOwner().equals((Object)API.getInstance().getSelf())) {
                    menu.spacer().entry((class_2561)class_2561.method_43471((String)"api.channel.remove_user"), b -> ChannelRequest.removeUserFromChannel((Channel)this.channel, (User)this.user));
                }
                this.screen.setContextMenu(menu.build());
                return true;
            }
            return false;
        }

        @Generated
        public User getUser() {
            return this.user;
        }
    }
}

