/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.api.multiplayer;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.logging.LogUtils;
import io.github.axolotlclient.api.multiplayer.FriendsMultiplayerScreen;
import io.github.axolotlclient.api.multiplayer.ServerInfoUtil;
import io.github.axolotlclient.api.types.PkSystem;
import io.github.axolotlclient.api.types.Status;
import io.github.axolotlclient.api.types.User;
import io.github.axolotlclient.modules.auth.Auth;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import lombok.Generated;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1060;
import net.minecraft.class_10799;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_140;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_4280;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_642;
import net.minecraft.class_7413;
import net.minecraft.class_7532;
import net.minecraft.class_8573;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class FriendsMultiplayerSelectionList
extends class_4280<Entry> {
    static final class_2960 INCOMPATIBLE_SPRITE = class_2960.method_60656((String)"server_list/incompatible");
    static final class_2960 UNREACHABLE_SPRITE = class_2960.method_60656((String)"server_list/unreachable");
    static final class_2960 PING_1_SPRITE = class_2960.method_60656((String)"server_list/ping_1");
    static final class_2960 PING_2_SPRITE = class_2960.method_60656((String)"server_list/ping_2");
    static final class_2960 PING_3_SPRITE = class_2960.method_60656((String)"server_list/ping_3");
    static final class_2960 PING_4_SPRITE = class_2960.method_60656((String)"server_list/ping_4");
    static final class_2960 PING_5_SPRITE = class_2960.method_60656((String)"server_list/ping_5");
    static final class_2960 PINGING_1_SPRITE = class_2960.method_60656((String)"server_list/pinging_1");
    static final class_2960 PINGING_2_SPRITE = class_2960.method_60656((String)"server_list/pinging_2");
    static final class_2960 PINGING_3_SPRITE = class_2960.method_60656((String)"server_list/pinging_3");
    static final class_2960 PINGING_4_SPRITE = class_2960.method_60656((String)"server_list/pinging_4");
    static final class_2960 PINGING_5_SPRITE = class_2960.method_60656((String)"server_list/pinging_5");
    static final class_2960 JOIN_HIGHLIGHTED_SPRITE = class_2960.method_60656((String)"server_list/join_highlighted");
    static final class_2960 JOIN_SPRITE = class_2960.method_60656((String)"server_list/join");
    static final Logger LOGGER = LogUtils.getLogger();
    static final ThreadPoolExecutor THREAD_POOL = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("Friends Server Pinger #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new class_140(LOGGER)).build());
    static final class_2561 CANT_RESOLVE_TEXT = class_2561.method_43471((String)"multiplayer.status.cannot_resolve").method_54663(-65536);
    static final class_2561 CANT_CONNECT_TEXT = class_2561.method_43471((String)"multiplayer.status.cannot_connect").method_54663(-65536);
    static final class_2561 INCOMPATIBLE_STATUS = class_2561.method_43471((String)"multiplayer.status.incompatible");
    static final class_2561 NO_CONNECTION_STATUS = class_2561.method_43471((String)"multiplayer.status.no_connection");
    static final class_2561 PINGING_STATUS = class_2561.method_43471((String)"multiplayer.status.pinging");
    static final class_2561 ONLINE_STATUS = class_2561.method_43471((String)"multiplayer.status.online");
    static final class_2561 NOT_PUBLISHED_STATUS = class_2561.method_43471((String)"api.worldhost.joinability.not_published");
    private final FriendsMultiplayerScreen screen;
    private final List<Entry> friendEntries = new ArrayList<Entry>();
    private final LoadingHeader loadingHeader = new LoadingHeader();

    public FriendsMultiplayerSelectionList(FriendsMultiplayerScreen screen, class_310 minecraft, int width, int height, int y, int itemHeight) {
        super(minecraft, width, height, y, itemHeight);
        this.screen = screen;
        this.method_25321((class_350.class_351)this.loadingHeader);
    }

    private void refreshEntries() {
        this.method_25339();
        this.friendEntries.forEach(x$0 -> this.method_25321((class_350.class_351)x$0));
    }

    public void setSelected(@Nullable Entry entry) {
        super.method_25313((class_350.class_351)entry);
        this.screen.onSelectedChange();
    }

    public boolean method_25404(class_11908 event) {
        Entry entry = (Entry)this.method_25334();
        return entry != null && entry.method_25404(event) || super.method_25404(event);
    }

    public void updateList(List<User> friends) {
        this.friendEntries.clear();
        for (User friend : friends) {
            if (!friend.getStatus().isOnline()) continue;
            this.friendEntries.add(this.createEntry(friend));
        }
        this.refreshEntries();
    }

    private Entry createEntry(User friend) {
        if (friend.getStatus().getActivity() != null && friend.getStatus().getActivity().hasMetadata()) {
            if (friend.getStatus().getActivity().hasMetadata("external_server")) {
                return this.externalServerEntry(this.screen, friend);
            }
            return this.e4mcServerFriendEntry(this.screen, friend);
        }
        return new StatusFriendEntry(friend);
    }

    public void updateEntry(User user) {
        this.friendEntries.stream().filter(e1 -> {
            if (e1 instanceof StatusFriendEntry) {
                StatusFriendEntry statusFriendEntry = (StatusFriendEntry)e1;
                return statusFriendEntry.getUser().equals((Object)user);
            }
            if (e1 instanceof ServerEntry) {
                ServerEntry serverEntry = (ServerEntry)e1;
                return serverEntry.getUser().equals((Object)user);
            }
            return false;
        }).findFirst().ifPresent(e -> {
            this.friendEntries.set(this.friendEntries.indexOf(e), this.createEntry(user));
            this.refreshEntries();
        });
    }

    public int method_25322() {
        return 305;
    }

    private ExternalServerFriendEntry externalServerEntry(FriendsMultiplayerScreen screen, User friend) {
        Status.Activity.ExternalServerMetadata metadata = (Status.Activity.ExternalServerMetadata)friend.getStatus().getActivity().metadata().attributes();
        return new ExternalServerFriendEntry(this, screen, metadata, new class_642(metadata.serverName(), metadata.address(), class_642.class_8678.field_45611), friend);
    }

    private E4mcServerFriendEntry e4mcServerFriendEntry(FriendsMultiplayerScreen screen, User friend) {
        Status.Activity activity = friend.getStatus().getActivity();
        Status.Activity.E4mcMetadata metadata = activity.hasMetadata("world_host") ? ((Status.Activity.WorldHostMetadata)activity.metadata().attributes()).asE4mcMetadata() : (Status.Activity.E4mcMetadata)activity.metadata().attributes();
        return new E4mcServerFriendEntry(this, screen, metadata, ServerInfoUtil.getServerData(friend.getName(), metadata), friend);
    }

    @Environment(value=EnvType.CLIENT)
    public static class LoadingHeader
    extends Entry {
        private final class_310 minecraft = class_310.method_1551();

        public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovering, float partialTick) {
            int i = this.method_73385() - 4;
            String string = class_7413.method_43449((long)class_156.method_658());
            guiGraphics.method_25303(this.minecraft.field_1772, string, this.minecraft.field_1755.field_22789 / 2 - this.minecraft.field_1772.method_1727(string) / 2, i, -8355712);
        }

        @NotNull
        public class_2561 method_37006() {
            return class_2561.method_43473();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static abstract class Entry
    extends class_4280.class_4281<Entry>
    implements AutoCloseable {
        @Override
        public void close() {
        }

        public boolean canJoin() {
            return false;
        }

        public class_642 getServerData() {
            return null;
        }
    }

    public class ExternalServerFriendEntry
    extends ServerEntry {
        private final Status.Activity.ExternalServerMetadata statusDescription;

        private ExternalServerFriendEntry(FriendsMultiplayerSelectionList this$0, FriendsMultiplayerScreen screen, Status.Activity.ExternalServerMetadata statusDescription, class_642 serverData, User friend) {
            super(screen, serverData, friend);
            this.statusDescription = statusDescription;
            this.refreshStatus();
        }

        @Override
        public boolean canJoin() {
            return this.statusDescription.address() != null;
        }
    }

    public class E4mcServerFriendEntry
    extends ServerEntry {
        private final Status.Activity.E4mcMetadata statusDescription;

        protected E4mcServerFriendEntry(FriendsMultiplayerSelectionList this$0, FriendsMultiplayerScreen screen, Status.Activity.E4mcMetadata statusDescription, class_642 serverData, User friend) {
            super(screen, serverData, friend);
            this.statusDescription = statusDescription;
            this.refreshStatus();
        }

        @Override
        protected void refreshStatus() {
            super.refreshStatus();
            this.serverData.field_3757 = class_2561.method_30163((String)this.statusDescription.serverInfo().levelName());
        }

        @Override
        protected boolean isPublished() {
            return this.statusDescription.domain() != null;
        }
    }

    public class StatusFriendEntry
    extends Entry {
        protected final User user;

        protected StatusFriendEntry(User friend) {
            this.user = friend;
        }

        public class_2561 method_37006() {
            return class_2561.method_43470((String)this.user.getName());
        }

        public void method_25343(class_332 graphics, int mouseX, int mouseY, boolean hovering, float partialTick) {
            if (this.user.isSystem()) {
                class_5250 fronters = class_2561.method_43470((String)this.user.getSystem().getFronters().stream().map(PkSystem.Member::getDisplayName).collect(Collectors.joining("/")));
                class_5250 tag = class_2561.method_43470((String)("(" + this.user.getSystem().getName() + "/" + this.user.getName() + ")")).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(true)).method_10977(class_124.field_1080));
                graphics.method_27535(((FriendsMultiplayerSelectionList)FriendsMultiplayerSelectionList.this).field_22740.field_1772, (class_2561)fronters.method_10852((class_2561)tag), this.method_73380() + 3, this.method_73382() + 1, -1);
            } else {
                graphics.method_25303(((FriendsMultiplayerSelectionList)FriendsMultiplayerSelectionList.this).field_22740.field_1772, this.user.getName(), this.method_73380() + 3 + 32, this.method_73382() + 1, -1);
            }
            if (this.user.getStatus().isOnline() && this.user.getStatus().getActivity() != null) {
                graphics.method_25303(((FriendsMultiplayerSelectionList)FriendsMultiplayerSelectionList.this).field_22740.field_1772, this.user.getStatus().getTitle(), this.method_73380() + 3 + 32, this.method_73382() + 12, -8355712);
                graphics.method_25303(((FriendsMultiplayerSelectionList)FriendsMultiplayerSelectionList.this).field_22740.field_1772, this.user.getStatus().getDescription(), this.method_73380() + 3 + 40, this.method_73382() + 23, -8355712);
            } else if (this.user.getStatus().getLastOnline() != null) {
                graphics.method_25303(((FriendsMultiplayerSelectionList)FriendsMultiplayerSelectionList.this).field_22740.field_1772, this.user.getStatus().getLastOnline(), this.method_73380() + 3 + 32, this.method_73382() + 12, -8355712);
            }
            class_2960 texture = Auth.getInstance().getSkinTexture(this.user);
            class_7532.method_44445((class_332)graphics, (class_2960)texture, (int)this.method_73380(), (int)this.method_73382(), (int)32, (boolean)true, (boolean)false, (int)-1);
        }

        @Generated
        public User getUser() {
            return this.user;
        }
    }

    protected class ServerEntry
    extends Entry {
        private static final int ICON_WIDTH = 32;
        private static final int ICON_HEIGHT = 32;
        private static final int SPACING = 5;
        private static final int STATUS_ICON_WIDTH = 10;
        private static final int STATUS_ICON_HEIGHT = 8;
        private final FriendsMultiplayerScreen screen;
        private final class_310 minecraft;
        protected final class_642 serverData;
        private final class_8573 icon;
        private byte @Nullable [] lastIconBytes;
        @Nullable
        private List<class_2561> onlinePlayersTooltip;
        @Nullable
        private class_2960 statusIcon;
        @Nullable
        private class_2561 statusIconTooltip;
        protected final User user;

        protected ServerEntry(FriendsMultiplayerScreen screen, class_642 serverData, User user) {
            this.screen = screen;
            this.minecraft = class_310.method_1551();
            this.serverData = serverData;
            this.icon = class_8573.method_52202((class_1060)this.minecraft.method_1531(), (String)(serverData.field_3761 != null ? serverData.field_3761 : user.getUuid() + "_" + serverData.field_3752));
            this.user = user;
        }

        protected void refreshStatus() {
            this.onlinePlayersTooltip = null;
            if (!this.isPublished()) {
                this.serverData.method_55824(class_642.class_9083.field_47882);
            }
            switch (this.serverData.method_55825()) {
                case field_47880: 
                case field_47881: {
                    this.statusIcon = PING_1_SPRITE;
                    this.statusIconTooltip = PINGING_STATUS;
                    break;
                }
                case field_47883: {
                    this.statusIcon = INCOMPATIBLE_SPRITE;
                    this.onlinePlayersTooltip = this.serverData.field_3762;
                    this.statusIconTooltip = INCOMPATIBLE_STATUS;
                    break;
                }
                case field_47882: {
                    this.statusIcon = UNREACHABLE_SPRITE;
                    if (!this.isPublished()) break;
                    this.statusIconTooltip = NO_CONNECTION_STATUS;
                    break;
                }
                case field_47884: {
                    this.statusIcon = this.serverData.field_3758 < 150L ? PING_5_SPRITE : (this.serverData.field_3758 < 300L ? PING_4_SPRITE : (this.serverData.field_3758 < 600L ? PING_3_SPRITE : (this.serverData.field_3758 < 1000L ? PING_2_SPRITE : PING_1_SPRITE)));
                    this.statusIconTooltip = class_2561.method_43469((String)"multiplayer.status.ping", (Object[])new Object[]{this.serverData.field_3758});
                    this.onlinePlayersTooltip = this.serverData.field_3762;
                }
            }
        }

        public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovering, float partialTick) {
            byte[] bs;
            int i;
            if (this.serverData.method_55825() == class_642.class_9083.field_47880) {
                this.serverData.method_55824(class_642.class_9083.field_47881);
                this.serverData.field_3757 = class_5244.field_39003;
                this.serverData.field_3753 = class_5244.field_39003;
                THREAD_POOL.submit(() -> {
                    try {
                        this.screen.getPinger().method_3003(this.serverData, () -> {}, () -> {
                            this.serverData.method_55824(this.serverData.field_3756 == class_155.method_16673().comp_4027() ? class_642.class_9083.field_47884 : class_642.class_9083.field_47883);
                            this.minecraft.execute(this::refreshStatus);
                        });
                    }
                    catch (UnknownHostException var2) {
                        this.serverData.method_55824(class_642.class_9083.field_47882);
                        this.serverData.field_3757 = CANT_RESOLVE_TEXT;
                        this.minecraft.execute(this::refreshStatus);
                    }
                    catch (Exception var3) {
                        this.serverData.method_55824(class_642.class_9083.field_47882);
                        this.serverData.field_3757 = CANT_CONNECT_TEXT;
                        this.minecraft.execute(this::refreshStatus);
                    }
                });
            }
            guiGraphics.method_25303(this.minecraft.field_1772, this.serverData.field_3752, this.method_73380() + 32 + 3, this.method_73382() + 1, -1);
            List list = this.minecraft.field_1772.method_1728((class_5348)this.serverData.field_3757, FriendsMultiplayerSelectionList.this.field_22758 - 32 - 2);
            for (int i2 = 0; i2 < Math.min(list.size(), 2); ++i2) {
                guiGraphics.method_35720(this.minecraft.field_1772, (class_5481)list.get(i2), this.method_73380() + 32 + 3, this.method_73382() + 12 + 9 * i2, -8355712);
            }
            guiGraphics.method_25290(class_10799.field_56883, this.icon.method_52201(), this.method_73380(), this.method_73382(), 0.0f, 0.0f, 32, 32, 32, 32);
            class_2960 texture = Auth.getInstance().getSkinTexture(this.user);
            class_7532.method_44445((class_332)guiGraphics, (class_2960)texture, (int)(this.method_73380() + 32 - 10), (int)(this.method_73382() + 32 - 10), (int)10, (boolean)true, (boolean)false, (int)-1);
            if (this.serverData.method_55825() == class_642.class_9083.field_47881) {
                i = (int)(class_156.method_658() / 100L + (long)(FriendsMultiplayerSelectionList.this.method_25396().indexOf(this) * 2) & 7L);
                if (i > 4) {
                    i = 8 - i;
                }
                this.statusIcon = switch (i) {
                    case 1 -> PINGING_2_SPRITE;
                    case 2 -> PINGING_3_SPRITE;
                    case 3 -> PINGING_4_SPRITE;
                    case 4 -> PINGING_5_SPRITE;
                    default -> PINGING_1_SPRITE;
                };
            }
            i = this.method_73380() + FriendsMultiplayerSelectionList.this.field_22758 - 10 - 5;
            if (this.statusIcon != null) {
                guiGraphics.method_52706(class_10799.field_56883, this.statusIcon, i, this.method_73382(), 10, 8);
            }
            if (!Arrays.equals(bs = this.serverData.method_49306(), this.lastIconBytes)) {
                if (this.uploadIcon(bs)) {
                    this.lastIconBytes = bs;
                } else {
                    this.serverData.method_49305(null);
                }
            }
            Object component = !this.isPublished() ? NOT_PUBLISHED_STATUS : (this.serverData.method_55825() == class_642.class_9083.field_47883 ? this.serverData.field_3760.method_27661().method_27692(class_124.field_1061) : this.serverData.field_3753);
            int j = this.minecraft.field_1772.method_27525((class_5348)component);
            int k = i - j - 5;
            guiGraphics.method_27535(this.minecraft.field_1772, component, k, this.method_73382() + 1, -8355712);
            if (this.statusIconTooltip != null && mouseX >= i && mouseX <= i + 10 && mouseY >= this.method_73382() && mouseY <= this.method_73382() + 8) {
                guiGraphics.method_71276(this.statusIconTooltip, mouseX, mouseY);
            } else if (this.onlinePlayersTooltip != null && mouseX >= k && mouseX <= k + j && mouseY >= this.method_73382() && mouseY <= this.method_73382() - 1 + 9) {
                guiGraphics.method_71274(Lists.transform(this.onlinePlayersTooltip, class_2561::method_30937), mouseX, mouseY);
            }
            if (((Boolean)this.minecraft.field_1690.method_42446().method_41753()).booleanValue() || hovering) {
                int l = mouseX - this.method_73380();
                if (this.canJoin()) {
                    guiGraphics.method_25294(this.method_73380(), this.method_73382(), this.method_73380() + 32, this.method_73382() + 32, -1601138544);
                    if (l < 32 && l > 16) {
                        guiGraphics.method_52706(class_10799.field_56883, JOIN_HIGHLIGHTED_SPRITE, this.method_73380(), this.method_73382(), 32, 32);
                    } else {
                        guiGraphics.method_52706(class_10799.field_56883, JOIN_SPRITE, this.method_73380(), this.method_73382(), 32, 32);
                    }
                }
            }
        }

        protected boolean isPublished() {
            return true;
        }

        @Override
        public boolean canJoin() {
            return this.serverData.method_55825() == class_642.class_9083.field_47884 && this.isPublished();
        }

        private boolean uploadIcon(byte @Nullable [] iconBytes) {
            if (iconBytes == null) {
                this.icon.method_52198();
            } else {
                try {
                    this.icon.method_52199(class_1011.method_49277((byte[])iconBytes));
                }
                catch (Throwable var3) {
                    LOGGER.error("Invalid icon for server {} ({})", new Object[]{this.serverData.field_3752, this.serverData.field_3761, var3});
                    return false;
                }
            }
            return true;
        }

        public boolean method_25402(class_11909 event, boolean doubleClick) {
            double d = event.comp_4798() - (double)FriendsMultiplayerSelectionList.this.method_25342();
            if (d <= 32.0 && d < 32.0 && d > 16.0 && this.canJoin()) {
                this.screen.setSelected(this);
                this.screen.joinSelectedServer();
                return true;
            }
            this.screen.setSelected(this);
            if (doubleClick && this.canJoin()) {
                this.screen.joinSelectedServer();
            }
            return super.method_25402(event, doubleClick);
        }

        @NotNull
        public class_2561 method_37006() {
            class_5250 mutableComponent = class_2561.method_43473();
            mutableComponent.method_10852((class_2561)class_2561.method_43469((String)"narrator.select", (Object[])new Object[]{this.serverData.field_3752}));
            mutableComponent.method_10852(class_5244.field_33850);
            switch (this.serverData.method_55825()) {
                case field_47881: {
                    mutableComponent.method_10852(PINGING_STATUS);
                    break;
                }
                case field_47883: {
                    mutableComponent.method_10852(INCOMPATIBLE_STATUS);
                    mutableComponent.method_10852(class_5244.field_33850);
                    mutableComponent.method_10852((class_2561)class_2561.method_43469((String)"multiplayer.status.version.narration", (Object[])new Object[]{this.serverData.field_3760}));
                    mutableComponent.method_10852(class_5244.field_33850);
                    mutableComponent.method_10852((class_2561)class_2561.method_43469((String)"multiplayer.status.motd.narration", (Object[])new Object[]{this.serverData.field_3757}));
                    break;
                }
                case field_47882: {
                    mutableComponent.method_10852(NO_CONNECTION_STATUS);
                    break;
                }
                default: {
                    mutableComponent.method_10852(ONLINE_STATUS);
                    mutableComponent.method_10852(class_5244.field_33850);
                    mutableComponent.method_10852((class_2561)class_2561.method_43469((String)"multiplayer.status.ping.narration", (Object[])new Object[]{this.serverData.field_3758}));
                    mutableComponent.method_10852(class_5244.field_33850);
                    mutableComponent.method_10852((class_2561)class_2561.method_43469((String)"multiplayer.status.motd.narration", (Object[])new Object[]{this.serverData.field_3757}));
                    if (this.serverData.field_41861 == null) break;
                    mutableComponent.method_10852(class_5244.field_33850);
                    mutableComponent.method_10852((class_2561)class_2561.method_43469((String)"multiplayer.status.player_count.narration", (Object[])new Object[]{this.serverData.field_41861.comp_1280(), this.serverData.field_41861.comp_1279()}));
                    mutableComponent.method_10852(class_5244.field_33850);
                    mutableComponent.method_10852(class_2564.method_37112((Collection)this.serverData.field_3762, (class_2561)class_2561.method_43470((String)", ")));
                }
            }
            return mutableComponent;
        }

        @Override
        public void close() {
            this.icon.close();
        }

        @Override
        @Generated
        public class_642 getServerData() {
            return this.serverData;
        }

        @Generated
        public User getUser() {
            return this.user;
        }
    }
}

