/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.auth.skin;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import io.github.axolotlclient.AxolotlClientCommon;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Colors;
import io.github.axolotlclient.api.SimpleTextInputScreen;
import io.github.axolotlclient.api.util.UUIDHelper;
import io.github.axolotlclient.mixin.GameRendererAccessor;
import io.github.axolotlclient.mixin.GuiGraphicsAccessor;
import io.github.axolotlclient.modules.auth.Account;
import io.github.axolotlclient.modules.auth.Auth;
import io.github.axolotlclient.modules.auth.MSApi;
import io.github.axolotlclient.modules.auth.skin.Asset;
import io.github.axolotlclient.modules.auth.skin.Cape;
import io.github.axolotlclient.modules.auth.skin.LoadingScreen;
import io.github.axolotlclient.modules.auth.skin.Skin;
import io.github.axolotlclient.modules.auth.skin.SkinImportUtil;
import io.github.axolotlclient.modules.auth.skin.SkinRenderer;
import io.github.axolotlclient.modules.auth.skin.SkinWidget;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import io.github.axolotlclient.util.ClientColors;
import io.github.axolotlclient.util.Watcher;
import io.github.axolotlclient.util.notifications.Notifications;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_4588;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_7842;
import net.minecraft.class_7919;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import net.minecraft.class_8030;
import net.minecraft.class_8130;
import net.minecraft.class_8661;
import net.minecraft.class_8662;
import net.minecraft.class_9017;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

public class SkinManagementScreen
extends class_437 {
    private static final Path SKINS_DIR = FabricLoader.getInstance().getGameDir().resolve("skins");
    private static final int LIST_SKIN_WIDTH = 75;
    private static final int LIST_SKIN_HEIGHT = 110;
    private static final class_2561 TEXT_EQUIPPING = class_2561.method_43471((String)"skins.manage.equipping");
    private final class_437 parent;
    private final Account account;
    private MSApi.MCProfile cachedProfile;
    private SkinListWidget skinList;
    private SkinListWidget capesList;
    private boolean capesTab;
    private SkinWidget current;
    private final Watcher skinDirWatcher;
    private final CompletableFuture<MSApi.MCProfile> loadingFuture;

    public SkinManagementScreen(class_437 parent, Account account) {
        super((class_2561)class_2561.method_43471((String)"skins.manage"));
        this.parent = parent;
        this.account = account;
        this.skinDirWatcher = Watcher.createSelfTicking((Path)SKINS_DIR, () -> {
            AxolotlClientCommon.getInstance().getLogger().info("Reloading screen as local files changed!", new Object[0]);
            this.loadSkinsList();
        });
        this.loadingFuture = (account.needsRefresh() ? account.refresh(Auth.getInstance().getMsApi()) : CompletableFuture.completedFuture(null)).thenComposeAsync(unused -> Auth.getInstance().getMsApi().getProfile(account));
    }

    protected void method_25426() {
        int headerHeight = 33;
        int contentHeight = this.field_22790 - headerHeight * 2;
        int n = this.field_22789 / 2 - this.field_22793.method_27525((class_5348)this.method_25440()) / 2;
        int n2 = headerHeight / 2;
        Objects.requireNonNull(this.field_22793);
        int n3 = n2 - 9 / 2;
        int n4 = this.field_22793.method_27525((class_5348)this.method_25440());
        Objects.requireNonNull(this.field_22793);
        class_7842 titleWidget = new class_7842(n, n3, n4, 9, this.method_25440(), this.method_64506());
        this.method_37063((class_364)titleWidget);
        class_4185 back = class_4185.method_46430((class_2561)class_5244.field_24339, btn -> this.method_25419()).method_46434(this.field_22789 / 2 - 75, this.field_22790 - headerHeight / 2 - 10, 150, 20).method_46431();
        class_8661 loadingPlaceholder = new class_8661(this.method_64506(), (class_2561)class_2561.method_43471((String)"skins.loading"));
        loadingPlaceholder.method_55444(this.field_22789, contentHeight, 0, headerHeight);
        this.method_37063((class_364)loadingPlaceholder);
        this.method_37063((class_364)back);
        this.skinList = new SkinListWidget(this.field_22787, this.field_22789 / 2, contentHeight - 24, headerHeight + 24, 144);
        this.capesList = new SkinListWidget(this.field_22787, this.field_22789 / 2, contentHeight - 24, headerHeight + 24, this.skinList.getEntryContentsHeight() + 24);
        this.skinList.method_46421(this.field_22789 / 2);
        this.capesList.method_46421(this.field_22789 / 2);
        float currentHeight = Math.min((float)this.field_22789 / 2.0f * 120.0f / 85.0f, (float)contentHeight);
        float currentWidth = currentHeight * 85.0f / 120.0f;
        this.current = new SkinWidget((int)currentWidth, (int)currentHeight, null, this.account);
        this.current.method_48229((int)((float)this.field_22789 / 4.0f - currentWidth / 2.0f), (int)((float)this.field_22790 / 2.0f - currentHeight / 2.0f));
        if (!this.capesTab) {
            this.capesList.field_22763 = false;
            this.capesList.field_22764 = false;
        } else {
            this.skinList.field_22763 = false;
            this.skinList.field_22764 = false;
        }
        ArrayList<class_4185> navBar = new ArrayList<class_4185>();
        class_4185 skinsTab = class_4185.method_46430((class_2561)class_2561.method_43471((String)"skins.nav.skins"), btn -> {
            navBar.forEach(w -> {
                if (w != btn) {
                    w.field_22763 = true;
                }
            });
            btn.field_22763 = false;
            this.skinList.field_22763 = true;
            this.skinList.field_22764 = true;
            this.capesList.field_22763 = false;
            this.capesList.field_22764 = false;
            this.capesTab = false;
        }).method_46433(Math.max(this.field_22789 * 3 / 4 - 102, this.field_22789 / 2 + 2), headerHeight).method_46432(Math.min(100, this.field_22789 / 4 - 2)).method_46431();
        navBar.add(skinsTab);
        class_4185 capesTab = class_4185.method_46430((class_2561)class_2561.method_43471((String)"skins.nav.capes"), btn -> {
            navBar.forEach(w -> {
                if (w != btn) {
                    w.field_22763 = true;
                }
            });
            btn.field_22763 = false;
            this.skinList.field_22763 = false;
            this.skinList.field_22764 = false;
            this.capesList.field_22763 = true;
            this.capesList.field_22764 = true;
            this.capesTab = true;
        }).method_46433(this.field_22789 * 3 / 4 + 2, headerHeight).method_46432(Math.min(100, this.field_22789 / 4 - 2)).method_46431();
        navBar.add(capesTab);
        class_8662 importButton = class_8662.method_52723((class_2561)class_2561.method_43471((String)"skins.manage.import.local"), btn -> {
            btn.field_22763 = false;
            ((CompletableFuture)SkinImportUtil.openImportSkinDialog().thenAccept(this::method_29638)).thenRun(() -> {
                btn.field_22763 = true;
            });
        }, (boolean)true).method_52727(class_2960.method_60655((String)"axolotlclient", (String)"folder"), 7, 7).method_52726(11, 11).method_52724();
        importButton.method_47400(class_7919.method_47407((class_2561)importButton.method_25369()));
        class_8662 downloadButton = class_8662.method_52723((class_2561)class_2561.method_43471((String)"skins.manage.import.online"), btn -> {
            btn.field_22763 = false;
            this.promptForSkinDownload();
        }, (boolean)true).method_52727(class_2960.method_60655((String)"axolotlclient", (String)"download"), 7, 7).method_52726(11, 11).method_52724();
        downloadButton.method_47400(class_7919.method_47407((class_2561)downloadButton.method_25369()));
        if (this.field_22789 - (capesTab.method_46426() + capesTab.method_25368()) > 28) {
            importButton.method_46421(this.field_22789 - importButton.method_25368() - 2);
            downloadButton.method_46421(importButton.method_46426() - downloadButton.method_25368() - 2);
            importButton.method_46419(capesTab.method_46427() + capesTab.method_25364() - 11);
            downloadButton.method_46419(importButton.method_46427());
        } else {
            importButton.method_46421(capesTab.method_46426() + capesTab.method_25368() - 11);
            importButton.method_46419(capesTab.method_46427() - 13);
            downloadButton.method_46421(importButton.method_46426() - 2 - 11);
            downloadButton.method_46419(importButton.method_46427());
        }
        skinsTab.field_22763 = this.capesTab;
        capesTab.field_22763 = !this.capesTab;
        Runnable addWidgets = () -> {
            this.method_37067();
            this.method_37063((class_364)titleWidget);
            this.method_37063((class_364)this.current);
            this.method_37063((class_364)skinsTab);
            this.method_37063((class_364)capesTab);
            this.method_37063((class_364)downloadButton);
            this.method_37063((class_364)importButton);
            this.method_37063((class_364)this.skinList);
            this.method_37063((class_364)this.capesList);
            this.method_37063((class_364)back);
        };
        if (this.cachedProfile != null) {
            this.initDisplay();
            addWidgets.run();
            return;
        }
        ((CompletableFuture)this.loadingFuture.thenAcceptAsync(profile -> {
            this.cachedProfile = profile;
            this.initDisplay();
            addWidgets.run();
        })).exceptionally(t -> {
            if (t.getCause() instanceof CancellationException) {
                this.field_22787.method_1507(this.parent);
                return null;
            }
            AxolotlClientCommon.getInstance().getLogger().error("Failed to load skins!", new Object[]{t});
            class_5250 error = class_2561.method_43471((String)"skins.error.failed_to_load");
            class_5250 errorDesc = class_2561.method_43471((String)"skins.error.failed_to_load_desc");
            this.method_37067();
            this.method_37063((class_364)titleWidget);
            int n = this.field_22789 / 2 - this.method_64506().method_27525((class_5348)error) / 2;
            int n2 = this.field_22790 / 2;
            Objects.requireNonNull(this.method_64506());
            int n3 = n2 - 9 - 2;
            int n4 = this.method_64506().method_27525((class_5348)error);
            Objects.requireNonNull(this.method_64506());
            this.method_37063((class_364)new class_7842(n, n3, n4, 9, (class_2561)error, this.method_64506()));
            int n5 = this.field_22789 / 2 - this.method_64506().method_27525((class_5348)errorDesc) / 2;
            int n6 = this.field_22790 / 2 + 1;
            int n7 = this.method_64506().method_27525((class_5348)errorDesc);
            Objects.requireNonNull(this.method_64506());
            this.method_37063((class_364)new class_7842(n5, n6, n7, 9, (class_2561)errorDesc, this.method_64506()));
            this.method_37063((class_364)back);
            return null;
        });
    }

    private void promptForSkinDownload() {
        this.field_22787.method_1507((class_437)new SimpleTextInputScreen(this, (class_2561)class_2561.method_43471((String)"skins.manage.import.online"), (class_2561)class_2561.method_43471((String)"skins.manage.import.online.input"), s -> UUIDHelper.ensureUuidOpt((String)s).thenAcceptAsync(o -> {
            if (o.isPresent()) {
                AxolotlClientCommon.getInstance().getLogger().info("Downloading skin of {} ({})", new Object[]{s, o.get()});
                ((CompletableFuture)Auth.getInstance().getMsApi().getTextures((String)o.get()).exceptionally(th -> {
                    AxolotlClientCommon.getInstance().getLogger().info("Failed to download skin of {} ({})", new Object[]{s, o.get(), th});
                    return null;
                })).thenAcceptAsync(t -> {
                    if (t == null) {
                        Notifications.getInstance().addStatus("skins.notification.title", "skins.notification.import.online.failed_to_download", s);
                        return;
                    }
                    try {
                        byte[] bytes = (byte[])t.skin().join();
                        Path out = this.ensureNonexistent(SKINS_DIR.resolve(t.skinKey()));
                        Skin.LocalSkin.writeMetadata((Path)out, Map.of("variant_classic", t.classicModel(), "name", t.name(), "uuid", t.id(), "download_time", Instant.now()));
                        Files.write(out, bytes, new OpenOption[0]);
                        this.field_22787.execute(this::loadSkinsList);
                        Notifications.getInstance().addStatus("skins.notification.title", "skins.notification.import.online.downloaded", t.name());
                        AxolotlClientCommon.getInstance().getLogger().info("Downloaded skin of {} ({})", new Object[]{t.name(), o.get()});
                    }
                    catch (IOException e) {
                        AxolotlClientCommon.getInstance().getLogger().warn("Failed to write skin file", new Object[]{e});
                        Notifications.getInstance().addStatus("skins.notification.title", "skins.notification.import.online.failed_to_save", t.name());
                    }
                });
            } else {
                Notifications.getInstance().addStatus("skins.notification.title", "skins.notification.import.online.not_found", s);
            }
        })));
    }

    private void initDisplay() {
        this.loadSkinsList();
        this.loadCapesList();
    }

    private void refreshCurrentList() {
        if (this.capesTab) {
            double scroll = this.capesList.method_44387();
            this.loadCapesList();
            this.capesList.method_44382(scroll);
        } else {
            double scroll = this.skinList.method_44387();
            this.loadSkinsList();
            this.skinList.method_44382(scroll);
        }
    }

    private void loadCapesList() {
        ArrayList<Row> rows = new ArrayList<Row>();
        MSApi.MCProfile profile = this.cachedProfile;
        int columns = Math.max(2, (this.field_22789 / 2 - 25) / 75);
        List capes = profile.capes();
        SkinWidget deselectCape = this.createWidgetForCape(this.current.getSkin(), null);
        Optional<MSApi.MCProfile.OnlineCape> activeCape = capes.stream().filter(Asset::active).findFirst();
        this.current.setCape(activeCape.orElse(null));
        deselectCape.noCape(activeCape.isEmpty());
        for (int i = 0; i < capes.size() + 1; i += columns) {
            Entry widget;
            if (i == 0) {
                widget = this.createEntry(this.capesList.getEntryContentsHeight(), deselectCape, (class_2561)class_2561.method_43471((String)"skins.capes.no_cape"));
            } else {
                MSApi.MCProfile.OnlineCape cape = (MSApi.MCProfile.OnlineCape)capes.get(i - 1);
                widget = this.createEntryForCape(this.current.getSkin(), (Cape)cape, this.capesList.getEntryContentsHeight());
            }
            ArrayList<class_339> widgets = new ArrayList<class_339>();
            widgets.add((class_339)widget);
            for (int c = 1; c < columns; ++c) {
                if (i >= capes.size() + 1 - c) continue;
                MSApi.MCProfile.OnlineCape cape2 = (MSApi.MCProfile.OnlineCape)capes.get(i + c - 1);
                Entry widget2 = this.createEntryForCape(this.current.getSkin(), (Cape)cape2, this.capesList.getEntryContentsHeight());
                widgets.add((class_339)widget2);
            }
            rows.add(new Row(widgets));
        }
        this.field_22787.execute(() -> this.capesList.method_25314(rows));
        this.capesList.method_44382(this.capesList.method_44387());
    }

    private void loadSkinsList() {
        MSApi.MCProfile profile = this.cachedProfile;
        int columns = Math.max(2, (this.field_22789 / 2 - 25) / 75);
        ArrayList<Skin> skins = new ArrayList<Skin>(profile.skins());
        Set hashes = skins.stream().map(Asset::sha256).collect(Collectors.toSet());
        Skin defaultSkin = Skin.getDefaultSkin((Account)this.account);
        ArrayList<Skin> local = new ArrayList<Skin>(this.loadLocalSkins());
        Map localHashes = local.stream().collect(Collectors.toMap(Asset::sha256, Function.identity(), (skin, skin2) -> skin));
        local.removeIf(s -> !localHashes.containsValue(s));
        skins.replaceAll(s -> {
            if (s instanceof MSApi.MCProfile.OnlineSkin) {
                Object patt0$temp;
                MSApi.MCProfile.OnlineSkin online = (MSApi.MCProfile.OnlineSkin)s;
                if (localHashes.containsKey(s.sha256()) && (patt0$temp = localHashes.get(s.sha256())) instanceof Skin.LocalSkin) {
                    Skin.LocalSkin file = (Skin.LocalSkin)patt0$temp;
                    local.remove(localHashes.remove(s.sha256()));
                    return new Skin.Shared((Skin.Local)file, online);
                }
            }
            return s;
        });
        skins.addAll(local);
        if (!hashes.contains(defaultSkin.sha256())) {
            skins.add(defaultSkin);
        }
        this.populateSkinList(skins, columns);
        this.skinList.method_44382(this.skinList.method_44387());
    }

    private List<Skin> loadLocalSkins() {
        List<Skin> list;
        block8: {
            Files.createDirectories(SKINS_DIR, new FileAttribute[0]);
            Stream<Path> skins = Files.list(SKINS_DIR);
            try {
                list = skins.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).sorted(Comparator.comparingLong(p -> {
                    try {
                        return Files.getLastModifiedTime(p, new LinkOption[0]).toMillis();
                    }
                    catch (IOException e) {
                        return 0L;
                    }
                }).reversed()).map(Auth.getInstance().getSkinManager()::read).filter(Objects::nonNull).toList();
                if (skins == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (skins != null) {
                        try {
                            skins.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    AxolotlClientCommon.getInstance().getLogger().warn("Failed to read skins dir!", new Object[]{e});
                    return Collections.emptyList();
                }
            }
            skins.close();
        }
        return list;
    }

    private void populateSkinList(List<? extends Skin> skins, int columns) {
        int entryHeight = this.skinList.getEntryContentsHeight();
        ArrayList<Row> rows = new ArrayList<Row>();
        for (int i = 0; i < skins.size(); i += columns) {
            Skin s = skins.get(i);
            if (s != null && s.active()) {
                this.current.setSkin(s);
            }
            Entry widget = this.createEntryForSkin(s, entryHeight);
            ArrayList<class_339> widgets = new ArrayList<class_339>();
            widgets.add((class_339)widget);
            for (int c = 1; c < columns; ++c) {
                if (i >= skins.size() - c) continue;
                Skin s2 = skins.get(i + c);
                if (s2 != null && s2.active()) {
                    this.current.setSkin(s2);
                }
                Entry widget2 = this.createEntryForSkin(s2, entryHeight);
                widgets.add((class_339)widget2);
            }
            rows.add(new Row(widgets));
        }
        this.field_22787.execute(() -> this.skinList.method_25314(rows));
    }

    private Path ensureNonexistent(Path p) {
        if (Files.exists(p, new LinkOption[0])) {
            int counter = 0;
            while (Files.exists(p = p.resolveSibling(p.getFileName().toString() + "_" + ++counter), new LinkOption[0])) {
            }
        }
        return p;
    }

    public void method_29638(List<Path> packs) {
        if (packs.isEmpty()) {
            return;
        }
        CompletableFuture[] futs = new CompletableFuture[packs.size()];
        for (int i = 0; i < packs.size(); ++i) {
            Path p = packs.get(i);
            futs[i] = CompletableFuture.runAsync(() -> {
                try {
                    Path target = this.ensureNonexistent(SKINS_DIR.resolve(p.getFileName()));
                    Skin skin = Auth.getInstance().getSkinManager().read(p, false);
                    if (skin != null) {
                        Files.write(target, skin.image(), new OpenOption[0]);
                    } else {
                        AxolotlClientCommon.getInstance().getLogger().info("Skipping dragged file {} because it does not seem to be a valid skin!", new Object[]{p});
                        Notifications.getInstance().addStatus("skins.notification.title", "skins.notification.not_copied", p.getFileName());
                    }
                }
                catch (IOException e) {
                    AxolotlClientCommon.getInstance().getLogger().warn("Failed to copy skin file: ", new Object[]{e});
                }
            }, (Executor)this.field_22787);
        }
        CompletableFuture.allOf(futs).thenRun(this::loadSkinsList);
    }

    @NotNull
    private Entry createEntryForSkin(Skin skin, int entryHeight) {
        return this.createEntry(entryHeight, new SkinWidget(75, 110, skin, this.account));
    }

    @NotNull
    private Entry createEntryForCape(Skin currentSkin, Cape cape, int entryHeight) {
        return this.createEntry(entryHeight, this.createWidgetForCape(currentSkin, cape), (class_2561)class_2561.method_43470((String)cape.alias()));
    }

    private SkinWidget createWidgetForCape(Skin currentSkin, Cape cape) {
        SkinWidget widget2 = new SkinWidget(75, 110, currentSkin, cape, this.account);
        widget2.setRotationY(210.0f);
        return widget2;
    }

    protected void method_37067() {
        super.method_37067();
        SkinRenderer.closeRenderers();
        Auth.getInstance().getSkinManager().releaseAll();
    }

    public void method_25432() {
        Auth.getInstance().getSkinManager().releaseAll();
        Watcher.close((Watcher)this.skinDirWatcher);
        SkinRenderer.closeRenderers();
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    private SkinListWidget getCurrentList() {
        return this.capesTab ? this.capesList : this.skinList;
    }

    Entry createEntry(int height, SkinWidget widget) {
        return this.createEntry(height, widget, null);
    }

    Entry createEntry(int height, SkinWidget widget, class_2561 label) {
        return new Entry(height, widget, label);
    }

    private static class SkinListWidget
    extends class_4265<Row> {
        public SkinListWidget(class_310 minecraft, int width, int height, int y, int entryHeight) {
            super(minecraft, width, height, y, entryHeight);
        }

        protected int method_65507() {
            return this.method_55442() - 8;
        }

        public int method_25342() {
            return this.method_46426() + 3;
        }

        public int method_25322() {
            if (!this.method_44392()) {
                return this.method_25368() - 4;
            }
            return this.method_25368() - 14;
        }

        public int getEntryContentsHeight() {
            return this.field_62109 - 4;
        }

        @Nullable
        public class_8016 method_48205(class_8023 event) {
            if (!this.field_22763 || !this.field_22764) {
                return null;
            }
            return super.method_48205(event);
        }

        public void method_25314(Collection<Row> newEntries) {
            super.method_25314(newEntries);
        }

        public void centerScrollOn(Row entry) {
            super.method_25324((class_350.class_351)entry);
        }
    }

    private class Entry
    extends class_9017 {
        private final SkinWidget skinWidget;
        @Nullable
        private final class_339 label;
        private final List<class_339> actionButtons;
        private final class_339 equipButton;
        private boolean equipping;
        private long equippingStart;

        public Entry(int height, @Nullable SkinWidget widget, class_2561 label) {
            super(0, 0, widget.method_25368(), height, (class_2561)class_2561.method_43473());
            this.actionButtons = new ArrayList<class_339>();
            widget.method_25358(this.method_25368() - 4);
            Asset asset = widget.getFocusedAsset();
            if (asset != null) {
                class SpriteButton
                extends class_4185 {
                    private class_2960 sprite;

                    public SpriteButton(Entry this$1, class_2561 message, class_4185.class_4241 onPress, class_2960 sprite) {
                        super(0, 0, 11, 11, message, onPress, field_40754);
                        this.sprite = sprite;
                        this.method_47400(class_7919.method_47408((class_2561)message, (class_2561)class_2561.method_43473()));
                    }

                    public void method_25355(class_2561 message) {
                        super.method_25355(message);
                        this.method_47400(class_7919.method_47408((class_2561)message, (class_2561)class_2561.method_43473()));
                    }

                    protected void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {
                        super.method_48579(graphics, mouseX, mouseY, delta);
                        graphics.method_52706(class_10799.field_56883, this.sprite, this.method_46426() + 2, this.method_46427() + 2, 7, 7);
                    }

                    public void method_48589(class_332 guiGraphics, class_327 font, int color) {
                    }
                }
                Asset.Online online;
                if (asset instanceof Skin) {
                    Skin skin = (Skin)asset;
                    class_2960 wideSprite = class_2960.method_60655((String)"axolotlclient", (String)"wide");
                    class_2960 slimSprite = class_2960.method_60655((String)"axolotlclient", (String)"slim");
                    class_5250 slimText = class_2561.method_43471((String)"skins.manage.variant.classic");
                    class_5250 wideText = class_2561.method_43471((String)"skins.manage.variant.slim");
                    this.actionButtons.add((class_339)new SpriteButton(this, (class_2561)(skin.classicVariant() ? wideText : slimText), btn -> {
                        SpriteButton self = (SpriteButton)btn;
                        skin.classicVariant(!skin.classicVariant());
                        self.sprite = skin.classicVariant() ? slimSprite : wideSprite;
                        self.method_25355((class_2561)(skin.classicVariant() ? wideText : slimText));
                    }, skin.classicVariant() ? slimSprite : wideSprite));
                }
                if (asset instanceof Asset.Local) {
                    Asset.Local local = (Asset.Local)asset;
                    this.actionButtons.add((class_339)new SpriteButton(this, (class_2561)class_2561.method_43471((String)"skins.manage.delete"), btn -> {
                        btn.field_22763 = false;
                        SkinManagementScreen.this.field_22787.method_1507((class_437)new class_410(confirmed -> {
                            SkinManagementScreen.this.field_22787.method_1507((class_437)new LoadingScreen(SkinManagementScreen.this.method_25440(), (class_2561)class_2561.method_43471((String)"menu.working")));
                            if (confirmed) {
                                try {
                                    Files.delete(local.file());
                                    Skin.LocalSkin.deleteMetadata((Path)local.file());
                                    SkinManagementScreen.this.refreshCurrentList();
                                }
                                catch (IOException e) {
                                    AxolotlClientCommon.getInstance().getLogger().warn("Failed to delete: ", new Object[]{e});
                                }
                            }
                            SkinManagementScreen.this.field_22787.method_1507((class_437)SkinManagementScreen.this);
                            btn.field_22763 = true;
                        }, (class_2561)class_2561.method_43471((String)"skins.manage.delete.confirm"), (class_2561)(asset.active() ? class_2561.method_43471((String)"skins.manage.delete.confirm.desc_active") : class_2561.method_43471((String)"skins.manage.delete.confirm.desc")).method_54663(Colors.RED.toInt())));
                    }, class_2960.method_60655((String)"axolotlclient", (String)"delete")));
                }
                if (asset instanceof Asset.Online && (online = (Asset.Online)asset).supportsDownload() && !(asset instanceof Asset.Local)) {
                    this.actionButtons.add((class_339)new SpriteButton(this, (class_2561)class_2561.method_43471((String)"skins.manage.download"), btn -> {
                        btn.field_22763 = false;
                        this.download(asset).thenRun(() -> {
                            SkinManagementScreen.this.refreshCurrentList();
                            btn.field_22763 = true;
                        });
                    }, class_2960.method_60655((String)"axolotlclient", (String)"download")));
                }
            }
            if (label != null) {
                this.label = new class_8130(this, 0, 0, widget.method_25368(), 16, label, class_310.method_1551().field_1772){

                    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
                        this.method_49604(guiGraphics, this.method_48977(), 2, -1);
                    }
                };
                this.label.field_22763 = false;
            } else {
                this.label = null;
            }
            this.equipButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)(widget.isEquipped() ? "skins.manage.equipped" : "skins.manage.equip")), btn -> {
                this.equippingStart = class_156.method_658();
                this.equipping = true;
                btn.method_25355(TEXT_EQUIPPING);
                btn.field_22763 = false;
                Consumer<CompletableFuture> consumer = f -> ((CompletableFuture)f.thenAcceptAsync(p -> {
                    SkinManagementScreen.this.cachedProfile = p;
                    if (((SkinManagementScreen)SkinManagementScreen.this).field_22787.field_1755 == SkinManagementScreen.this) {
                        SkinManagementScreen.this.refreshCurrentList();
                    } else {
                        SkinManagementScreen.this.field_22787.execute(() -> SkinManagementScreen.this.field_22787.method_1507((class_437)SkinManagementScreen.this));
                    }
                })).exceptionally(t -> {
                    AxolotlClientCommon.getInstance().getLogger().warn("Failed to equip asset!", new Object[]{t});
                    this.equipping = false;
                    return null;
                });
                if (asset instanceof Skin && !(SkinManagementScreen.this.current.getSkin() instanceof Skin.Local)) {
                    SkinManagementScreen.this.field_22787.method_1507((class_437)new class_410(confirmed -> {
                        SkinManagementScreen.this.field_22787.method_1507((class_437)new LoadingScreen(SkinManagementScreen.this.method_25440(), TEXT_EQUIPPING));
                        if (confirmed) {
                            consumer.accept((CompletableFuture)this.download((Asset)SkinManagementScreen.this.current.getSkin()).thenCompose(a -> widget.equip()));
                        } else {
                            consumer.accept(widget.equip());
                        }
                    }, (class_2561)class_2561.method_43471((String)"skins.manage.equip.confirm"), (class_2561)class_2561.method_43471((String)"skins.manage.equip.download_current")));
                } else {
                    consumer.accept(widget.equip());
                }
            }).method_46432(widget.method_25368()).method_46431();
            this.equipButton.field_22763 = !widget.isEquipped();
            this.skinWidget = widget;
        }

        @NotNull
        private CompletableFuture<?> download(Asset asset) {
            return CompletableFuture.runAsync(() -> {
                try {
                    Path out = SKINS_DIR.resolve(asset.sha256());
                    Files.createDirectories(out.getParent(), new FileAttribute[0]);
                    Files.write(out, asset.image(), new OpenOption[0]);
                    if (asset instanceof Skin) {
                        Skin skin = (Skin)asset;
                        Skin.LocalSkin.writeMetadata((Path)out, Map.of("variant_classic", skin.classicVariant()));
                    }
                }
                catch (IOException e) {
                    AxolotlClientCommon.getInstance().getLogger().warn("Failed to download: ", new Object[]{e});
                }
            });
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            return Stream.concat(this.actionButtons.stream(), Stream.of(new class_339[]{this.skinWidget, this.label, this.equipButton})).filter(Objects::nonNull).toList();
        }

        protected int method_44395() {
            return this.method_25364();
        }

        protected double method_44393() {
            return 0.0;
        }

        private float applyEasing(float x) {
            return x * x * x;
        }

        protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            int y = this.method_46427() + 4;
            int x = this.method_46426() + 2;
            this.skinWidget.method_48229(x, y);
            this.skinWidget.method_25358(this.method_25368() - 4);
            if (this.skinWidget.isEquipped() || this.equipping) {
                long prog = ((Boolean)Auth.getInstance().skinManagerAnimations.get()).booleanValue() ? (this.equipping ? (class_156.method_658() - this.equippingStart) / 20L % 100L : Math.abs(class_156.method_658() / 30L % 200L - 100L)) : 100L;
                float percent = (float)prog / 100.0f;
                float gradientWidth = this.equipping ? percent * Math.min((float)this.method_25368() / 3.0f, (float)this.method_25364() / 3.0f) : Math.min((float)this.method_25368() / 15.0f, (float)this.method_25364() / 6.0f) + this.applyEasing(percent) * Math.min((float)(this.method_25368() * 2) / 15.0f, (float)this.method_25364() / 6.0f);
                GradientHoleRectangleRenderState.create(guiGraphics, this.method_46426() + 2, this.method_46427() + 2, this.method_55442() - 2, this.skinWidget.method_55443() + 2, gradientWidth, this.equipping ? -65400 : ClientColors.SELECTOR_GREEN.toInt(), 0).submit();
            }
            this.skinWidget.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            int actionButtonY = this.method_46427() + 2;
            for (class_339 button : this.actionButtons) {
                button.method_48229(this.skinWidget.method_55442() - button.method_25368(), actionButtonY);
                if (this.method_49606() || button.method_25367()) {
                    button.method_25394(guiGraphics, mouseX, mouseY, partialTick);
                }
                actionButtonY += button.method_25364() + 2;
            }
            if (this.label != null) {
                this.label.method_48229(x, this.skinWidget.method_55443() + 6);
                this.label.method_25394(guiGraphics, mouseX, mouseY, partialTick);
                this.label.method_25358(this.method_25368() - 4);
                this.equipButton.method_48229(x, this.label.method_55443() + 2);
            } else {
                this.equipButton.method_48229(x, this.skinWidget.method_55443() + 4);
            }
            this.equipButton.method_25358(this.method_25368() - 4);
            this.equipButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            if (this.method_49606()) {
                DrawUtil.outlineRect(guiGraphics, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), -1);
            }
        }

        protected void method_47399(class_6382 narrationElementOutput) {
            this.skinWidget.method_37020(narrationElementOutput);
            this.actionButtons.forEach(w -> w.method_37020(narrationElementOutput));
            if (this.label != null) {
                this.label.method_37020(narrationElementOutput);
            }
            this.equipButton.method_37020(narrationElementOutput);
        }

        private static final class GradientHoleRectangleRenderState
        extends Record
        implements class_11244 {
            private final RenderPipeline pipeline;
            private final class_11231 textureSetup;
            private final Matrix3x2f pose;
            private final int x0;
            private final int y0;
            private final int x1;
            private final int y1;
            private final float gradientWidth;
            private final int col1;
            private final int col2;
            @Nullable
            private final class_8030 scissorArea;
            @Nullable
            private final class_8030 bounds;

            private GradientHoleRectangleRenderState(RenderPipeline pipeline, class_11231 textureSetup, Matrix3x2f pose, int x0, int y0, int x1, int y1, float gradientWidth, int col1, int col2, @Nullable class_8030 scissorArea, @Nullable class_8030 bounds) {
                this.pipeline = pipeline;
                this.textureSetup = textureSetup;
                this.pose = pose;
                this.x0 = x0;
                this.y0 = y0;
                this.x1 = x1;
                this.y1 = y1;
                this.gradientWidth = gradientWidth;
                this.col1 = col1;
                this.col2 = col2;
                this.scissorArea = scissorArea;
                this.bounds = bounds;
            }

            public static GradientHoleRectangleRenderState create(class_332 graphics, int x0, int y0, int x1, int y1, float gradientWidth, int col1, int col2) {
                Matrix3x2f matrix = new Matrix3x2f((Matrix3x2fc)graphics.method_51448());
                class_8030 area = ((GuiGraphicsAccessor)graphics).getScissorStack().method_70863();
                return new GradientHoleRectangleRenderState(class_10799.field_56879, class_11231.method_70899(), matrix, x0, y0, x1, y1, gradientWidth, col1, col2, area, GradientHoleRectangleRenderState.getBounds(x0, y0, x1, y1, matrix, area));
            }

            public void submit() {
                ((GameRendererAccessor)class_310.method_1551().field_1773).getGuiRenderState().method_70919((class_11244)this);
            }

            public void method_70917(class_4588 vertexConsumer) {
                vertexConsumer.method_70815(this.pose(), (float)this.x0(), (float)this.y0()).method_39415(this.col1());
                vertexConsumer.method_70815(this.pose(), (float)this.x0() + this.gradientWidth(), (float)this.y0() + this.gradientWidth()).method_39415(this.col2());
                vertexConsumer.method_70815(this.pose(), (float)this.x1() - this.gradientWidth(), (float)this.y0() + this.gradientWidth()).method_39415(this.col2());
                vertexConsumer.method_70815(this.pose(), (float)this.x1(), (float)this.y0()).method_39415(this.col1());
                vertexConsumer.method_70815(this.pose(), (float)this.x0(), (float)this.y1()).method_39415(this.col1());
                vertexConsumer.method_70815(this.pose(), (float)this.x0() + this.gradientWidth(), (float)this.y1() - this.gradientWidth()).method_39415(this.col2());
                vertexConsumer.method_70815(this.pose(), (float)this.x0() + this.gradientWidth(), (float)this.y0() + this.gradientWidth()).method_39415(this.col2());
                vertexConsumer.method_70815(this.pose(), (float)this.x0(), (float)this.y0()).method_39415(this.col1());
                vertexConsumer.method_70815(this.pose(), (float)this.x1(), (float)this.y1()).method_39415(this.col1());
                vertexConsumer.method_70815(this.pose(), (float)this.x1() - this.gradientWidth(), (float)this.y1() - this.gradientWidth()).method_39415(this.col2());
                vertexConsumer.method_70815(this.pose(), (float)this.x0() + this.gradientWidth(), (float)this.y1() - this.gradientWidth()).method_39415(this.col2());
                vertexConsumer.method_70815(this.pose(), (float)this.x0(), (float)this.y1()).method_39415(this.col1());
                vertexConsumer.method_70815(this.pose(), (float)this.x1(), (float)this.y0()).method_39415(this.col1());
                vertexConsumer.method_70815(this.pose(), (float)this.x1() - this.gradientWidth(), (float)this.y0() + this.gradientWidth()).method_39415(this.col2());
                vertexConsumer.method_70815(this.pose(), (float)this.x1() - this.gradientWidth(), (float)this.y1() - this.gradientWidth()).method_39415(this.col2());
                vertexConsumer.method_70815(this.pose(), (float)this.x1(), (float)this.y1()).method_39415(this.col1());
            }

            @Nullable
            private static class_8030 getBounds(int i, int j, int k, int l, Matrix3x2f matrix3x2f, @Nullable class_8030 screenRectangle) {
                class_8030 screenRectangle2 = new class_8030(i, j, k - i, l - j).method_71523(matrix3x2f);
                return screenRectangle != null ? screenRectangle.method_49701(screenRectangle2) : screenRectangle2;
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{GradientHoleRectangleRenderState.class, "pipeline;textureSetup;pose;x0;y0;x1;y1;gradientWidth;col1;col2;scissorArea;bounds", "pipeline", "textureSetup", "pose", "x0", "y0", "x1", "y1", "gradientWidth", "col1", "col2", "scissorArea", "bounds"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{GradientHoleRectangleRenderState.class, "pipeline;textureSetup;pose;x0;y0;x1;y1;gradientWidth;col1;col2;scissorArea;bounds", "pipeline", "textureSetup", "pose", "x0", "y0", "x1", "y1", "gradientWidth", "col1", "col2", "scissorArea", "bounds"}, this);
            }

            @Override
            public final boolean equals(Object o) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{GradientHoleRectangleRenderState.class, "pipeline;textureSetup;pose;x0;y0;x1;y1;gradientWidth;col1;col2;scissorArea;bounds", "pipeline", "textureSetup", "pose", "x0", "y0", "x1", "y1", "gradientWidth", "col1", "col2", "scissorArea", "bounds"}, this, o);
            }

            public RenderPipeline comp_4055() {
                return this.pipeline;
            }

            public class_11231 comp_4056() {
                return this.textureSetup;
            }

            public Matrix3x2f pose() {
                return this.pose;
            }

            public int x0() {
                return this.x0;
            }

            public int y0() {
                return this.y0;
            }

            public int x1() {
                return this.x1;
            }

            public int y1() {
                return this.y1;
            }

            public float gradientWidth() {
                return this.gradientWidth;
            }

            public int col1() {
                return this.col1;
            }

            public int col2() {
                return this.col2;
            }

            @Nullable
            public class_8030 comp_4069() {
                return this.scissorArea;
            }

            @Nullable
            public class_8030 comp_4274() {
                return this.bounds;
            }
        }
    }

    private class Row
    extends class_4265.class_4266<Row> {
        private final List<class_339> widgets;

        public Row(List<class_339> entries) {
            this.widgets = entries;
        }

        @NotNull
        public List<? extends class_6379> method_37025() {
            return this.widgets;
        }

        public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovering, float partialTick) {
            int x = this.method_46426();
            if (this.widgets.isEmpty()) {
                return;
            }
            int count = this.widgets.size();
            int padding = (this.method_25368() - 5 * (count - 1)) / count;
            for (class_339 w : this.widgets) {
                w.method_48229(x, this.method_73382());
                w.method_25358(padding);
                w.method_25394(guiGraphics, mouseX, mouseY, partialTick);
                x += w.method_25368() + 5;
            }
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            return this.widgets;
        }

        public void method_25395(@Nullable class_364 focused) {
            super.method_25395(focused);
            if (focused != null) {
                SkinManagementScreen.this.getCurrentList().centerScrollOn(this);
            }
        }
    }
}

