/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.auth.skin;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.axolotlclient.modules.auth.skin.SkinRenderState;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_11239;
import net.minecraft.class_1921;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5602;
import net.minecraft.class_591;
import net.minecraft.class_7833;
import net.minecraft.class_9950;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4fStack;
import org.joml.Quaternionfc;

public class SkinRenderer
extends class_11239<SkinRenderState> {
    private static final Map<String, SkinRenderer> renderers = new ConcurrentHashMap<String, SkinRenderer>();
    private class_591 classicModel;
    private class_591 slimModel;
    private class_9950 capeModel;
    private final class_310 minecraft;
    private final String id;

    public static void closeRenderers() {
        renderers.values().forEach(class_11239::close);
        renderers.clear();
    }

    public static SkinRenderer getOrCreate(class_4597.class_4598 bufferSource, class_310 minecraft, String id) {
        return renderers.computeIfAbsent(id, _id -> new SkinRenderer(bufferSource, minecraft, id));
    }

    private SkinRenderer(class_4597.class_4598 bufferSource, class_310 minecraft, String id) {
        super(bufferSource);
        this.minecraft = minecraft;
        this.id = id;
    }

    @NotNull
    public Class<SkinRenderState> method_70903() {
        return SkinRenderState.class;
    }

    protected void renderToTexture(SkinRenderState renderState, class_4587 poseStack) {
        if (this.classicModel == null && renderState.classicVariant()) {
            this.classicModel = new class_591(this.minecraft.method_31974().method_32072(class_5602.field_27577), false);
        }
        if (this.slimModel == null && !renderState.classicVariant()) {
            this.slimModel = new class_591(this.minecraft.method_31974().method_32072(class_5602.field_27581), true);
        }
        class_310.method_1551().field_1773.method_71114().method_71034(class_308.class_11274.field_60029);
        int i = class_310.method_1551().method_22683().method_4495();
        Matrix4fStack matrix4fStack = RenderSystem.getModelViewStack();
        matrix4fStack.pushMatrix();
        float f = renderState.comp_4133() * (float)i;
        matrix4fStack.rotateAround((Quaternionfc)class_7833.field_40714.rotationDegrees(renderState.rotationX()), 0.0f, f * -renderState.pivotY(), 0.0f);
        poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(-renderState.rotationY()));
        poseStack.method_46416(0.0f, -1.6010001f, 0.0f);
        class_591 model = renderState.classicVariant() ? this.classicModel : this.slimModel;
        class_1921 renderType = model.method_23500(renderState.skinTexture());
        model.method_60879(poseStack, this.field_59933.method_73477(renderType), 0xF000F0, class_4608.field_21444);
        if (renderState.cape() != null) {
            if (this.capeModel == null) {
                this.capeModel = new class_9950(this.minecraft.method_31974().method_32072(class_5602.field_52980));
            }
            class_1921 type = this.capeModel.method_23500(renderState.cape());
            poseStack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(6.0f));
            this.capeModel.method_60879(poseStack, this.field_59933.method_73477(type), 0xF000F0, class_4608.field_21444);
        }
        this.field_59933.method_22993();
        matrix4fStack.popMatrix();
    }

    @NotNull
    protected String method_70906() {
        return "axolotlclient/skin_render/" + this.id;
    }
}

