/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.auth.skin;

import io.github.axolotlclient.bridge.util.AxoIdentifier;
import io.github.axolotlclient.mixin.GuiGraphicsAccessor;
import io.github.axolotlclient.modules.auth.Account;
import io.github.axolotlclient.modules.auth.Auth;
import io.github.axolotlclient.modules.auth.MSApi;
import io.github.axolotlclient.modules.auth.skin.Asset;
import io.github.axolotlclient.modules.auth.skin.Cape;
import io.github.axolotlclient.modules.auth.skin.Skin;
import io.github.axolotlclient.modules.auth.skin.SkinManager;
import io.github.axolotlclient.modules.auth.skin.SkinRenderState;
import io.github.axolotlclient.modules.auth.skin.SkinRenderer;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import net.minecraft.class_11256;
import net.minecraft.class_1144;
import net.minecraft.class_11909;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_5244;
import net.minecraft.class_6382;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import org.jetbrains.annotations.Nullable;

public class SkinWidget
extends class_339 {
    private static final float MODEL_HEIGHT = 2.125f;
    private static final float FIT_SCALE = 0.97f;
    private static final float ROTATION_SENSITIVITY = 2.5f;
    private static final float DEFAULT_ROTATION_X = -5.0f;
    private static final float DEFAULT_ROTATION_Y = 30.0f;
    private static final float ROTATION_X_LIMIT = 50.0f;
    private float rotationX = -5.0f;
    private float rotationY = 30.0f;
    private Skin skin;
    private Cape cape;
    private final Account owner;
    private boolean noCape;
    private boolean noCapeActive;

    public SkinWidget(int width, int height, Skin skin, @Nullable Cape cape, Account owner) {
        super(0, 0, width, height, class_5244.field_39003);
        this.skin = skin;
        this.cape = cape;
        this.owner = owner;
    }

    public SkinWidget(int width, int height, Skin skin, Account owner) {
        this(width, height, skin, null, owner);
    }

    public void noCape(boolean noCapeActive) {
        this.noCape = true;
        this.noCapeActive = noCapeActive;
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_310 minecraft = class_310.method_1551();
        float scale = 0.97f * (float)this.method_25364() / 2.125f;
        float pivotY = -1.0625f;
        SkinManager skinManager = Auth.getInstance().getSkinManager();
        AxoIdentifier skinRl = skinManager.loadSkin(this.skin);
        boolean classic = this.skin.classicVariant();
        AxoIdentifier capeRl = this.cape == null ? null : skinManager.loadCape(this.cape);
        SkinRenderer renderer = SkinRenderer.getOrCreate(minecraft.method_22940().method_23000(), minecraft, "" + ((Object)((Object)this)).hashCode());
        ((GuiGraphicsAccessor)guiGraphics).getGuiRenderState().method_70922((class_11256)new SkinRenderState(classic, (class_2960)skinRl, (class_2960)capeRl, this.rotationX, this.rotationY, pivotY, this.method_46426(), this.method_46427(), this.method_55442(), this.method_55443(), scale, guiGraphics.field_44659.method_70863(), renderer));
    }

    protected void method_25349(class_11909 mouseButtonEvent, double dragX, double dragY) {
        this.rotationX = class_3532.method_15363((float)(this.rotationX - (float)dragY * 2.5f), (float)-50.0f, (float)50.0f);
        this.rotationY += (float)dragX * 2.5f;
    }

    public void method_25354(class_1144 handler) {
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }

    @Nullable
    public class_8016 method_48205(class_8023 event) {
        return null;
    }

    public boolean isEquipped() {
        return this.noCape ? this.noCapeActive : (this.cape != null ? this.cape.active() : this.skin != null && this.skin.active());
    }

    public CompletableFuture<MSApi.MCProfile> equip() {
        MSApi msApi = Auth.getInstance().getMsApi();
        if (this.noCape) {
            return msApi.hideCape(this.owner);
        }
        if (this.cape != null) {
            return this.cape.equip(msApi, this.owner);
        }
        if (this.skin != null) {
            return this.skin.equip(msApi, this.owner);
        }
        return msApi.resetSkin(this.owner);
    }

    public Asset getFocusedAsset() {
        return this.noCape ? null : (this.cape != null ? this.cape : this.skin);
    }

    @Generated
    public void setRotationY(float rotationY) {
        this.rotationY = rotationY;
    }

    @Generated
    public Skin getSkin() {
        return this.skin;
    }

    @Generated
    public void setSkin(Skin skin) {
        this.skin = skin;
    }

    @Generated
    public Cape getCape() {
        return this.cape;
    }

    @Generated
    public void setCape(Cape cape) {
        this.cape = cape;
    }
}

