/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.hud.gui.hud;

import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.bridge.render.AxoRenderContext;
import io.github.axolotlclient.modules.hud.gui.entry.TextHudEntry;
import io.github.axolotlclient.modules.hud.util.DrawPosition;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3262;
import net.minecraft.class_3268;
import net.minecraft.class_332;
import net.minecraft.class_7367;
import net.minecraft.class_7417;

public class PackDisplayHud
extends TextHudEntry {
    public static final class_2960 ID = class_2960.method_60655((String)"axolotlclient", (String)"packdisplayhud");
    public final List<PackWidget> widgets = new ArrayList<PackWidget>();
    private final BooleanOption iconsOnly = new BooleanOption("iconsonly", Boolean.valueOf(false));
    private PackWidget placeholder;
    private final class_310 client;

    public PackDisplayHud() {
        super(200, 50, true);
        this.client = (class_310)((TextHudEntry)this).client;
    }

    public void renderComponent(AxoRenderContext context, float f) {
        class_332 graphics = (class_332)context;
        DrawPosition pos = this.getPos();
        if (this.widgets.isEmpty()) {
            this.init();
        }
        if (((Boolean)this.background.get()).booleanValue()) {
            DrawUtil.fillRect(graphics, this.getBounds(), this.backgroundColor.get());
        }
        if (((Boolean)this.outline.get()).booleanValue()) {
            DrawUtil.outlineRect(graphics, this.getBounds(), this.outlineColor.get());
        }
        int y = pos.y() + 1;
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            this.widgets.get(i).render(graphics, pos.x() + 1, y);
            y += 18;
        }
        if (y - pos.y() + 1 != this.getHeight()) {
            this.setHeight(y - pos.y() - 1);
            this.onBoundsUpdate();
        }
    }

    public void init() {
        int listSize = this.client.method_1520().method_14444().size();
        this.client.method_1520().method_14444().forEach(profile -> {
            try (class_3262 pack = profile.method_14458();){
                class_2588 tr;
                class_7417 patt0$temp = pack.method_56926().comp_2330().method_10851();
                if (patt0$temp instanceof class_2588 && (tr = (class_2588)patt0$temp).method_11022().matches("pack\\.name\\.fabricMods?")) {
                    return;
                }
                if (listSize == 1) {
                    this.widgets.add(this.createWidget(profile.method_14457(), pack));
                } else if (!pack.method_14409().equalsIgnoreCase("vanilla")) {
                    this.widgets.add(this.createWidget(profile.method_14457(), pack));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        AtomicInteger w = new AtomicInteger(20);
        this.widgets.forEach(packWidget -> {
            int textW = this.client.field_1772.method_1727(packWidget.getName()) + 20;
            if (textW > w.get()) {
                w.set(textW);
            }
        });
        this.setWidth(w.get());
        this.setHeight(this.widgets.size() * 18);
        this.onBoundsUpdate();
    }

    private PackWidget createWidget(class_2561 displayName, class_3262 pack) throws IOException, AssertionError {
        class_7367 supplier = pack.method_14410(new String[]{"pack.png"});
        assert (supplier != null);
        InputStream stream = (InputStream)supplier.get();
        class_2960 id = class_2960.method_60655((String)ID.method_12836(), (String)(ID.method_12832() + "/" + pack.method_14409()));
        this.client.method_1531().method_4616(id, (class_1044)new class_1043(() -> ((class_2960)id).toString(), class_1011.method_4309((InputStream)stream)));
        stream.close();
        return new PackWidget(displayName, id);
    }

    public void renderPlaceholderComponent(AxoRenderContext graphics, float f) {
        boolean updateBounds = false;
        if (this.getHeight() < 18) {
            this.setHeight(18);
            updateBounds = true;
        }
        if (this.getWidth() < 56) {
            this.setWidth(56);
            updateBounds = true;
        }
        if (updateBounds) {
            this.onBoundsUpdate();
        }
        if (this.placeholder == null) {
            try (class_3268 defaultPack = this.client.method_45573();){
                this.placeholder = this.createWidget((class_2561)class_2561.method_43470((String)defaultPack.method_14409()), (class_3262)defaultPack);
            }
            catch (Exception exception) {}
        } else {
            this.placeholder.render((class_332)graphics, this.getPos().x() + 1, this.getPos().y() + 1);
        }
    }

    public List<Option<?>> getConfigurationOptions() {
        List options = super.getConfigurationOptions();
        options.add(this.iconsOnly);
        return options;
    }

    public class_2960 getId() {
        return ID;
    }

    public void update() {
        this.widgets.clear();
        this.init();
    }

    public class PackWidget {
        public final String name;
        private final class_2960 texture;

        public PackWidget(class_2561 name, class_2960 id) {
            this.name = name.getString();
            this.texture = id;
        }

        public void render(class_332 graphics, int x, int y) {
            if (!((Boolean)PackDisplayHud.this.iconsOnly.get()).booleanValue()) {
                graphics.method_25290(class_10799.field_56883, this.texture, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
            }
            DrawUtil.drawString(graphics, this.name, x + 18, y + 6, PackDisplayHud.this.textColor.get().toInt(), (boolean)((Boolean)PackDisplayHud.this.shadow.get()));
        }

        @Generated
        public String getName() {
            return this.name;
        }
    }
}

